/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.pool.migration;

import diskCacheV111.vehicles.PoolManagerGetPoolsByNameMessage;
import diskCacheV111.vehicles.PoolManagerGetPoolsMessage;
import diskCacheV111.vehicles.PoolManagerPoolInformation;
import java.util.Collection;
import org.dcache.cells.CellStub;
import org.dcache.pool.migration.PoolListFromPoolManager;

public class PoolListByNames
extends PoolListFromPoolManager {
    private final CellStub _poolManager;
    private final Collection<String> _names;

    public PoolListByNames(CellStub poolManager, Collection<String> pools) {
        this._poolManager = poolManager;
        this._names = pools;
    }

    @Override
    public void refresh() {
        this._poolManager.send(new PoolManagerGetPoolsByNameMessage(this._names), PoolManagerGetPoolsMessage.class, this);
    }

    public String toString() {
        if (this._pools.isEmpty()) {
            return "";
        }
        StringBuilder s = new StringBuilder();
        s.append(((PoolManagerPoolInformation)this._pools.get(0)).getName());
        for (int i = 1; i < this._pools.size(); ++i) {
            s.append(',').append(((PoolManagerPoolInformation)this._pools.get(i)).getName());
        }
        return s.toString();
    }
}

