/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.pool.migration;

import diskCacheV111.pools.PoolV2Mode;
import diskCacheV111.util.CacheException;
import diskCacheV111.util.CacheFileAvailable;
import diskCacheV111.util.DiskErrorCacheException;
import diskCacheV111.util.LockedCacheException;
import diskCacheV111.util.PnfsId;
import diskCacheV111.vehicles.Message;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.CellPath;
import dmg.cells.nucleus.NoRouteToCellException;
import java.io.IOException;
import java.io.Serializable;
import java.security.NoSuchAlgorithmException;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.dcache.cells.AbstractCellComponent;
import org.dcache.cells.CellMessageReceiver;
import org.dcache.pool.classic.ChecksumModule;
import org.dcache.pool.migration.MigrationModule;
import org.dcache.pool.migration.PoolMigrationCancelMessage;
import org.dcache.pool.migration.PoolMigrationCopyFinishedMessage;
import org.dcache.pool.migration.PoolMigrationCopyReplicaMessage;
import org.dcache.pool.migration.PoolMigrationPingMessage;
import org.dcache.pool.p2p.P2PClient;
import org.dcache.pool.repository.EntryState;
import org.dcache.pool.repository.IllegalTransitionException;
import org.dcache.pool.repository.ReplicaDescriptor;
import org.dcache.pool.repository.Repository;
import org.dcache.pool.repository.StickyRecord;
import org.dcache.vehicles.FileAttributes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrationModuleServer
extends AbstractCellComponent
implements CellMessageReceiver {
    private static final Logger _log = LoggerFactory.getLogger(MigrationModuleServer.class);
    private Map<UUID, Request> _requests = new ConcurrentHashMap<UUID, Request>();
    private P2PClient _p2p;
    private Repository _repository;
    private ExecutorService _executor;
    private ChecksumModule _checksumModule;
    private MigrationModule _migration;
    private PoolV2Mode _poolMode;

    public void setExecutor(ExecutorService executor) {
        this._executor = executor;
    }

    public void setPPClient(P2PClient p2p) {
        this._p2p = p2p;
    }

    public void setRepository(Repository repository) {
        this._repository = repository;
    }

    public synchronized void setChecksumModule(ChecksumModule csm) {
        this._checksumModule = csm;
    }

    public void setMigrationModule(MigrationModule migration) {
        this._migration = migration;
    }

    public void setPoolMode(PoolV2Mode mode) {
        this._poolMode = mode;
    }

    public Message messageArrived(CellMessage envelope, PoolMigrationCopyReplicaMessage message) throws CacheException, IOException, InterruptedException {
        if (message.isReply()) {
            return null;
        }
        if (envelope.getLocalAge() >= envelope.getTtl()) {
            _log.warn("PoolMigrationCopyReplica message discarded: TTL exceeded");
            return null;
        }
        if (this._poolMode.isDisabled(16)) {
            throw new CacheException(104, "Pool is disabled");
        }
        if (this._migration.isActive(message.getPnfsId())) {
            throw new LockedCacheException("Target file is busy");
        }
        Request request = new Request((CellPath)envelope.getSourcePath().clone(), message);
        this._requests.put(request.getUUID(), request);
        request.start();
        message.setSucceeded();
        return message;
    }

    public Message messageArrived(PoolMigrationPingMessage message) {
        if (message.isReply()) {
            return null;
        }
        UUID uuid = message.getUUID();
        if (this._requests.containsKey(uuid)) {
            message.setSucceeded();
        } else {
            message.setFailed(10015, (Serializable)((Object)"No such request"));
        }
        return message;
    }

    public Message messageArrived(PoolMigrationCancelMessage message) throws CacheException {
        if (message.isReply()) {
            return null;
        }
        UUID uuid = message.getUUID();
        Request request = this._requests.get(uuid);
        if (request == null || !request.cancel()) {
            throw new CacheException(10015, "No such request");
        }
        message.setSucceeded();
        return message;
    }

    private class Request
    implements CacheFileAvailable,
    Runnable {
        private final CellPath _requestor;
        private final UUID _uuid;
        private final PnfsId _pnfsId;
        private final FileAttributes _fileAttributes;
        private final List<StickyRecord> _stickyRecords;
        private final EntryState _targetState;
        private final String _pool;
        private final boolean _computeChecksumOnUpdate;
        private final boolean _forceSourceMode;
        private Integer _companion;
        private Future<?> _updateTask;

        public Request(CellPath requestor, PoolMigrationCopyReplicaMessage message) {
            this._requestor = requestor;
            this._pnfsId = message.getPnfsId();
            this._fileAttributes = message.getFileAttributes();
            this._stickyRecords = message.getStickyRecords();
            this._targetState = message.getState();
            this._pool = message.getPool();
            this._computeChecksumOnUpdate = message.getComputeChecksumOnUpdate();
            this._forceSourceMode = message.isForceSourceMode();
            if (this._targetState != EntryState.PRECIOUS && this._targetState != EntryState.CACHED) {
                throw new IllegalArgumentException("State must be either CACHED or PRECIOUS");
            }
            this._uuid = message.getUUID() != null ? message.getUUID() : UUID.randomUUID();
        }

        public synchronized UUID getUUID() {
            return this._uuid;
        }

        public synchronized String getPool() {
            return this._pool;
        }

        public synchronized void start() throws IOException, CacheException, InterruptedException {
            EntryState state = MigrationModuleServer.this._repository.getState(this._pnfsId);
            if (state == EntryState.NEW) {
                this._companion = MigrationModuleServer.this._p2p.newCompanion(this._pool, this._fileAttributes, this._targetState, this._stickyRecords, this, this._forceSourceMode);
            } else {
                this._updateTask = MigrationModuleServer.this._executor.submit(this);
            }
        }

        public synchronized boolean cancel() {
            if (this._companion != null) {
                return MigrationModuleServer.this._p2p.cancel(this._companion);
            }
            if (this._updateTask != null && this._updateTask.cancel(true)) {
                if (MigrationModuleServer.this._requests.remove(this._uuid) != null) {
                    this.finished(new CacheException("Task was cancelled"));
                }
                return true;
            }
            return false;
        }

        protected synchronized void finished(Throwable e) {
            PoolMigrationCopyFinishedMessage message = new PoolMigrationCopyFinishedMessage(this._uuid, this._pool, this._pnfsId);
            if (e != null) {
                if (e instanceof CacheException) {
                    CacheException ce = (CacheException)e;
                    message.setFailed(ce.getRc(), (Serializable)((Object)ce.getMessage()));
                } else {
                    message.setFailed(10011, e);
                }
            }
            try {
                MigrationModuleServer.this.sendMessage(new CellMessage(this._requestor.revert(), (Serializable)message));
            }
            catch (NoRouteToCellException f) {
                _log.error("Transfer completed, but failed to send acknowledgment: " + f.toString());
            }
        }

        @Override
        public synchronized void cacheFileAvailable(PnfsId pnfsId, Throwable e) {
            MigrationModuleServer.this._requests.remove(this._uuid);
            this.finished(e);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                if (this._computeChecksumOnUpdate) {
                    try (ReplicaDescriptor handle = MigrationModuleServer.this._repository.openEntry(this._pnfsId, EnumSet.of(Repository.OpenFlags.NOATIME));){
                        MigrationModuleServer.this._checksumModule.verifyChecksum(handle);
                    }
                }
                EntryState state = MigrationModuleServer.this._repository.getState(this._pnfsId);
                switch (state) {
                    case CACHED: {
                        if (this._targetState == EntryState.PRECIOUS) {
                            MigrationModuleServer.this._repository.setState(this._pnfsId, EntryState.PRECIOUS);
                        }
                    }
                    case PRECIOUS: {
                        for (StickyRecord record : this._stickyRecords) {
                            MigrationModuleServer.this._repository.setSticky(this._pnfsId, record.owner(), record.expire(), false);
                        }
                        break;
                    }
                    default: {
                        this.finished(new CacheException("Cannot update file in state " + (Object)((Object)state)));
                    }
                }
                this.finished(null);
            }
            catch (IOException e) {
                this.finished(new DiskErrorCacheException("I/O error during checksum calculation: " + e.getMessage()));
            }
            catch (InterruptedException e) {
                this.finished(new CacheException("Task was cancelled"));
            }
            catch (IllegalTransitionException e) {
                this.finished(new CacheException("Cannot update file in state " + (Object)((Object)e.getSourceState())));
            }
            catch (CacheException | RuntimeException | NoSuchAlgorithmException e) {
                this.finished(e);
            }
            finally {
                MigrationModuleServer.this._requests.remove(this._uuid);
            }
        }
    }
}

