/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.pool.migration;

import com.google.common.collect.Range;
import com.google.common.collect.Ranges;
import diskCacheV111.util.AccessLatency;
import diskCacheV111.util.PnfsId;
import diskCacheV111.util.RetentionPolicy;
import diskCacheV111.vehicles.PoolManagerPoolInformation;
import dmg.cells.nucleus.CellEndpoint;
import dmg.util.command.Argument;
import dmg.util.command.Command;
import dmg.util.command.CommandLine;
import dmg.util.command.Option;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledExecutorService;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dcache.cells.AbstractCellComponent;
import org.dcache.cells.CellCommandListener;
import org.dcache.cells.CellMessageReceiver;
import org.dcache.cells.CellStub;
import org.dcache.pool.migration.AccessLatencyFilter;
import org.dcache.pool.migration.AccessedFilter;
import org.dcache.pool.migration.BestPoolSelectionStrategy;
import org.dcache.pool.migration.CacheEntryFilter;
import org.dcache.pool.migration.CacheEntryMode;
import org.dcache.pool.migration.Job;
import org.dcache.pool.migration.JobDefinition;
import org.dcache.pool.migration.LruOrder;
import org.dcache.pool.migration.MigrationContext;
import org.dcache.pool.migration.PnfsIdFilter;
import org.dcache.pool.migration.PoolListByLink;
import org.dcache.pool.migration.PoolListByNames;
import org.dcache.pool.migration.PoolListByPoolGroup;
import org.dcache.pool.migration.PoolListFilter;
import org.dcache.pool.migration.PoolMigrationCopyFinishedMessage;
import org.dcache.pool.migration.PoolMigrationJobCancelMessage;
import org.dcache.pool.migration.PoolSelectionStrategy;
import org.dcache.pool.migration.ProportionalPoolSelectionStrategy;
import org.dcache.pool.migration.RandomPoolSelectionStrategy;
import org.dcache.pool.migration.RefreshablePoolList;
import org.dcache.pool.migration.RetentionPolicyFilter;
import org.dcache.pool.migration.ReverseOrder;
import org.dcache.pool.migration.SizeFilter;
import org.dcache.pool.migration.SizeOrder;
import org.dcache.pool.migration.StateFilter;
import org.dcache.pool.migration.StickyFilter;
import org.dcache.pool.migration.StickyOwnerFilter;
import org.dcache.pool.migration.StorageClassFilter;
import org.dcache.pool.migration.SymbolTable;
import org.dcache.pool.repository.CacheEntry;
import org.dcache.pool.repository.EntryState;
import org.dcache.pool.repository.Repository;
import org.dcache.pool.repository.StickyRecord;
import org.dcache.util.Glob;
import org.dcache.util.expression.Expression;
import org.dcache.util.expression.ExpressionParser;
import org.dcache.util.expression.Token;
import org.dcache.util.expression.Type;
import org.dcache.util.expression.TypeMismatchException;
import org.dcache.util.expression.UnknownIdentifierException;
import org.parboiled.Parboiled;
import org.parboiled.errors.ErrorUtils;
import org.parboiled.parserunners.ReportingParseRunner;
import org.parboiled.support.ParsingResult;

public class MigrationModule
extends AbstractCellComponent
implements CellCommandListener,
CellMessageReceiver {
    private static final PoolManagerPoolInformation DUMMY_POOL = new PoolManagerPoolInformation("pool", 0.0, 0.0);
    public static final String CONSTANT_TARGET = "target";
    public static final String CONSTANT_SOURCE = "source";
    public static final String CONSTANT_TARGETS = "targets";
    public static final String CONSTANT_QUEUE_FILES = "queue.files";
    public static final String CONSTANT_QUEUE_BYTES = "queue.bytes";
    public static final int NON_EMPTY_QUEUE = 1;
    public static final int NO_TARGETS = 0;
    private static final Pattern STICKY_PATTERN = Pattern.compile("(\\w+)(\\((-?\\d+)\\))?");
    private final Map<String, Job> _jobs = new HashMap<String, Job>();
    private final Map<Job, String> _commands = new HashMap<Job, String>();
    private final MigrationContext _context = new MigrationContext();
    private static final Expression TRUE_EXPRESSION = new Expression(Token.TRUE, new Expression[0]);
    private static final Expression FALSE_EXPRESSION = new Expression(Token.FALSE, new Expression[0]);
    private int _counter = 1;

    @Override
    public void setCellEndpoint(CellEndpoint endpoint) {
        super.setCellEndpoint(endpoint);
        this._context.setPoolName(this.getCellName());
    }

    public void setRepository(Repository repository) {
        this._context.setRepository(repository);
    }

    public void setExecutor(ScheduledExecutorService executor) {
        this._context.setExecutor(executor);
    }

    public void setPnfsStub(CellStub stub) {
        this._context.setPnfsStub(stub);
    }

    public void setPoolManagerStub(CellStub stub) {
        this._context.setPoolManagerStub(stub);
    }

    public void setPoolStub(CellStub stub) {
        this._context.setPoolStub(stub);
    }

    public void setPinManagerStub(CellStub stub) {
        this._context.setPinManagerStub(stub);
    }

    private synchronized Job getJob(String id) throws NoSuchElementException {
        Job job = this._jobs.get(id);
        if (job == null) {
            throw new NoSuchElementException("Job not found");
        }
        return job;
    }

    private synchronized String getJobSummary(String id) {
        Job job = this.getJob(id);
        return String.format("[%s] %-12s %s", new Object[]{id, job.getState(), this._commands.get(job)});
    }

    private static Range<Long> parseRange(String s) throws IllegalArgumentException {
        String[] bounds = s.split("\\.\\.", 2);
        switch (bounds.length) {
            case 1: {
                return Ranges.singleton((Comparable)Long.valueOf(Long.parseLong(bounds[0])));
            }
            case 2: {
                if (bounds[0].length() == 0 && bounds[1].length() == 0) {
                    return Ranges.all();
                }
                if (bounds[0].length() == 0) {
                    return Ranges.atMost((Comparable)Long.valueOf(Long.parseLong(bounds[1])));
                }
                if (bounds[1].length() == 0) {
                    return Ranges.atLeast((Comparable)Long.valueOf(Long.parseLong(bounds[0])));
                }
                return Ranges.closed((Comparable)Long.valueOf(Long.parseLong(bounds[0])), (Comparable)Long.valueOf(Long.parseLong(bounds[1])));
            }
        }
        throw new IllegalArgumentException(s + ": Invalid interval");
    }

    public synchronized void cancelAll() {
        for (Job job : this._jobs.values()) {
            try {
                job.cancel(true);
            }
            catch (IllegalStateException illegalStateException) {}
        }
    }

    public synchronized void messageArrived(PoolMigrationCopyFinishedMessage message) {
        if (!message.getPool().equals(this._context.getPoolName())) {
            return;
        }
        for (Job job : this._jobs.values()) {
            job.messageArrived(message);
        }
    }

    public Object messageArrived(PoolMigrationJobCancelMessage message) {
        try {
            return this.getJob(message.getJobId()).messageArrived(message);
        }
        catch (NoSuchElementException e) {
            message.setSucceeded();
            return message;
        }
    }

    @Override
    public synchronized void getInfo(PrintWriter pw) {
        for (String id : this._jobs.keySet()) {
            pw.println(this.getJobSummary(id));
        }
    }

    @Override
    public synchronized void printSetup(PrintWriter pw) {
        pw.println("#\n# MigrationModule\n#");
        for (Job job : this._jobs.values()) {
            if (!job.getDefinition().isPermanent) continue;
            pw.println(this._commands.get(job));
        }
    }

    public synchronized boolean isActive(PnfsId id) {
        return this._context.isActive(id);
    }

    static {
        TRUE_EXPRESSION.setType(Type.BOOLEAN);
        FALSE_EXPRESSION.setType(Type.BOOLEAN);
    }

    @Command(name="migration info", usage="Shows detailed information about a migration job. Possible job states are:\n\n   INITIALIZING   Initial scan of repository\n   RUNNING        Job runs (schedules new tasks)\n   SLEEPING       A task failed; no tasks are scheduled for 10 seconds\n   PAUSED         Pause expression evaluates to true; no tasks for 10 seconds\n   STOPPING       Stop expression evaluated to true; waiting for tasks to stop\n   SUSPENDED      Job suspended by user; no tasks are scheduled\n   CANCELLING     Job cancelled by user; waiting for tasks to stop\n   CANCELLED      Job cancelled by user; no tasks are running\n   FINISHED       Job completed\n   FAILED         Job failed (check log file for details)\n\nJob tasks may be in any of the following states:\n\n   Queued               Queued for execution\n   GettingLocations     Querying PnfsManager for file locations\n   UpdatingExistingFile Updating the state of existing target file\n   CancellingUpdate     Task cancelled, waiting for update to complete\n   InitiatingCopy       Request send to target, waiting for confirmation\n   Copying              Waiting for target to complete the transfer\n   Pinging              Ping send to target, waiting for reply\n   NoResponse           Cell connection to target lost\n   Waiting              Waiting for final confirmation from target\n   MovingPin            Waiting for pin manager to move pin\n   Cancelling           Attempting to cancel transfer\n   Cancelled            Task cancelled, file was not copied\n   Failed               The task failed\n   Done                 The task completed successfully")
    public class MigrationInfoCommand
    implements Callable<String> {
        @Argument(metaVar="job")
        String id;

        @Override
        public String call() throws NoSuchElementException {
            Job job = MigrationModule.this.getJob(this.id);
            String command = (String)MigrationModule.this._commands.get(job);
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            pw.println("Command    : " + command);
            job.getInfo(pw);
            return sw.toString();
        }
    }

    @Command(name="migration ls", usage="Lists all migration jobs")
    public class MigrationListCommand
    implements Callable<String> {
        @Override
        public String call() throws Exception {
            StringBuilder s = new StringBuilder();
            for (String id : MigrationModule.this._jobs.keySet()) {
                s.append(MigrationModule.this.getJobSummary(id)).append('\n');
            }
            return s.toString();
        }
    }

    @Command(name="migration clear", usage="Removes completed migration jobs. For reference, information about migration jobs are kept until explicitly cleared.")
    public class MigrationClearCommand
    implements Callable<String> {
        @Override
        public String call() {
            Iterator i = MigrationModule.this._jobs.values().iterator();
            while (i.hasNext()) {
                Job job = (Job)i.next();
                switch (job.getState()) {
                    case CANCELLED: 
                    case FINISHED: {
                        i.remove();
                        MigrationModule.this._commands.remove(job);
                        break;
                    }
                }
            }
            return "";
        }
    }

    @Command(name="migration cancel", usage="Cancels a migration job.")
    public class MigrationCancelCommand
    implements Callable<String> {
        @Option(name="force", usage="Kill ongoing transfers.")
        boolean force;
        @Argument(metaVar="job")
        String id;

        @Override
        public String call() {
            Job job = MigrationModule.this.getJob(this.id);
            job.cancel(this.force);
            return MigrationModule.this.getJobSummary(this.id);
        }
    }

    @Command(name="migration resume", usage="Resumes a suspended migration job.")
    public class MigrationResumeCommand
    implements Callable<String> {
        @Argument(metaVar="job")
        String id;

        @Override
        public String call() {
            Job job = MigrationModule.this.getJob(this.id);
            job.resume();
            return MigrationModule.this.getJobSummary(this.id);
        }
    }

    @Command(name="migration suspend", usage="Suspends a migration job. A suspended job finishes ongoing transfers, but is does not start any new transfer.")
    public class MigrationSuspendCommand
    implements Callable<String> {
        @Argument(metaVar="job")
        String id;

        @Override
        public String call() {
            Job job = MigrationModule.this.getJob(this.id);
            job.suspend();
            return MigrationModule.this.getJobSummary(this.id);
        }
    }

    @Command(name="migration cache", usage="Caches replicas on other pools. Accepts the same options as 'migration copy'. Corresponds to\n\n     migration copy -smode=same -tmode=cached")
    public class MigrationCacheCommand
    extends MigrationCopyCommand {
        public MigrationCacheCommand() {
            this.select = "proportional";
            this.target = "pool";
            this.sourceMode = "same";
            this.targetMode = "cached";
            this.refresh = 300;
            this.pins = "keep";
            this.verify = false;
        }
    }

    @Command(name="migration move", usage="Moves replicas to other pools. The source replica is deleted. Accepts the same options as 'migration copy'. Corresponds to\n\n     migration copy -smode=delete -tmode=same -pins=move -verify")
    public class MigrationMoveCommand
    extends MigrationCopyCommand {
        public MigrationMoveCommand() {
            this.select = "proportional";
            this.target = "pool";
            this.sourceMode = "delete";
            this.targetMode = "same";
            this.refresh = 300;
            this.pins = "move";
            this.verify = true;
        }
    }

    @Command(name="migration copy", usage="Copies files to other pools. Unless filter options are specified, all files on the source pool are copied.\n\nThe operation is idempotent, that is, it can safely be repeated without creating extra copies of the files. If the replica exists on any of the target pools, then it is not copied again. If the target pool with the existing replica fails to respond, then the operation is retried indefinitely, unless the job is marked as eager.\n\nPlease notice that a job is only idempotent as long as the set of target pools do not change. If pools go offline or are excluded as a result of a an exclude or include expression, then the idempotent nature of a job may be lost.\n\nBoth the state of the local replica and that of the target replica can be specified. If the target replica already exists, the state is updated to be at least as strong as the specified target state, that is, the lifetime of sticky bits is extended, but never reduced, and cached can be changed to precious, but never the opposite.\n\nTransfers are subject to the checksum computiton policy of the target pool. Thus checksums are verified if and only if the target pool is configured to do so. For existing replicas, the checksum is only verified if the verify option was specified on the migration job.\n\nJobs can be marked permanent. Permanent jobs never terminate and are stored in the pool setup file with the 'save' command. Permanent jobs watch the repository for state changes and copy any replicas that match the selection criteria, even replicas added after the job was created. Notice that any state change will cause a replica to be reconsidered and enqueued if it matches the selection criteria - also replicas that have been copied before.\n\nSeveral options allow an expression to be specified. The following operators are recognized: <, <=, ==, !=, >=, >, ~=, !~, +, -, *, /, **, %, and, or, not, ?:. Literals may be floating point literals, single or double quoted string literals, and boolean true and false. Depending on the context, the expression may refer to constants.")
    public class MigrationCopyCommand
    implements Callable<String> {
        @Option(name="id")
        String id;
        @Option(name="accessed", category="Filter options", usage="Only copy replicas accessed n seconds ago, or accessed within the given, possibly open-ended, interval. E.g. -accessed=0..60 matches files accessed within the last minute; -accesed=60.. matches files accessed one minute or more ago.")
        String accessed;
        @Option(name="al", values={"online", "nearline"}, category="Filter options", usage="Only copy replicas with the given access latency.")
        String accessLatency;
        @Option(name="pnfsid", separator=",", category="Filter options", usage="Only copy replicas with one of the given PNFS IDs.")
        PnfsId[] pnfsid;
        @Option(name="rp", values={"custodial", "replica", "output"}, category="Filter options", usage="Only copy replicas with the given retention policy.")
        String retentionPolicy;
        @Option(name="size", category="Filter options", usage="Only copy replicas with size n, or a size within the given, possibly open-ended, interval")
        String size;
        @Option(name="state", values={"cached", "precious"}, category="Filter options", usage="Only copy replicas in the given state.")
        String state;
        @Option(name="sticky", metaVar="owner", separator=",", category="Filter options", usage="Only copy sticky replicas. Can optionally be limited to the list of owners. A sticky flag for each owner must be present for the replica to be selected.")
        String[] sticky;
        @Option(name="storage", metaVar="class", category="Filter options", usage="Only copy replicas with the given access latency.")
        String storage;
        @Option(name="concurrency", category="Transfer options", usage="Specifies how many concurrent transfers to perform. Defaults to 1.")
        int concurrency = 1;
        @Option(name="order", valueSpec="[-]size|[-]lru", category="Transfer options", usage="Sort transfer queue. By default transfers are placed in ascending order, that is, smallest and least recently used first. Transfers are placed in descending order if the key is prefixed by a minus sign. Failed transfers are placed at the end of the queue for retry regardless of the order. This option cannot be used for permanent jobs. Notice that for pools with a large number of files, sorting significantly increases the initialization time of the migration job.\nsize:\n    Sort according to file size.\nlru:\n    Sort according to last access time.")
        String order;
        @Option(name="pins", values={"keep", "move"}, category="Transfer options", usage="Controls how sticky flags owned by the pin manager are handled:\nmove:\n    Ask pin manager to move pins to the target pool.\nkeep:\n    Keep pin on the source pool.")
        String pins = "keep";
        @Option(name="smode", valueSpec="same|cached|precious|removable|delete[+OWNER[(LIFETIME)]]...", category="Transfer options", usage="Update the local replica to the given mode after transfer:\nsame:\n    does not change the local state (this is the default).\ncached:\n    marks it cached.\nprecious:\n    marks it precious.\nremovable:\n    marks it cached and strips all existing sticky flags\n    exluding pins.\ndelete:\n    deletes the replica unless it is pinned.\nAn optional list of sticky flags can be specified. The lifetime is in seconds. A lifetime of 0 causes the flag to immediately expire. Notice that existing sticky flags of the same owner are overwritten.")
        String sourceMode = "same";
        @Option(name="tmode", valueSpec="same|cached|precious[+OWNER[(LIFETIME)]]...", category="Transfer options", usage="Set the mode of the target replica:\nsame:\n    applies the state and sticky bits excluding pins\n    of the local replica (this is the default).\ncached:\n    marks it cached.\nprecious:\n    marks it precious.\nAn optional list of sticky flags can be specified. The lifetime is in seconds.")
        String targetMode = "same";
        @Option(name="verify", category="Transfer options", usage="Force checksum computation when an existing target is updated.")
        boolean verify;
        @Option(name="eager", category="Target options", usage="Copy replicas rather than retrying when pools with existing replicas fail to respond.")
        boolean eager;
        @Option(name="exclude", metaVar="glob", separator=",", category="Target options", usage="Exclude target pools matching any of the patterns. Single character (?) and multi character (*) wildcards may be used.")
        String[] exclude;
        @Option(name="exclude-when", metaVar="expr", category="Target options", usage="Exclude target pools for which the expression evaluates to true. The expression may refer to the following constants:\nsource.name/target.name:\n    pool name\nsource.spaceCost/target.spaceCost:\n    space cost\nsource.cpuCost/target.cpuCost:\n    cpu cost\nsource.free/target.free:\n    free space in bytes\nsource.total/target.total:\n    total space in bytes\nsource.removable/target.removable:\n    removable space in bytes\nsource.used/target.used:\n     used space in bytes")
        String excludeWhen;
        @Option(name="include", metaVar="glob", separator=",", category="Target options", usage="Only include target pools matching any of the patterns. Single character (?) and multi character (*) wildcards may be used.")
        String[] include;
        @Option(name="include-when", metaVar="expr", category="Target options", usage="Only include target pools for which the expression evaluates to true. See the description of -exclude-when for the list of allowed constants.")
        String includeWhen;
        @Option(name="refresh", metaVar="seconds", category="Target options", usage="Sets the period in seconds of when target pool information is queried from the pool manager. Inclusion and exclusion expressions are evaluated whenever the information is refreshed. The default is 300 seconds.")
        int refresh = 300;
        @Option(name="select", values={"proportional", "best", "random"}, category="Target options", usage="Determines how a pool is selected from the set of target pools:\nproportional:\n    selects a pool with a probability proportional\n    to the free space.\nbest:\n    selects the pool with the lowest space cost.\nrandom:\n    selects a pool randomly.\nThe default is 'proportional'.")
        String select = "proportional";
        @Option(name="target", values={"pool", "pgroup", "link"}, category="Target options", usage="Determines the interpretation of the target names. The default is 'pool'")
        String target = "pool";
        @Option(name="pause-when", metaVar="expr", category="Lifetime options", usage="Pauses the job when the expression becomes true. The job continues when the expression once again evaluates to false. The following constants are defined for this pool:\nqueue.files:\n    the number of files remaining to be transferred.\nqueue.bytes:\n    the number of bytes remaining to be transferred.\nsource.name:\n    pool name\nsource.spaceCost:\n    space cost\nsource.cpuCost:\n    cpu cost\nsource.free:\n    free space in bytes\nsource.total:\n    total space in bytes\nsource.removable:\n    removable space in bytes\nsource.used:\n    used space in bytes\ntargets:\n    the number of target pools.")
        String pauseWhen;
        @Option(name="permanent", usage="Mark job as permanent.", category="Lifetime options")
        boolean permanent;
        @Option(name="stop-when", metaVar="expr", category="Lifetime options", usage="Terminates the job when the expression becomes true. This option cannot be used for permanent jobs. See the description of -pause-when for the list of constants allowed in the expression.")
        String stopWhen;
        @Option(name="force-source-mode", category="Transfer options", usage="Enables the transfer of files from a disabled pool.")
        boolean forceSourceMode;
        @Argument(metaVar="target")
        String[] targets;
        @CommandLine
        String commandLine;

        private RefreshablePoolList createPoolList(String type, List<String> targets) {
            CellStub poolManager = MigrationModule.this._context.getPoolManagerStub();
            switch (type) {
                case "pool": {
                    return new PoolListByNames(poolManager, targets);
                }
                case "pgroup": {
                    if (targets.size() != 1) {
                        throw new IllegalArgumentException(targets.toString() + ": Only one target supported for -type=pgroup");
                    }
                    return new PoolListByPoolGroup(poolManager, targets.get(0));
                }
                case "link": {
                    if (targets.size() != 1) {
                        throw new IllegalArgumentException(targets.toString() + ": Only one target supported for -type=link");
                    }
                    return new PoolListByLink(poolManager, targets.get(0));
                }
            }
            throw new IllegalArgumentException(type + ": Invalid value");
        }

        private PoolSelectionStrategy createPoolSelectionStrategy(double spaceCost, double cpuCost, String type) {
            switch (type) {
                case "proportional": {
                    return new ProportionalPoolSelectionStrategy();
                }
                case "best": {
                    return new BestPoolSelectionStrategy(spaceCost, cpuCost);
                }
                case "random": {
                    return new RandomPoolSelectionStrategy();
                }
            }
            throw new IllegalArgumentException(type + ": Invalid value");
        }

        private StickyRecord parseStickyRecord(String s) throws IllegalArgumentException {
            Matcher matcher = STICKY_PATTERN.matcher(s);
            if (!matcher.matches()) {
                throw new IllegalArgumentException(s + ": Syntax error");
            }
            String owner = matcher.group(1);
            String lifetime = matcher.group(3);
            try {
                long expire;
                long l = expire = lifetime == null ? -1L : (long)Integer.valueOf(lifetime).intValue();
                if (expire < -1L) {
                    throw new IllegalArgumentException(lifetime + ": Invalid lifetime");
                }
                if (expire > 0L) {
                    expire = System.currentTimeMillis() + expire * 1000L;
                }
                return new StickyRecord(owner, expire);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(lifetime + ": Invalid lifetime");
            }
        }

        private CacheEntryMode createCacheEntryMode(String type) {
            String[] s = type.split("\\+");
            ArrayList<StickyRecord> records = new ArrayList<StickyRecord>();
            for (int i = 1; i < s.length; ++i) {
                records.add(this.parseStickyRecord(s[i]));
            }
            switch (s[0]) {
                case "same": {
                    return new CacheEntryMode(CacheEntryMode.State.SAME, records);
                }
                case "cached": {
                    return new CacheEntryMode(CacheEntryMode.State.CACHED, records);
                }
                case "delete": {
                    return new CacheEntryMode(CacheEntryMode.State.DELETE, records);
                }
                case "removable": {
                    return new CacheEntryMode(CacheEntryMode.State.REMOVABLE, records);
                }
                case "precious": {
                    return new CacheEntryMode(CacheEntryMode.State.PRECIOUS, records);
                }
            }
            throw new IllegalArgumentException(type + ": Invalid value");
        }

        private Comparator<CacheEntry> createComparator(String order) {
            if (order == null) {
                return null;
            }
            switch (order) {
                case "size": {
                    return new SizeOrder();
                }
                case "-size": {
                    return new ReverseOrder<CacheEntry>(new SizeOrder());
                }
                case "lru": {
                    return new LruOrder();
                }
                case "-lru": {
                    return new ReverseOrder<CacheEntry>(new LruOrder());
                }
            }
            throw new IllegalArgumentException(order + ": Invalid value for option -order");
        }

        private Expression createPredicate(String s, Expression ifNull, SymbolTable symbols) {
            try {
                if (s == null) {
                    return ifNull;
                }
                ExpressionParser parser = (ExpressionParser)Parboiled.createParser(ExpressionParser.class, (Object[])new Object[0]);
                ParsingResult result = new ReportingParseRunner(parser.Top()).run(s);
                if (result.hasErrors()) {
                    throw new IllegalArgumentException("Invalid expression: " + ErrorUtils.printParseErrors((ParsingResult)result));
                }
                Expression expression = (Expression)((Object)result.resultValue);
                if (expression.check(symbols) != Type.BOOLEAN) {
                    throw new IllegalArgumentException("Expression does not evaluate to a boolean");
                }
                return expression;
            }
            catch (TypeMismatchException | UnknownIdentifierException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }

        private Expression createPoolPredicate(String s, Expression ifNull) {
            SymbolTable symbols = new SymbolTable();
            symbols.put(MigrationModule.CONSTANT_SOURCE, DUMMY_POOL);
            symbols.put(MigrationModule.CONSTANT_TARGET, DUMMY_POOL);
            return this.createPredicate(s, ifNull, symbols);
        }

        private Expression createLifetimePredicate(String s) {
            SymbolTable symbols = new SymbolTable();
            symbols.put(MigrationModule.CONSTANT_SOURCE, DUMMY_POOL);
            symbols.put(MigrationModule.CONSTANT_QUEUE_FILES, 1L);
            symbols.put(MigrationModule.CONSTANT_QUEUE_BYTES, 1L);
            symbols.put(MigrationModule.CONSTANT_TARGETS, 0L);
            return this.createPredicate(s, null, symbols);
        }

        private Set<Pattern> createPatterns(String[] globs) {
            HashSet<Pattern> patterns = new HashSet<Pattern>();
            if (globs != null) {
                for (String s : globs) {
                    patterns.add(Glob.parseGlobToPattern((String)s));
                }
            }
            return patterns;
        }

        private List<CacheEntryFilter> createFilters() throws IllegalArgumentException {
            ArrayList<CacheEntryFilter> filters = new ArrayList<CacheEntryFilter>();
            if (this.storage != null) {
                filters.add(new StorageClassFilter(this.storage));
            }
            if (this.pnfsid != null) {
                filters.add(new PnfsIdFilter(new HashSet<PnfsId>(Arrays.asList(this.pnfsid))));
            }
            if (this.state == null) {
                filters.add(new StateFilter(EntryState.CACHED, EntryState.PRECIOUS));
            } else if (this.state.equals("cached")) {
                filters.add(new StateFilter(EntryState.CACHED));
            } else if (this.state.equals("precious")) {
                filters.add(new StateFilter(EntryState.PRECIOUS));
            } else {
                throw new IllegalArgumentException(this.state + ": Invalid state");
            }
            if (this.sticky != null) {
                if (this.sticky.length == 0) {
                    filters.add(new StickyFilter());
                } else {
                    for (String owner : this.sticky) {
                        filters.add(new StickyOwnerFilter(owner));
                    }
                }
            }
            if (this.size != null) {
                filters.add(new SizeFilter((Range<Long>)MigrationModule.parseRange(this.size)));
            }
            if (this.accessed != null) {
                filters.add(new AccessedFilter((Range<Long>)MigrationModule.parseRange(this.accessed)));
            }
            if (this.accessLatency != null) {
                filters.add(new AccessLatencyFilter(AccessLatency.getAccessLatency((String)this.accessLatency)));
            }
            if (this.retentionPolicy != null) {
                filters.add(new RetentionPolicyFilter(RetentionPolicy.getRetentionPolicy((String)this.retentionPolicy)));
            }
            return filters;
        }

        @Override
        public String call() throws IllegalArgumentException {
            Job job;
            boolean mustMovePins;
            if (this.permanent) {
                if (this.order != null) {
                    throw new IllegalArgumentException("Permanent jobs cannot be ordered");
                }
                if (this.stopWhen != null) {
                    throw new IllegalArgumentException("Permanent jobs cannot have a stop condition.");
                }
            }
            Set<Pattern> excluded = this.createPatterns(this.exclude);
            excluded.add(Pattern.compile(Pattern.quote(MigrationModule.this._context.getPoolName())));
            Set<Pattern> included = this.createPatterns(this.include);
            switch (this.pins) {
                case "keep": {
                    mustMovePins = false;
                    break;
                }
                case "move": {
                    mustMovePins = true;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(this.pins + ": Invalid value for option -pins");
                }
            }
            PoolListByNames sourceList = new PoolListByNames(MigrationModule.this._context.getPoolManagerStub(), Collections.singletonList(MigrationModule.this._context.getPoolName()));
            Expression excludeExpression = this.createPoolPredicate(this.excludeWhen, FALSE_EXPRESSION);
            Expression includeExpression = this.createPoolPredicate(this.includeWhen, TRUE_EXPRESSION);
            PoolListFilter poolList = new PoolListFilter(this.createPoolList(this.target, Arrays.asList(this.targets)), excluded, excludeExpression, included, includeExpression, sourceList);
            JobDefinition definition = new JobDefinition(this.createFilters(), this.createCacheEntryMode(this.sourceMode), this.createCacheEntryMode(this.targetMode), this.createPoolSelectionStrategy(1.0, 0.0, this.select), this.createComparator(this.order), sourceList, poolList, this.refresh * 1000, this.permanent, this.eager, mustMovePins, this.verify, this.createLifetimePredicate(this.pauseWhen), this.createLifetimePredicate(this.stopWhen), this.forceSourceMode);
            if (definition.targetMode.state == CacheEntryMode.State.DELETE || definition.targetMode.state == CacheEntryMode.State.REMOVABLE) {
                throw new IllegalArgumentException(this.targetMode + ": Invalid value");
            }
            if (this.id == null) {
                do {
                    this.id = String.valueOf(MigrationModule.this._counter++);
                } while (MigrationModule.this._jobs.containsKey(this.id));
            } else {
                job = (Job)MigrationModule.this._jobs.get(this.id);
                if (job != null) {
                    switch (job.getState()) {
                        case FAILED: 
                        case CANCELLED: 
                        case FINISHED: {
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Job id is already in use: " + this.id);
                        }
                    }
                }
            }
            job = new Job(MigrationModule.this._context, definition);
            job.setConcurrency(this.concurrency);
            MigrationModule.this._jobs.put(this.id, job);
            MigrationModule.this._commands.put(job, this.commandLine);
            return MigrationModule.this.getJobSummary(this.id);
        }
    }

    @Command(name="migration concurrency", usage="Adjust the concurrency of a job.")
    public class MigrationConcurrencyCommand
    implements Callable<String> {
        @Argument(index=0)
        String id;
        @Argument(index=1)
        int concurrency;

        @Override
        public String call() throws NoSuchElementException {
            Job job = MigrationModule.this.getJob(this.id);
            job.setConcurrency(this.concurrency);
            return String.format("[%s] Concurrency set to %d", this.id, this.concurrency);
        }
    }
}

