/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.pool.migration;

import diskCacheV111.util.PnfsId;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import org.dcache.cells.CellStub;
import org.dcache.pool.repository.Repository;

public class MigrationContext {
    private String _poolName;
    private ScheduledExecutorService _executor;
    private CellStub _pool;
    private CellStub _pnfs;
    private CellStub _poolManager;
    private CellStub _pinManager;
    private Repository _repository;
    private final ConcurrentMap<PnfsId, PnfsId> _locks = new ConcurrentHashMap<PnfsId, PnfsId>();

    public String getPoolName() {
        return this._poolName;
    }

    public void setPoolName(String poolName) {
        this._poolName = poolName;
    }

    public ScheduledExecutorService getExecutor() {
        return this._executor;
    }

    public void setExecutor(ScheduledExecutorService executor) {
        this._executor = executor;
    }

    public CellStub getPoolStub() {
        return this._pool;
    }

    public void setPoolStub(CellStub pool) {
        this._pool = pool;
    }

    public CellStub getPnfsStub() {
        return this._pnfs;
    }

    public void setPnfsStub(CellStub pnfs) {
        this._pnfs = pnfs;
    }

    public CellStub getPoolManagerStub() {
        return this._poolManager;
    }

    public void setPoolManagerStub(CellStub poolManager) {
        this._poolManager = poolManager;
    }

    public CellStub getPinManagerStub() {
        return this._pinManager;
    }

    public void setPinManagerStub(CellStub pinManager) {
        this._pinManager = pinManager;
    }

    public Repository getRepository() {
        return this._repository;
    }

    public void setRepository(Repository repository) {
        this._repository = repository;
    }

    public boolean lock(PnfsId pnfsId) {
        return this._locks.put(pnfsId, pnfsId) == null;
    }

    public void unlock(PnfsId pnfsId) {
        this._locks.remove(pnfsId);
    }

    public boolean isActive(PnfsId pnfsId) {
        return this._locks.containsKey(pnfsId);
    }
}

