/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.pool.migration;

import com.google.common.collect.ImmutableList;
import diskCacheV111.util.CacheException;
import diskCacheV111.util.FileNotInCacheException;
import diskCacheV111.util.PnfsId;
import diskCacheV111.vehicles.PoolManagerPoolInformation;
import dmg.cells.nucleus.DelayedReply;
import dmg.cells.nucleus.NoRouteToCellException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.dcache.pool.migration.CacheEntryFilter;
import org.dcache.pool.migration.CacheEntryMode;
import org.dcache.pool.migration.CacheEntryOrder;
import org.dcache.pool.migration.JobDefinition;
import org.dcache.pool.migration.JobStatistics;
import org.dcache.pool.migration.MigrationContext;
import org.dcache.pool.migration.PoolMigrationCopyFinishedMessage;
import org.dcache.pool.migration.PoolMigrationJobCancelMessage;
import org.dcache.pool.migration.SymbolTable;
import org.dcache.pool.migration.Task;
import org.dcache.pool.repository.AbstractStateChangeListener;
import org.dcache.pool.repository.CacheEntry;
import org.dcache.pool.repository.EntryState;
import org.dcache.pool.repository.IllegalTransitionException;
import org.dcache.pool.repository.Repository;
import org.dcache.pool.repository.StateChangeEvent;
import org.dcache.pool.repository.StickyRecord;
import org.dcache.util.expression.Expression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Job
extends AbstractStateChangeListener {
    private static final Logger _log = LoggerFactory.getLogger(Job.class);
    private final Set<PnfsId> _queued = new LinkedHashSet<PnfsId>();
    private final Map<PnfsId, Long> _sizes = new HashMap<PnfsId, Long>();
    private final Map<PnfsId, Task> _running = new HashMap<PnfsId, Task>();
    private final Future<?> _refreshTask;
    private final BlockingQueue<Error> _errors = new ArrayBlockingQueue<Error>(15);
    private final Map<PoolMigrationJobCancelMessage, DelayedReply> _cancelRequests = new HashMap<PoolMigrationJobCancelMessage, DelayedReply>();
    private final JobStatistics _statistics = new JobStatistics();
    private final MigrationContext _context;
    private final JobDefinition _definition;
    private State _state;
    private int _concurrency;

    public Job(MigrationContext context, JobDefinition definition) {
        ScheduledExecutorService executor = context.getExecutor();
        long refreshPeriod = definition.refreshPeriod;
        this._context = context;
        this._definition = definition;
        this._concurrency = 1;
        this._state = State.INITIALIZING;
        this._refreshTask = executor.scheduleWithFixedDelay(new LoggingTask(new Runnable(){

            @Override
            public void run() {
                ((Job)Job.this)._definition.sourceList.refresh();
                ((Job)Job.this)._definition.poolList.refresh();
            }
        }), 0L, refreshPeriod, TimeUnit.MILLISECONDS);
        executor.submit(new LoggingTask(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                State state = State.FAILED;
                try {
                    Job.this._context.getRepository().addListener(Job.this);
                    Job.this.populate();
                    state = State.RUNNING;
                }
                catch (InterruptedException e) {
                    _log.error("Migration job was interrupted");
                }
                finally {
                    Job.this.setState(state);
                }
            }
        }));
    }

    public synchronized JobDefinition getDefinition() {
        return this._definition;
    }

    public synchronized int getConcurrency() {
        return this._concurrency;
    }

    public synchronized void setConcurrency(int concurrency) {
        this._concurrency = concurrency;
        this.schedule();
    }

    public synchronized void addError(Error error) {
        while (!this._errors.offer(error)) {
            this._errors.poll();
        }
    }

    public synchronized void getInfo(PrintWriter pw) {
        long total = this._statistics.getTotal();
        long completed = this._statistics.getTransferred();
        pw.println("State      : " + (Object)((Object)this._state));
        pw.println("Queued     : " + this._queued.size());
        pw.println("Attempts   : " + this._statistics.getAttempts());
        pw.println("Targets    : " + this._definition.poolList);
        if (total > 0L) {
            switch (this.getState()) {
                case RUNNING: 
                case SUSPENDED: 
                case CANCELLING: 
                case STOPPING: 
                case SLEEPING: 
                case PAUSED: {
                    pw.println("Completed  : " + this._statistics.getCompleted() + " files; " + this._statistics.getTransferred() + " bytes; " + 100L * completed / total + "%");
                    pw.println("Total      : " + total + " bytes");
                    break;
                }
                case INITIALIZING: 
                case FINISHED: {
                    pw.println("Completed  : " + this._statistics.getCompleted() + " files; " + this._statistics.getTransferred() + " bytes");
                    pw.println("Total      : " + total + " bytes");
                    break;
                }
                case CANCELLED: 
                case FAILED: {
                    pw.println("Completed  : " + this._statistics.getCompleted() + " files; " + this._statistics.getTransferred() + " bytes");
                }
            }
        }
        pw.println("Concurrency: " + this._concurrency);
        pw.println("Running tasks:");
        ArrayList<Task> tasks = new ArrayList<Task>(this._running.values());
        Collections.sort(tasks, new Comparator<Task>(){

            @Override
            public int compare(Task t1, Task t2) {
                return (int)Math.signum(t1.getId() - t2.getId());
            }
        });
        for (Task task : tasks) {
            task.getInfo(pw);
        }
        if (!this._errors.isEmpty()) {
            pw.println("Most recent errors:");
            for (Error error : this._errors) {
                pw.println(error);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populate() throws InterruptedException {
        try {
            Repository repository;
            Iterable<PnfsId> files = repository = this._context.getRepository();
            if (this._definition.comparator != null) {
                ArrayList<Object> all = new ArrayList<Object>();
                for (Object pnfsId2 : files) {
                    all.add(pnfsId2);
                }
                CacheEntryOrder order = new CacheEntryOrder(repository, this._definition.comparator);
                Collections.sort(all, order);
                files = all;
            }
            for (PnfsId pnfsId : files) {
                try {
                    Object pnfsId2;
                    pnfsId2 = this;
                    synchronized (pnfsId2) {
                        CacheEntry entry = repository.getEntry(pnfsId);
                        if (this.accept(entry)) {
                            this.add(entry);
                        }
                    }
                }
                catch (FileNotInCacheException e) {
                }
                catch (CacheException e) {
                    _log.error("Failed to load entry: " + e.getMessage());
                }
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public synchronized void cancel(boolean force) {
        if (this._state != State.RUNNING && this._state != State.SUSPENDED && this._state != State.CANCELLING && this._state != State.STOPPING && this._state != State.SLEEPING && this._state != State.PAUSED) {
            throw new IllegalStateException("The job cannot be cancelled in its present state");
        }
        if (this._running.isEmpty()) {
            this.setState(State.CANCELLED);
        } else {
            this.setState(State.CANCELLING);
            if (force) {
                for (Task task : this._running.values()) {
                    task.cancel();
                }
            }
        }
    }

    private synchronized void stop() {
        if (this._state != State.RUNNING && this._state != State.SUSPENDED && this._state != State.STOPPING && this._state != State.SLEEPING && this._state != State.PAUSED) {
            throw new IllegalStateException("The job cannot be stopped in its present state");
        }
        if (this._running.isEmpty()) {
            this.setState(State.FINISHED);
        } else {
            this.setState(State.STOPPING);
        }
    }

    private synchronized void pause() {
        if (this._state != State.RUNNING && this._state != State.SUSPENDED && this._state != State.SLEEPING && this._state != State.PAUSED) {
            throw new IllegalStateException("The job cannot be stopped in its present state");
        }
        this.setState(State.PAUSED);
    }

    public synchronized void suspend() {
        if (this._state != State.RUNNING && this._state != State.SUSPENDED && this._state != State.SLEEPING && this._state != State.PAUSED) {
            throw new IllegalStateException("Cannot suspend a job that does not run");
        }
        this.setState(State.SUSPENDED);
    }

    public synchronized void resume() {
        if (this._state != State.SUSPENDED) {
            throw new IllegalStateException("Cannot resume a job that does not run");
        }
        this.setState(State.RUNNING);
    }

    public synchronized State getState() {
        return this._state;
    }

    private synchronized void setState(State state) {
        if (this._state != state) {
            this._state = state;
            switch (this._state) {
                case RUNNING: {
                    this.schedule();
                    break;
                }
                case SLEEPING: {
                    this._context.getExecutor().schedule(new LoggingTask(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            Job job = Job.this;
                            synchronized (job) {
                                if (Job.this.getState() == State.SLEEPING) {
                                    Job.this.setState(State.RUNNING);
                                }
                            }
                        }
                    }), 10L, TimeUnit.SECONDS);
                    break;
                }
                case PAUSED: {
                    this._context.getExecutor().schedule(new LoggingTask(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            Job job = Job.this;
                            synchronized (job) {
                                if (Job.this.getState() == State.PAUSED) {
                                    Expression pauseWhen;
                                    Expression stopWhen = ((Job)Job.this)._definition.stopWhen;
                                    if (stopWhen != null && Job.this.evaluateLifetimePredicate(stopWhen)) {
                                        Job.this.stop();
                                    }
                                    if (!Job.this.evaluateLifetimePredicate(pauseWhen = ((Job)Job.this)._definition.pauseWhen)) {
                                        Job.this.setState(State.RUNNING);
                                    }
                                }
                            }
                        }
                    }), 10L, TimeUnit.SECONDS);
                    break;
                }
                case FINISHED: 
                case CANCELLED: 
                case FAILED: {
                    this._queued.clear();
                    this._sizes.clear();
                    this._context.getRepository().removeListener(this);
                    this._refreshTask.cancel(false);
                    for (Map.Entry<PoolMigrationJobCancelMessage, DelayedReply> entry : this._cancelRequests.entrySet()) {
                        try {
                            entry.getValue().send((Serializable)entry.getKey());
                        }
                        catch (NoRouteToCellException e) {
                            _log.info(e.toString());
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                    }
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void schedule() {
        if (this._state == State.CANCELLING && this._running.isEmpty()) {
            this.setState(State.CANCELLED);
        } else if (this._state != State.INITIALIZING && !this._definition.isPermanent && this._queued.isEmpty() && this._running.isEmpty()) {
            this.setState(State.FINISHED);
        } else if (this._state == State.STOPPING && this._running.isEmpty()) {
            this.setState(State.FINISHED);
        } else if (!(this._state != State.RUNNING || this._definition.sourceList.isValid() && this._definition.poolList.isValid())) {
            this.setState(State.SLEEPING);
        } else if (this._state == State.RUNNING) {
            Iterator<PnfsId> i = this._queued.iterator();
            while (this._running.size() < this._concurrency && i.hasNext()) {
                Expression stopWhen = this._definition.stopWhen;
                if (stopWhen != null && this.evaluateLifetimePredicate(stopWhen)) {
                    this.stop();
                    break;
                }
                Expression pauseWhen = this._definition.pauseWhen;
                if (pauseWhen != null && this.evaluateLifetimePredicate(pauseWhen)) {
                    this.pause();
                    break;
                }
                PnfsId pnfsId = i.next();
                if (!this._context.lock(pnfsId)) {
                    this.addError(new Error(0L, pnfsId, "File is locked"));
                    continue;
                }
                try {
                    i.remove();
                    Repository repository = this._context.getRepository();
                    CacheEntry entry = repository.getEntry(pnfsId);
                    Task task = new Task(this, this._context.getPoolStub(), this._context.getPnfsStub(), this._context.getPinManagerStub(), this._context.getExecutor(), this._context.getPoolName(), entry, this._definition);
                    this._running.put(pnfsId, task);
                    this._statistics.addAttempt();
                    task.run();
                }
                catch (FileNotInCacheException e) {
                    this._sizes.remove(pnfsId);
                }
                catch (CacheException e) {
                    _log.error("Migration job failed to read entry: " + e.getMessage());
                    this.setState(State.FAILED);
                    break;
                }
                catch (InterruptedException e) {
                    _log.error("Migration job was interrupted: " + e.getMessage());
                    this.setState(State.FAILED);
                    break;
                }
                finally {
                    if (this._running.containsKey(pnfsId)) continue;
                    this._context.unlock(pnfsId);
                }
            }
            if (this._running.isEmpty()) {
                if (!this._definition.isPermanent && this._queued.isEmpty()) {
                    this.setState(State.FINISHED);
                } else {
                    this.setState(State.SLEEPING);
                }
            }
        }
    }

    private boolean accept(CacheEntry entry) {
        for (CacheEntryFilter filter : this._definition.filters) {
            if (filter.accept(entry)) continue;
            return false;
        }
        return true;
    }

    private synchronized void add(CacheEntry entry) {
        PnfsId pnfsId = entry.getPnfsId();
        if (!this._queued.contains(pnfsId) && !this._running.containsKey(pnfsId)) {
            long size = entry.getReplicaSize();
            this._queued.add(pnfsId);
            this._sizes.put(pnfsId, size);
            this._statistics.addToTotal(size);
            this.schedule();
        }
    }

    private synchronized void remove(PnfsId pnfsId) {
        Task task = this._running.get(pnfsId);
        if (task != null) {
            task.cancel();
        } else if (this._queued.remove(pnfsId)) {
            this._sizes.remove(pnfsId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stateChanged(StateChangeEvent event) {
        PnfsId pnfsId = event.getPnfsId();
        if (event.getNewState() == EntryState.REMOVED) {
            this.remove(pnfsId);
        } else {
            CacheEntry entry = event.getEntry();
            if (!this.accept(entry)) {
                Job job = this;
                synchronized (job) {
                    if (!this._running.containsKey(pnfsId)) {
                        this.remove(pnfsId);
                    }
                }
            } else if (this._definition.isPermanent) {
                this.add(entry);
            }
        }
    }

    synchronized void taskCancelled(Task task) {
        PnfsId pnfsId = task.getPnfsId();
        this._running.remove(pnfsId);
        this._sizes.remove(pnfsId);
        this._context.unlock(pnfsId);
        this.schedule();
    }

    synchronized void taskFailed(Task task, String msg) {
        PnfsId pnfsId = task.getPnfsId();
        if (task == this._running.remove(pnfsId)) {
            this._queued.add(pnfsId);
            this._context.unlock(pnfsId);
        }
        if (this._state == State.RUNNING) {
            this.setState(State.SLEEPING);
        } else {
            this.schedule();
        }
        this.addError(new Error(task.getId(), pnfsId, msg));
    }

    synchronized void taskFailedPermanently(Task task, String msg) {
        PnfsId pnfsId = task.getPnfsId();
        this._running.remove(pnfsId);
        this._sizes.remove(pnfsId);
        this._context.unlock(pnfsId);
        this.schedule();
        this.addError(new Error(task.getId(), pnfsId, msg));
    }

    synchronized void taskCompleted(Task task) {
        PnfsId pnfsId = task.getPnfsId();
        this.applySourceMode(pnfsId);
        this._running.remove(pnfsId);
        this._context.unlock(pnfsId);
        this._statistics.addCompleted(this._sizes.remove(pnfsId));
        this.schedule();
    }

    public synchronized Object messageArrived(PoolMigrationJobCancelMessage message) {
        if (this._state == State.FINISHED || this._state == State.FAILED || this._state == State.CANCELLED) {
            message.setSucceeded();
            return message;
        }
        DelayedReply reply = new DelayedReply();
        this._cancelRequests.put(message, reply);
        this.cancel(message.isForced());
        return reply;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageArrived(PoolMigrationCopyFinishedMessage message) {
        Task task;
        Job job = this;
        synchronized (job) {
            task = this._running.get(message.getPnfsId());
        }
        if (task != null) {
            task.messageArrived(message);
        }
    }

    private void applySticky(PnfsId pnfsId, List<StickyRecord> records) throws CacheException, InterruptedException {
        for (StickyRecord record : records) {
            this._context.getRepository().setSticky(pnfsId, record.owner(), record.expire(), true);
        }
    }

    private boolean containsOwner(List<StickyRecord> records, String owner) {
        for (StickyRecord r : records) {
            if (!r.owner().equals(owner)) continue;
            return true;
        }
        return false;
    }

    private synchronized boolean isPin(StickyRecord record) {
        String prefix = this._context.getPinManagerStub().getDestinationPath().getDestinationAddress().getCellName();
        return record.owner().startsWith(prefix);
    }

    private synchronized boolean isPinned(CacheEntry entry) {
        for (StickyRecord record : entry.getStickyRecords()) {
            if (!this.isPin(record)) continue;
            return true;
        }
        return false;
    }

    private synchronized void applySourceMode(PnfsId pnfsId) {
        try {
            CacheEntryMode mode = this._definition.sourceMode;
            Repository repository = this._context.getRepository();
            CacheEntry entry = repository.getEntry(pnfsId);
            switch (mode.state) {
                case SAME: {
                    this.applySticky(pnfsId, mode.stickyRecords);
                    break;
                }
                case DELETE: {
                    if (!this.isPinned(entry)) {
                        repository.setState(pnfsId, EntryState.REMOVED);
                        break;
                    }
                }
                case REMOVABLE: {
                    List<StickyRecord> list = mode.stickyRecords;
                    this.applySticky(pnfsId, list);
                    for (StickyRecord record : entry.getStickyRecords()) {
                        String owner = record.owner();
                        if (this.isPin(record) || this.containsOwner(list, owner)) continue;
                        repository.setSticky(pnfsId, owner, 0L, true);
                    }
                    repository.setState(pnfsId, EntryState.CACHED);
                    break;
                }
                case CACHED: {
                    this.applySticky(pnfsId, mode.stickyRecords);
                    repository.setState(pnfsId, EntryState.CACHED);
                    break;
                }
                case PRECIOUS: {
                    repository.setState(pnfsId, EntryState.PRECIOUS);
                    this.applySticky(pnfsId, mode.stickyRecords);
                }
            }
        }
        catch (FileNotInCacheException e) {
        }
        catch (CacheException e) {
            _log.error("Migration job failed to update source mode: " + e.getMessage());
            this.setState(State.FAILED);
        }
        catch (IllegalTransitionException e) {
        }
        catch (InterruptedException e) {
            _log.error("Migration job was interrupted");
            this.setState(State.FAILED);
        }
    }

    public boolean evaluateLifetimePredicate(Expression expression) {
        ImmutableList<PoolManagerPoolInformation> sourceInformation = this._definition.sourceList.getPools();
        if (sourceInformation.size() == 0) {
            throw new RuntimeException("Bug detected: Source pool information was unavailable");
        }
        SymbolTable symbols = new SymbolTable();
        symbols.put("source", (PoolManagerPoolInformation)sourceInformation.get(0));
        symbols.put("queue.files", this._queued.size());
        symbols.put("queue.bytes", this._statistics.getTotal() - (long)this._statistics.getCompleted());
        symbols.put("targets", this._definition.poolList.getPools().size());
        return expression.evaluateBoolean(symbols);
    }

    protected class Error {
        private final long _id;
        private final long _time;
        private final PnfsId _pnfsId;
        private final String _error;

        public Error(long id, PnfsId pnfsId, String error) {
            this._id = id;
            this._time = System.currentTimeMillis();
            this._pnfsId = pnfsId;
            this._error = error;
        }

        public String toString() {
            return String.format("%tT [%d] %s: %s", this._time, this._id, this._pnfsId, this._error);
        }
    }

    protected class LoggingTask
    implements Runnable {
        private final Runnable _inner;

        public LoggingTask(Runnable r) {
            this._inner = r;
        }

        @Override
        public void run() {
            try {
                this._inner.run();
            }
            catch (Exception e) {
                _log.error(e.toString(), (Throwable)e);
            }
        }
    }

    static enum State {
        INITIALIZING,
        RUNNING,
        SLEEPING,
        PAUSED,
        SUSPENDED,
        STOPPING,
        CANCELLING,
        CANCELLED,
        FINISHED,
        FAILED;

    }
}

