/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.pool.classic;

import diskCacheV111.pools.StorageClassFlushInfo;
import diskCacheV111.util.CacheException;
import diskCacheV111.util.CacheFileAvailable;
import diskCacheV111.util.PnfsId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.dcache.commons.util.NDC;
import org.dcache.pool.classic.HsmStorageHandler2;
import org.dcache.pool.classic.StorageClassInfoFlushable;
import org.dcache.pool.repository.CacheEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageClassInfo
implements CacheFileAvailable {
    private static Logger _log = LoggerFactory.getLogger(StorageClassInfo.class);
    private static RepositoryEntryComparator __repositoryComparator = new RepositoryEntryComparator();
    private long _time;
    private Map<PnfsId, Entry> _requests = new HashMap<PnfsId, Entry>();
    private Map<PnfsId, Entry> _failedRequests = new HashMap<PnfsId, Entry>();
    private final String _name;
    private final String _hsmName;
    private long _expiration;
    private int _pending;
    private boolean _defined;
    private long _totalSize;
    private long _maxTotalSize;
    private int _activeCounter;
    private boolean _suspended;
    private boolean _isActive;
    private int _errorCounter;
    private long _lastSubmittedAt;
    private long _recentFlushId;
    private int _requestsSubmitted;
    private StorageClassInfoFlushable _flushCallback;

    public StorageClassInfo(String hsmName, String storageClass) {
        this._name = storageClass;
        this._hsmName = hsmName.toLowerCase();
    }

    public synchronized StorageClassFlushInfo getFlushInfo() {
        StorageClassFlushInfo info = new StorageClassFlushInfo(this._hsmName, this._name);
        Collection<Entry> entries = this._requests.values();
        if (entries.isEmpty()) {
            info.setOldestFileTimestamp(0L);
        } else {
            Entry entry = Collections.min(entries, __repositoryComparator);
            info.setOldestFileTimestamp(entry.timeStamp);
        }
        info.setRequestCount(this._requests.size());
        info.setFailedRequestCount(this._failedRequests.size());
        info.setExpirationTime(this._expiration);
        info.setMaximumPendingFileCount(this._pending);
        info.setTotalPendingFileSize(this._totalSize);
        info.setMaximumAllowedPendingFileSize(this._maxTotalSize);
        info.setActiveCount(this._activeCounter);
        info.setSuspended(this._suspended);
        info.setErrorCounter(this._errorCounter);
        info.setLastSubmittedTime(this._lastSubmittedAt);
        info.setFlushId(this._recentFlushId);
        return info;
    }

    @Override
    public synchronized void cacheFileAvailable(PnfsId pnfsId, Throwable ce) {
        if (ce != null) {
            CacheException cce;
            ++this._errorCounter;
            if (ce instanceof CacheException && (cce = (CacheException)ce).getRc() >= 30 && cce.getRc() < 40) {
                Entry entry = this.removeRequest(pnfsId);
                if (entry != null) {
                    this._failedRequests.put(entry.pnfsId, entry);
                }
                --this._errorCounter;
            }
        }
        --this._activeCounter;
        if (this._activeCounter <= 0) {
            this._activeCounter = 0;
            if (this._flushCallback != null) {
                new InformFlushCallback();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized long submit(HsmStorageHandler2 storageHandler, int maxCount, StorageClassInfoFlushable flushCallback) {
        if (this._activeCounter > 0) {
            throw new IllegalArgumentException("Is already active");
        }
        this._flushCallback = flushCallback;
        ArrayList<Entry> entries = new ArrayList<Entry>(this._requests.values());
        Collections.sort(entries, __repositoryComparator);
        maxCount = maxCount <= 0 ? entries.size() : Math.min(entries.size(), maxCount);
        this._errorCounter = 0;
        this._requestsSubmitted = 0;
        this._recentFlushId = this._lastSubmittedAt = System.currentTimeMillis();
        for (Entry entry : entries.subList(0, maxCount)) {
            ++this._requestsSubmitted;
            NDC.push((String)entry.pnfsId.toString());
            try {
                if (storageHandler.store(entry.pnfsId, this)) continue;
                ++this._activeCounter;
            }
            catch (Throwable e) {
                ++this._errorCounter;
                _log.error("Problem submitting : " + entry + " : " + e);
            }
            finally {
                NDC.pop();
            }
        }
        if (this._activeCounter <= 0) {
            this._activeCounter = 0;
            if (this._flushCallback != null) {
                new InformFlushCallback();
            }
        }
        return this._recentFlushId;
    }

    public synchronized long getLastSubmitted() {
        return this._lastSubmittedAt;
    }

    public synchronized int getActiveCount() {
        return this._activeCounter;
    }

    public synchronized int getErrorCount() {
        return this._errorCounter;
    }

    public int hashCode() {
        return this._name.hashCode() | this._hsmName.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof StorageClassInfo)) {
            return false;
        }
        StorageClassInfo info = (StorageClassInfo)obj;
        return info._name.equals(this._name) && info._hsmName.equals(this._hsmName);
    }

    private synchronized void addRequest(Entry entry) {
        this._requests.put(entry.pnfsId, entry);
        if (this._time == 0L || entry.timeStamp < this._time) {
            this._time = entry.timeStamp;
        }
        this._totalSize += entry.size;
    }

    private synchronized Entry removeRequest(PnfsId pnfsId) {
        Entry entry = this._requests.remove(pnfsId);
        if (entry != null) {
            if (this._requests.isEmpty()) {
                this._time = 0L;
            }
            this._totalSize -= entry.size;
        }
        return entry;
    }

    public synchronized void add(CacheEntry entry) throws CacheException {
        PnfsId pnfsId = entry.getPnfsId();
        if (this._failedRequests.get(pnfsId) != null || this._requests.get(pnfsId) != null) {
            throw new CacheException(44, "Request already added : " + pnfsId);
        }
        this.addRequest(new Entry(entry));
    }

    public synchronized void activate(PnfsId pnfsId) throws CacheException {
        Entry entry = this._failedRequests.remove(pnfsId);
        if (entry == null) {
            throw new CacheException("Not a deactivated Request : " + pnfsId);
        }
        this.addRequest(entry);
    }

    public synchronized void activateAll() {
        for (Entry entry : this._failedRequests.values()) {
            this.addRequest(entry);
        }
        this._failedRequests.clear();
    }

    public synchronized void deactivate(PnfsId pnfsId) throws CacheException {
        Entry entry = this.removeRequest(pnfsId);
        if (entry == null) {
            throw new CacheException("Not an activated Request : " + pnfsId);
        }
        this._failedRequests.put(pnfsId, entry);
    }

    public synchronized boolean remove(PnfsId pnfsId) {
        Entry entry = this.removeRequest(pnfsId);
        if (entry == null) {
            entry = this._failedRequests.remove(pnfsId);
        }
        return entry != null;
    }

    public String getHsm() {
        return this._hsmName;
    }

    public String getName() {
        return this._name;
    }

    public synchronized Collection<PnfsId> getRequests() {
        return new ArrayList<PnfsId>(this._requests.keySet());
    }

    public synchronized Collection<PnfsId> getFailedRequests() {
        return new ArrayList<PnfsId>(this._failedRequests.keySet());
    }

    public synchronized String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SCI=").append(this._name).append("@").append(this._hsmName).append(";def=").append(this._defined).append(";exp=").append(this._expiration / 1000L).append(";pend=").append(this._pending).append(";maxTotal=").append(this._maxTotalSize).append(";waiting=").append(this._requests.size());
        return sb.toString();
    }

    public synchronized boolean hasExpired() {
        return this._requests.size() > 0 && this._time + this._expiration < System.currentTimeMillis();
    }

    public synchronized long expiresIn() {
        return this._time == 0L ? 0L : (this._time + this._expiration - System.currentTimeMillis()) / 1000L;
    }

    public synchronized boolean isFull() {
        return this._requests.size() > 0 && (this._requests.size() >= this._pending || this._totalSize >= this._maxTotalSize);
    }

    public synchronized void setSuspended(boolean suspended) {
        this._suspended = suspended;
    }

    public synchronized boolean isSuspended() {
        return this._suspended;
    }

    public synchronized boolean isTriggered() {
        return (this.hasExpired() || this.isFull()) && !this.isSuspended();
    }

    public synchronized String getStorageClass() {
        return this._name;
    }

    public synchronized void setTime(long time) {
        this._time = time;
    }

    public synchronized long getTime() {
        return this._time;
    }

    public synchronized void setDefined(boolean d) {
        this._defined = d;
    }

    public synchronized boolean isDefined() {
        return this._defined;
    }

    public synchronized int size() {
        return this._requests.size() + this._failedRequests.size();
    }

    public synchronized long getTotalSize() {
        return this._totalSize;
    }

    public synchronized void setExpiration(int expiration) {
        this._expiration = (long)expiration * 1000L;
    }

    public synchronized void setPending(int pending) {
        this._pending = pending;
    }

    public synchronized void setMaxSize(long maxTotalSize) {
        this._maxTotalSize = maxTotalSize;
    }

    public synchronized long getMaxSize() {
        return this._maxTotalSize;
    }

    public synchronized int getPending() {
        return this._pending;
    }

    public synchronized int getExpiration() {
        return (int)(this._expiration / 1000L);
    }

    public synchronized int getRequestCount() {
        return this._requests.size();
    }

    public synchronized int getFailedRequestCount() {
        return this._failedRequests.size();
    }

    private class InformFlushCallback
    implements Runnable {
        private int _flushErrorCounter;
        private long _flushId;
        private int _requests;
        private StorageClassInfoFlushable _callback;

        private InformFlushCallback() {
            this._flushErrorCounter = StorageClassInfo.this._errorCounter;
            this._flushId = StorageClassInfo.this._recentFlushId;
            this._requests = StorageClassInfo.this._requestsSubmitted;
            this._callback = StorageClassInfo.this._flushCallback;
            if (this._callback == null) {
                return;
            }
            new Thread(this).start();
        }

        @Override
        public void run() {
            try {
                this._callback.storageClassInfoFlushed(StorageClassInfo.this.getHsm(), StorageClassInfo.this.getStorageClass(), this._flushId, this._requests, this._flushErrorCounter);
            }
            catch (Throwable t) {
                _log.error("Problem in running storageClassInfoFlushed callback : " + t);
            }
        }
    }

    static class RepositoryEntryComparator
    implements Comparator<Entry> {
        RepositoryEntryComparator() {
        }

        @Override
        public int compare(Entry a, Entry b) {
            try {
                long al = a.timeStamp;
                long bl = b.timeStamp;
                return al > bl ? 1 : (al == bl ? a.pnfsId.compareTo(b.pnfsId) : -1);
            }
            catch (Exception e) {
                return -1;
            }
        }
    }

    static class Entry {
        final PnfsId pnfsId;
        final long timeStamp;
        final long size;

        Entry(CacheEntry entry) {
            this.pnfsId = entry.getPnfsId();
            this.timeStamp = entry.getCreationTime();
            this.size = entry.getReplicaSize();
        }
    }
}

