/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.pool.classic;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import diskCacheV111.vehicles.IoJobInfo;
import diskCacheV111.vehicles.JobInfo;
import dmg.cells.nucleus.CDC;
import java.io.InterruptedIOException;
import java.nio.channels.CompletionHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.dcache.pool.classic.Cancellable;
import org.dcache.pool.classic.IoRequestState;
import org.dcache.pool.classic.IoScheduler;
import org.dcache.pool.movers.Mover;
import org.dcache.util.AdjustableSemaphore;
import org.dcache.util.FifoPriorityComparator;
import org.dcache.util.IoPrioritizable;
import org.dcache.util.IoPriority;
import org.dcache.util.LifoPriorityComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleIoScheduler
implements IoScheduler,
Runnable {
    private static final Logger _log = LoggerFactory.getLogger(SimpleIoScheduler.class);
    private final Thread _worker;
    private final String _name;
    private final BlockingQueue<PrioritizedRequest> _queue;
    private final Map<Integer, PrioritizedRequest> _jobs = new ConcurrentHashMap<Integer, PrioritizedRequest>();
    private final int _queueId;
    private int _nextId;
    private volatile boolean _shutdown;
    private final AdjustableSemaphore _semaphore = new AdjustableSemaphore();

    public SimpleIoScheduler(String name, int queueId) {
        this(name, queueId, true);
    }

    public SimpleIoScheduler(String name, int queueId, boolean fifo) {
        this._name = name;
        this._queueId = queueId;
        Comparator comparator = (Comparator)((Object)(fifo ? new FifoPriorityComparator() : new LifoPriorityComparator()));
        this._queue = new PriorityBlockingQueue<PrioritizedRequest>(16, comparator);
        this._semaphore.setMaxPermits(2);
        this._worker = new Thread(this);
        this._worker.setName(this._name);
        this._worker.start();
    }

    @Override
    public synchronized int add(Mover<?> mover, IoPriority priority) {
        Preconditions.checkState((!this._shutdown ? 1 : 0) != 0);
        int id = this._queueId << 24 | this.nextId();
        if (this._semaphore.getMaxPermits() <= 0) {
            _log.warn("A task was added to queue '{}', however the queue is not configured to execute any tasks.", (Object)this._name);
        }
        PrioritizedRequest wrapper = new PrioritizedRequest(id, mover, priority);
        this._queue.add(wrapper);
        this._jobs.put(id, wrapper);
        return id;
    }

    private synchronized int nextId() {
        this._nextId = this._nextId == 0xFFFFFF ? 0 : ++this._nextId;
        return this._nextId;
    }

    @Override
    public synchronized int getActiveJobs() {
        return this._jobs.size() - this._queue.size();
    }

    @Override
    public JobInfo getJobInfo(int id) {
        PrioritizedRequest request = this._jobs.get(id);
        if (request == null) {
            throw new NoSuchElementException("Job not found : Job-" + id);
        }
        return request.toJobInfo();
    }

    @Override
    public List<JobInfo> getJobInfos() {
        ArrayList<JobInfo> jobs = new ArrayList<JobInfo>();
        for (PrioritizedRequest request : this._jobs.values()) {
            jobs.add(request.toJobInfo());
        }
        return Collections.unmodifiableList(jobs);
    }

    @Override
    public int getMaxActiveJobs() {
        return this._semaphore.getMaxPermits();
    }

    @Override
    public int getQueueSize() {
        return this._queue.size();
    }

    @Override
    public int getCountByPriority(IoPriority priority) {
        int count = 0;
        for (PrioritizedRequest request : this._queue) {
            if (request.getPriority() != priority) continue;
            ++count;
        }
        return count;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public synchronized void cancel(int id) throws NoSuchElementException {
        PrioritizedRequest wrapper = this._jobs.get(id);
        if (wrapper == null) {
            throw new NoSuchElementException("Job " + id + " not found");
        }
        this.cancel(wrapper);
    }

    private void cancel(final PrioritizedRequest request) {
        try (CDC ignored = request.getCdc().restore();){
            if (this._queue.remove(request)) {
                request.kill();
                request.getMover().postprocess(new CompletionHandler<Void, Void>(){

                    @Override
                    public void completed(Void result, Void attachment) {
                        this.release();
                    }

                    @Override
                    public void failed(Throwable exc, Void attachment) {
                        this.release();
                    }

                    private void release() {
                        request.done();
                        SimpleIoScheduler.this._jobs.remove(request.getId());
                    }
                });
            } else {
                request.kill();
            }
        }
    }

    @Override
    public StringBuffer printJobQueue(StringBuffer sb) {
        for (Map.Entry<Integer, PrioritizedRequest> job : this._jobs.entrySet()) {
            sb.append(job.getKey()).append(" : ").append(job.getValue()).append('\n');
        }
        return sb;
    }

    @Override
    public void setMaxActiveJobs(int maxJobs) {
        this._semaphore.setMaxPermits(maxJobs);
    }

    @Override
    public synchronized void shutdown() throws InterruptedException {
        if (!this._shutdown) {
            this._shutdown = true;
            this._worker.interrupt();
            for (PrioritizedRequest request : this._jobs.values()) {
                this.cancel(request);
            }
            _log.info("Waiting for movers on queue '{}' to finish", (Object)this._name);
            if (!this._semaphore.tryAcquire(this._semaphore.getMaxPermits(), 2000L, TimeUnit.MILLISECONDS)) {
                _log.warn("Failed to terminate some movers prior to shutdown: {}", (Object)Joiner.on((String)",").join(Iterables.transform(this._jobs.values(), (Function)new Function<PrioritizedRequest, String>(){

                    public String apply(PrioritizedRequest input) {
                        return input.getMover().getProtocolInfo().getVersionString();
                    }
                })));
            }
        }
    }

    @Override
    public void run() {
        try {
            while (!this._shutdown) {
                this._semaphore.acquire();
                try {
                    final PrioritizedRequest request = this._queue.take();
                    request.getCdc().restore();
                    request.transfer(new CompletionHandler<Void, Void>(){

                        @Override
                        public void completed(Void result, Void attachment) {
                            this.postprocess();
                        }

                        @Override
                        public void failed(Throwable exc, Void attachment) {
                            if (exc instanceof InterruptedException || exc instanceof InterruptedIOException) {
                                request.getMover().setTransferStatus(666, "Transfer was killed");
                            }
                            this.postprocess();
                        }

                        private void postprocess() {
                            request.getMover().postprocess(new CompletionHandler<Void, Void>(){

                                @Override
                                public void completed(Void result, Void attachment) {
                                    this.release();
                                }

                                @Override
                                public void failed(Throwable exc, Void attachment) {
                                    this.release();
                                }

                                private void release() {
                                    request.done();
                                    SimpleIoScheduler.this._jobs.remove(request.getId());
                                    SimpleIoScheduler.this._semaphore.release();
                                }
                            });
                        }
                    });
                }
                catch (Error | InterruptedException | RuntimeException e) {
                    this._semaphore.release();
                    throw e;
                }
                finally {
                    CDC.clear();
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private static class PrioritizedRequest
    implements IoPrioritizable {
        private final Mover<?> _mover;
        private final IoPriority _priority;
        private final long _ctime;
        private final int _id;
        private final CDC _cdc;
        private IoRequestState _state;
        private final long _submitTime;
        private long _startTime;
        private Cancellable _cancellable;

        PrioritizedRequest(int id, Mover<?> mover, IoPriority p) {
            this._id = id;
            this._mover = mover;
            this._priority = p;
            this._ctime = System.nanoTime();
            this._submitTime = System.currentTimeMillis();
            this._state = IoRequestState.QUEUED;
            this._cdc = new CDC();
        }

        public Mover<?> getMover() {
            return this._mover;
        }

        public CDC getCdc() {
            return this._cdc;
        }

        public int getId() {
            return this._id;
        }

        @Override
        public IoPriority getPriority() {
            return this._priority;
        }

        @Override
        public long getCreateTime() {
            return this._ctime;
        }

        public boolean equals(Object o) {
            if (!(o instanceof PrioritizedRequest)) {
                return false;
            }
            PrioritizedRequest other = (PrioritizedRequest)o;
            return this._id == other._id;
        }

        public int hashCode() {
            return this._id;
        }

        public synchronized String toString() {
            return (Object)((Object)this._state) + " : " + this._mover.toString();
        }

        public synchronized JobInfo toJobInfo() {
            return new IoJobInfo(this._submitTime, this._startTime, this._state, this._id, this._mover);
        }

        public synchronized void transfer(CompletionHandler<Void, Void> completionHandler) {
            try {
                if (this._state != IoRequestState.QUEUED) {
                    completionHandler.failed(new InterruptedException("Transfer cancelled"), null);
                }
                this._state = IoRequestState.RUNNING;
                this._startTime = System.currentTimeMillis();
                this._cancellable = this._mover.execute(completionHandler);
            }
            catch (RuntimeException e) {
                completionHandler.failed(e, null);
            }
        }

        public synchronized void kill() {
            if (this._cancellable != null) {
                this._cancellable.cancel();
            } else {
                this._mover.setTransferStatus(666, "Transfer cancelled");
            }
            this._state = IoRequestState.CANCELED;
        }

        public synchronized void done() {
            this._state = IoRequestState.DONE;
        }
    }
}

