/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.pool.classic;

import diskCacheV111.util.CacheException;
import diskCacheV111.util.PnfsId;
import org.dcache.pool.repository.AbstractStateChangeListener;
import org.dcache.pool.repository.CacheEntry;
import org.dcache.pool.repository.EntryState;
import org.dcache.pool.repository.IllegalTransitionException;
import org.dcache.pool.repository.MetaDataRecord;
import org.dcache.pool.repository.Repository;
import org.dcache.pool.repository.SpaceSweeperPolicy;
import org.dcache.pool.repository.StateChangeEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NoCachedFilesSpaceSweeper
extends AbstractStateChangeListener
implements SpaceSweeperPolicy {
    private static final Logger _log = LoggerFactory.getLogger(NoCachedFilesSpaceSweeper.class);
    private Repository _repository;

    public void setRepository(Repository repository) {
        this._repository = repository;
        this._repository.addListener(this);
    }

    @Override
    public boolean isRemovable(MetaDataRecord entry) {
        return false;
    }

    @Override
    public long getLru() {
        return 0L;
    }

    @Override
    public void stateChanged(StateChangeEvent event) {
        try {
            if (event.getNewState() == EntryState.CACHED) {
                PnfsId id = event.getPnfsId();
                CacheEntry entry = event.getEntry();
                if (!entry.isSticky()) {
                    this._repository.setState(id, EntryState.REMOVED);
                    _log.debug(entry.getPnfsId() + " : removed.");
                }
            }
        }
        catch (CacheException | InterruptedException | IllegalTransitionException e) {
            _log.warn("Failed to remove entry from repository: " + e.getMessage());
        }
    }
}

