/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.pool.classic;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import diskCacheV111.util.CacheException;
import diskCacheV111.util.DiskErrorCacheException;
import diskCacheV111.vehicles.PoolIoFileMessage;
import diskCacheV111.vehicles.ProtocolInfo;
import dmg.cells.nucleus.CellEndpoint;
import dmg.cells.nucleus.CellPath;
import dmg.util.command.Argument;
import dmg.util.command.Command;
import java.io.SyncFailedException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.channels.CompletionHandler;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.dcache.cells.AbstractCellComponent;
import org.dcache.cells.CellCommandListener;
import org.dcache.pool.FaultAction;
import org.dcache.pool.FaultEvent;
import org.dcache.pool.FaultListener;
import org.dcache.pool.classic.Cancellable;
import org.dcache.pool.classic.ChecksumModule;
import org.dcache.pool.classic.PostTransferService;
import org.dcache.pool.classic.TransferService;
import org.dcache.pool.movers.ChecksumMover;
import org.dcache.pool.movers.IoMode;
import org.dcache.pool.movers.Mover;
import org.dcache.pool.movers.MoverFactory;
import org.dcache.pool.movers.MoverProtocol;
import org.dcache.pool.movers.MoverProtocolMover;
import org.dcache.pool.repository.ReplicaDescriptor;
import org.dcache.pool.repository.RepositoryChannel;
import org.dcache.util.CDCExecutorServiceDecorator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;

public class MoverProtocolTransferService
extends AbstractCellComponent
implements TransferService<MoverProtocolMover>,
MoverFactory,
CellCommandListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(MoverProtocolTransferService.class);
    private static final String _name = MoverProtocolTransferService.class.getSimpleName();
    private final ExecutorService _executor = new CDCExecutorServiceDecorator(Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat(_name + "transfer-service-%d").build()));
    private final ConcurrentMap<String, Class<? extends MoverProtocol>> _movermap = new ConcurrentHashMap<String, Class<? extends MoverProtocol>>();
    private FaultListener _faultListener;
    private ChecksumModule _checksumModule;
    private PostTransferService _postTransferService;

    @Required
    public void setFaultListener(FaultListener faultListener) {
        this._faultListener = faultListener;
    }

    @Required
    public void setChecksumModule(ChecksumModule checksumModule) {
        this._checksumModule = checksumModule;
    }

    @Required
    public void setPostTransferService(PostTransferService postTransferService) {
        this._postTransferService = postTransferService;
    }

    @Override
    public Mover<?> createMover(ReplicaDescriptor handle, PoolIoFileMessage message, CellPath pathToDoor) throws CacheException {
        ProtocolInfo info = message.getProtocolInfo();
        try {
            MoverProtocol moverProtocol = this.createMoverProtocol(this.getMoverProtocolClass(info));
            return new MoverProtocolMover(handle, message, pathToDoor, this, this._postTransferService, moverProtocol);
        }
        catch (InvocationTargetException e) {
            throw new CacheException(27, "Could not create mover for " + info, e.getTargetException());
        }
        catch (ClassNotFoundException e) {
            throw new CacheException(27, "Protocol " + info + " is not supported", e);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException e) {
            LOGGER.error("Invalid mover for " + info + ": " + e.toString(), (Throwable)e);
            throw new CacheException(27, "Could not create mover for " + info, e);
        }
    }

    private Class<? extends MoverProtocol> getMoverProtocolClass(ProtocolInfo info) throws ClassNotFoundException {
        String moverClassName;
        Class<MoverProtocol> oldClass;
        String protocolName = info.getProtocol() + "-" + info.getMajorVersion();
        Class<MoverProtocol> moverClass = (Class<MoverProtocol>)this._movermap.get(protocolName);
        if (moverClass == null && (oldClass = this._movermap.putIfAbsent(protocolName, moverClass = Class.forName(moverClassName = "org.dcache.pool.movers." + info.getProtocol() + "Protocol_" + info.getMajorVersion()).asSubclass(MoverProtocol.class))) != null) {
            moverClass = oldClass;
        }
        return moverClass;
    }

    private MoverProtocol createMoverProtocol(Class<? extends MoverProtocol> moverClass) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Class[] argsClass = new Class[]{CellEndpoint.class};
        Constructor<? extends MoverProtocol> moverCon = moverClass.getConstructor(argsClass);
        Object[] args = new Object[]{this.getCellEndpoint()};
        return moverCon.newInstance(args);
    }

    @Override
    public Cancellable execute(MoverProtocolMover mover, CompletionHandler<Void, Void> completionHandler) {
        MoverTask task = new MoverTask(mover, completionHandler);
        this._executor.execute(task);
        return task;
    }

    public void shutdown() {
        this._executor.shutdown();
    }

    static /* synthetic */ ChecksumModule access$000(MoverProtocolTransferService x0) {
        return x0._checksumModule;
    }

    static /* synthetic */ Logger access$100() {
        return LOGGER;
    }

    static /* synthetic */ FaultListener access$200(MoverProtocolTransferService x0) {
        return x0._faultListener;
    }

    static class 1 {
        static final /* synthetic */ int[] $SwitchMap$org$dcache$pool$movers$IoMode;

        static {
            $SwitchMap$org$dcache$pool$movers$IoMode = new int[IoMode.values().length];
            try {
                1.$SwitchMap$org$dcache$pool$movers$IoMode[IoMode.WRITE.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$dcache$pool$movers$IoMode[IoMode.READ.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }

    @Command(name="movermap ls", usage="Lists all defined protocol mappings.")
    class ListCommand
    implements Callable<String> {
        ListCommand() {
        }

        @Override
        public String call() throws Exception {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry entry : MoverProtocolTransferService.this._movermap.entrySet()) {
                sb.append((String)entry.getKey()).append(" -> ").append(((Class)entry.getValue()).getName()).append("\n");
            }
            return sb.toString();
        }
    }

    @Command(name="movermap undefine", usage="Removes a transfer protocol mapping")
    class UndefineCommand
    implements Callable<String> {
        @Argument(valueSpec="PROTOCOL-MAJOR", help="Protocol identification string")
        String protocol;

        UndefineCommand() {
        }

        @Override
        public String call() {
            MoverProtocolTransferService.this._movermap.remove(this.protocol);
            return "";
        }
    }

    @Command(name="movermap define", usage="Adds a transfer protocol mapping")
    class DefineCommand
    implements Callable<String> {
        @Argument(index=0, valueSpec="PROTOCOL-MAJOR", help="Protocol identification string")
        String protocol;
        @Argument(index=1, metaVar="moverclassname", help="A class implementing the MoverProtocol interface.")
        String moverClassName;

        DefineCommand() {
        }

        @Override
        public String call() throws ClassNotFoundException {
            MoverProtocolTransferService.this._movermap.put(this.protocol, Class.forName(this.moverClassName).asSubclass(MoverProtocol.class));
            return "";
        }
    }

    private class MoverTask
    implements Runnable,
    Cancellable {
        private final MoverProtocolMover _mover;
        private final CompletionHandler<Void, Void> _completionHandler;
        private Thread _thread;
        private boolean _needInterruption;

        public MoverTask(MoverProtocolMover mover, CompletionHandler<Void, Void> completionHandler) {
            this._mover = mover;
            this._completionHandler = completionHandler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            block34: {
                try {
                    this.setThread();
                    try {
                        fileIoChannel = this._mover.openChannel();
                        var2_5 = null;
                        try {
                            switch (1.$SwitchMap$org$dcache$pool$movers$IoMode[this._mover.getIoMode().ordinal()]) {
                                case 1: {
                                    try {
                                        moverProtocol = this._mover.getMover();
                                        if (MoverProtocolTransferService.access$000(MoverProtocolTransferService.this).hasPolicy(ChecksumModule.PolicyFlag.ON_TRANSFER) && moverProtocol instanceof ChecksumMover) {
                                            ((ChecksumMover)moverProtocol).enableTransferChecksum(MoverProtocolTransferService.access$000(MoverProtocolTransferService.this).getPreferredChecksumFactory(this._mover.getIoHandle()).getType());
                                        }
                                        this.runMover(fileIoChannel);
                                    }
                                    catch (Throwable var4_10) {
                                        try {
                                            fileIoChannel.sync();
                                        }
                                        catch (SyncFailedException e) {
                                            fileIoChannel.sync();
                                            MoverProtocolTransferService.access$100().info("First sync failed [" + e + "], but second sync suceeded");
                                        }
                                        throw var4_10;
                                    }
                                    try {
                                        fileIoChannel.sync();
                                        ** break;
lbl25:
                                        // 1 sources

                                    }
                                    catch (SyncFailedException e) {
                                        fileIoChannel.sync();
                                        MoverProtocolTransferService.access$100().info("First sync failed [" + e + "], but second sync suceeded");
                                        ** break;
                                    }
lbl30:
                                    // 1 sources

                                    break;
                                }
                                case 2: {
                                    this.runMover(fileIoChannel);
                                    break;
                                }
                                ** default:
lbl35:
                                // 1 sources

                                break;
                            }
                        }
                        catch (Throwable var3_9) {
                            var2_5 = var3_9;
                            throw var3_9;
                        }
                        finally {
                            if (fileIoChannel != null) {
                                if (var2_5 != null) {
                                    try {
                                        fileIoChannel.close();
                                    }
                                    catch (Throwable x2) {
                                        var2_5.addSuppressed(x2);
                                    }
                                } else {
                                    fileIoChannel.close();
                                }
                            }
                        }
                    }
                    catch (DiskErrorCacheException e) {
                        MoverProtocolTransferService.access$200(MoverProtocolTransferService.this).faultOccurred(new FaultEvent("repository", FaultAction.DISABLED, e.getMessage(), e));
                        this._completionHandler.failed(e, null);
                        this.cleanThread();
                        return;
                    }
                    catch (Throwable t) {
                        this._completionHandler.failed(t, null);
                        this.cleanThread();
                        return;
                    }
                    this._completionHandler.completed(null, null);
                    break block34;
                    {
                        catch (InterruptedException e) {
                            this._completionHandler.failed(e, null);
                            break block34;
                        }
                        catch (Throwable var8_14) {
                            throw var8_14;
                        }
                    }
                }
                finally {
                    this.cleanThread();
                }
            }
        }

        private void runMover(RepositoryChannel fileIoChannel) throws Exception {
            this._mover.getMover().runIO(this._mover.getFileAttributes(), fileIoChannel, (ProtocolInfo)this._mover.getProtocolInfo(), this._mover.getIoHandle(), this._mover.getIoMode());
        }

        private synchronized void setThread() throws InterruptedException {
            if (this._needInterruption) {
                throw new InterruptedException("Thread interrupted before execution");
            }
            this._thread = Thread.currentThread();
        }

        private synchronized void cleanThread() {
            this._thread = null;
        }

        @Override
        public synchronized void cancel() {
            if (this._thread != null) {
                this._thread.interrupt();
            } else {
                this._needInterruption = true;
            }
        }
    }
}

