/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.pool.classic;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import diskCacheV111.vehicles.JobInfo;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.NoSuchElementException;
import org.dcache.pool.classic.IoScheduler;
import org.dcache.pool.classic.JobTimeoutManager;
import org.dcache.pool.classic.SimpleIoScheduler;
import org.dcache.pool.movers.Mover;
import org.dcache.util.IoPriority;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoQueueManager {
    private static final Logger _log = LoggerFactory.getLogger(IoQueueManager.class);
    public static final String DEFAULT_QUEUE = "regular";
    private final ImmutableList<IoScheduler> _queues;
    private final ImmutableMap<String, IoScheduler> _queuesByName;

    public IoQueueManager(JobTimeoutManager jobTimeoutManager, String[] names) {
        HashMap<String, SimpleIoScheduler> queuesByName = new HashMap<String, SimpleIoScheduler>();
        ArrayList<SimpleIoScheduler> queues = new ArrayList<SimpleIoScheduler>();
        for (String name : Iterables.concat(Arrays.asList(DEFAULT_QUEUE), Arrays.asList(names))) {
            boolean fifo;
            if ((name = name.trim()).isEmpty()) continue;
            boolean bl = fifo = !name.startsWith("-");
            if (!fifo) {
                name = name.substring(1);
            }
            if (!queuesByName.containsKey(name)) {
                _log.debug("Creating queue: {}", (Object)name);
                SimpleIoScheduler job = new SimpleIoScheduler(name, queues.size(), fifo);
                queues.add(job);
                queuesByName.put(name, job);
                jobTimeoutManager.addScheduler(name, job);
                continue;
            }
            _log.warn("Queue not created, name already exists: {}", (Object)name);
        }
        this._queues = ImmutableList.copyOf(queues);
        this._queuesByName = ImmutableMap.copyOf(queuesByName);
        _log.debug("Defined IO queues: {}", (Object)this._queuesByName.keySet());
    }

    public IoScheduler getDefaultQueue() {
        return (IoScheduler)this._queues.get(0);
    }

    public ImmutableCollection<IoScheduler> getQueues() {
        return this._queues;
    }

    public IoScheduler getQueue(String queueName) {
        return (IoScheduler)this._queuesByName.get((Object)queueName);
    }

    public IoScheduler getQueueByJobId(int id) {
        int pos = id >> 24;
        if (pos >= this._queues.size()) {
            throw new IllegalArgumentException("Invalid id (doesn't belong to any known scheduler)");
        }
        return (IoScheduler)this._queues.get(pos);
    }

    public int add(String queueName, Mover<?> transfer, IoPriority priority) {
        IoScheduler js = queueName == null ? null : (IoScheduler)this._queuesByName.get((Object)queueName);
        return js == null ? this.add(transfer, priority) : js.add(transfer, priority);
    }

    public int add(Mover<?> transfer, IoPriority priority) {
        return this.getDefaultQueue().add(transfer, priority);
    }

    public void cancel(int jobId) throws NoSuchElementException {
        this.getQueueByJobId(jobId).cancel(jobId);
    }

    public int getMaxActiveJobs() {
        int sum = 0;
        for (IoScheduler s : this._queues) {
            sum += s.getMaxActiveJobs();
        }
        return sum;
    }

    public int getActiveJobs() {
        int sum = 0;
        for (IoScheduler s : this._queues) {
            sum += s.getActiveJobs();
        }
        return sum;
    }

    public int getQueueSize() {
        int sum = 0;
        for (IoScheduler s : this._queues) {
            sum += s.getQueueSize();
        }
        return sum;
    }

    public List<JobInfo> getJobInfos() {
        ArrayList<JobInfo> list = new ArrayList<JobInfo>();
        for (IoScheduler s : this._queues) {
            list.addAll(s.getJobInfos());
        }
        return list;
    }

    public void printSetup(PrintWriter pw) {
        for (IoScheduler s : this._queues) {
            pw.println("mover set max active -queue=" + s.getName() + " " + s.getMaxActiveJobs());
        }
    }

    public JobInfo findJob(String client, long id) {
        for (JobInfo info : this.getJobInfos()) {
            if (!client.equals(info.getClientName()) || id != info.getClientId()) continue;
            return info;
        }
        return null;
    }

    public synchronized void shutdown() throws InterruptedException {
        for (IoScheduler queue : this._queues) {
            queue.shutdown();
        }
    }
}

