/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.pool.classic;

import com.google.common.base.Charsets;
import com.google.common.base.Throwables;
import com.google.common.io.Files;
import diskCacheV111.util.Batchable;
import diskCacheV111.util.CacheException;
import diskCacheV111.util.CacheFileAvailable;
import diskCacheV111.util.DiskErrorCacheException;
import diskCacheV111.util.FileInCacheException;
import diskCacheV111.util.FileNotInCacheException;
import diskCacheV111.util.HsmLocationExtractorFactory;
import diskCacheV111.util.HsmSet;
import diskCacheV111.util.JobScheduler;
import diskCacheV111.util.PnfsHandler;
import diskCacheV111.util.PnfsId;
import diskCacheV111.util.RunSystem;
import diskCacheV111.util.SimpleJobScheduler;
import diskCacheV111.vehicles.PoolFileFlushedMessage;
import diskCacheV111.vehicles.PoolRemoveFilesFromHSMMessage;
import diskCacheV111.vehicles.StorageInfo;
import diskCacheV111.vehicles.StorageInfoMessage;
import diskCacheV111.vehicles.StorageInfos;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.CellPath;
import dmg.cells.nucleus.NoRouteToCellException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.dcache.cells.AbstractCellComponent;
import org.dcache.namespace.FileAttribute;
import org.dcache.pool.classic.ChecksumModule;
import org.dcache.pool.classic.HsmRemoveTask;
import org.dcache.pool.repository.EntryState;
import org.dcache.pool.repository.IllegalTransitionException;
import org.dcache.pool.repository.ReplicaDescriptor;
import org.dcache.pool.repository.Repository;
import org.dcache.pool.repository.StickyRecord;
import org.dcache.util.Checksum;
import org.dcache.util.FireAndForgetTask;
import org.dcache.vehicles.FileAttributes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HsmStorageHandler2
extends AbstractCellComponent {
    private static Logger _log = LoggerFactory.getLogger(HsmStorageHandler2.class);
    private final Repository _repository;
    private final HsmSet _hsmSet;
    private final PnfsHandler _pnfs;
    private final ChecksumModule _checksumModule;
    private final Map<PnfsId, StoreThread> _storePnfsidList = new HashMap<PnfsId, StoreThread>();
    private final Map<PnfsId, FetchThread> _restorePnfsidList = new HashMap<PnfsId, FetchThread>();
    private final JobScheduler _fetchQueue;
    private final JobScheduler _storeQueue;
    private final Executor _hsmRemoveExecutor = Executors.newSingleThreadExecutor();
    private final ThreadPoolExecutor _hsmRemoveTaskExecutor = new ThreadPoolExecutor(1, 1, Long.MAX_VALUE, TimeUnit.NANOSECONDS, new LinkedBlockingQueue<Runnable>());
    private long _maxRuntime;
    private long _maxStoreRun = this._maxRuntime = 14400000L;
    private long _maxRestoreRun = this._maxRuntime;
    private long _maxRemoveRun = this._maxRuntime;
    private int _maxLines = 200;
    private String _flushMessageTarget;

    public HsmStorageHandler2(Repository repository, HsmSet hsmSet, PnfsHandler pnfs, ChecksumModule checksumModule) {
        this._repository = repository;
        this._hsmSet = hsmSet;
        this._pnfs = pnfs;
        this._checksumModule = checksumModule;
        this._fetchQueue = new SimpleJobScheduler("fetch");
        this._storeQueue = new SimpleJobScheduler("store");
    }

    public void shutdown() {
        this._fetchQueue.shutdown();
        this._storeQueue.shutdown();
    }

    public void setFlushMessageTarget(String flushMessageTarget) {
        this._flushMessageTarget = flushMessageTarget;
    }

    private void assertInitialized() {
        if (this.getCellEndpoint() == null) {
            throw new IllegalStateException("Cell endpoint must be set");
        }
        if (this._flushMessageTarget == null) {
            throw new IllegalStateException("Flush message target must be set");
        }
    }

    synchronized void setTimeout(long storeTimeout, long restoreTimeout, long removeTimeout) {
        if (storeTimeout > 0L) {
            this._maxStoreRun = storeTimeout;
        }
        if (restoreTimeout > 0L) {
            this._maxRestoreRun = restoreTimeout;
        }
        if (removeTimeout > 0L) {
            this._maxRemoveRun = removeTimeout;
        }
    }

    public synchronized void setMaxActiveRestores(int restores) {
        try {
            this._fetchQueue.setMaxActiveJobs(restores);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Illegal value of max active restores: " + e.getMessage(), e);
        }
    }

    @Override
    public synchronized void printSetup(PrintWriter pw) {
        pw.println("#\n# HsmStorageHandler2(" + this.getClass().getName() + ")\n#");
        pw.println("rh set max active " + this._fetchQueue.getMaxActiveJobs());
        pw.println("st set max active " + this._storeQueue.getMaxActiveJobs());
        pw.println("rm set max active " + this.getMaxRemoveJobs());
        pw.println("rh set timeout " + this._maxRestoreRun / 1000L);
        pw.println("st set timeout " + this._maxStoreRun / 1000L);
        pw.println("rm set timeout " + this._maxRemoveRun / 1000L);
    }

    @Override
    public synchronized void getInfo(PrintWriter pw) {
        pw.println("         Version  : $Id$");
        pw.println(" Restore Timeout  : " + this._maxRestoreRun / 1000L);
        pw.println("   Store Timeout  : " + this._maxStoreRun / 1000L);
        pw.println("  Remove Timeout  : " + this._maxRemoveRun / 1000L);
        pw.println("  Job Queues ");
        pw.println("    to store   " + this._storeQueue.getActiveJobs() + "(" + this._storeQueue.getMaxActiveJobs() + ")/" + this._storeQueue.getQueueSize());
        pw.println("    from store " + this._fetchQueue.getActiveJobs() + "(" + this._fetchQueue.getMaxActiveJobs() + ")/" + this._fetchQueue.getQueueSize());
        pw.println("    delete     (" + this.getMaxRemoveJobs() + ")/" + "");
    }

    private synchronized String getSystemCommand(File file, FileAttributes fileAttributes, HsmSet.HsmInfo hsm, String direction) {
        PnfsId pnfsId = fileAttributes.getPnfsId();
        StorageInfo storageInfo = StorageInfos.extractFrom(fileAttributes);
        String hsmCommand = hsm.getAttribute("command");
        if (hsmCommand == null) {
            throw new IllegalArgumentException("hsmCommand not specified in HsmSet");
        }
        String localPath = file.getPath();
        StringBuilder sb = new StringBuilder();
        sb.append(hsmCommand).append(" ").append(direction).append(" ").append(pnfsId).append("  ").append(localPath);
        sb.append(" -si=").append(storageInfo.toString());
        for (Map.Entry<String, String> attr : hsm.attributes()) {
            String key = attr.getKey();
            String val = attr.getValue();
            sb.append(" -").append(key);
            if (val == null || val.length() <= 0) continue;
            sb.append("=").append(val);
        }
        if (!storageInfo.locations().isEmpty()) {
            for (URI location : storageInfo.locations()) {
                if (!location.getScheme().equals(hsm.getType()) || !location.getAuthority().equals(hsm.getInstance())) continue;
                sb.append(" -uri=").append(location.toString());
            }
        }
        String completeCommand = sb.toString();
        _log.debug("HSM_COMMAND: " + completeCommand);
        return completeCommand;
    }

    public JobScheduler getFetchScheduler() {
        return this._fetchQueue;
    }

    public synchronized void fetch(FileAttributes fileAttributes, CacheFileAvailable callback) throws FileInCacheException, CacheException {
        this.assertInitialized();
        FetchThread info = this._restorePnfsidList.get(fileAttributes.getPnfsId());
        if (info != null) {
            if (callback != null) {
                info.addCallback(callback);
            }
            return;
        }
        info = new FetchThread(fileAttributes);
        if (callback != null) {
            info.addCallback(callback);
        }
        try {
            this._fetchQueue.add(info);
            this._restorePnfsidList.put(fileAttributes.getPnfsId(), info);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Failed to queue fetch request", e.getCause());
        }
    }

    protected synchronized void removeFetchEntry(PnfsId id) {
        this._restorePnfsidList.remove(id);
    }

    public synchronized Collection<PnfsId> getPnfsIds() {
        ArrayList<PnfsId> v = new ArrayList<PnfsId>(this._restorePnfsidList.size() + this._storePnfsidList.size());
        v.addAll(this._restorePnfsidList.keySet());
        v.addAll(this._storePnfsidList.keySet());
        return v;
    }

    public synchronized Collection<PnfsId> getStorePnfsIds() {
        return new ArrayList<PnfsId>(this._storePnfsidList.keySet());
    }

    public synchronized Collection<PnfsId> getRestorePnfsIds() {
        return new ArrayList<PnfsId>(this._restorePnfsidList.keySet());
    }

    public synchronized Info getRestoreInfoByPnfsId(PnfsId pnfsId) {
        return this._restorePnfsidList.get(pnfsId);
    }

    private String findAccessibleLocation(FileAttributes fileAttributes) {
        StorageInfo file = fileAttributes.getStorageInfo();
        if (file.locations().isEmpty() && this._hsmSet.getHsmInstances().contains(file.getHsm())) {
            return file.getHsm();
        }
        for (URI location : file.locations()) {
            if (!this._hsmSet.getHsmInstances().contains(location.getAuthority())) continue;
            return location.getAuthority();
        }
        return null;
    }

    private synchronized String getFetchCommand(File file, FileAttributes fileAttributes) {
        String instance = this.findAccessibleLocation(fileAttributes);
        if (instance == null) {
            throw new IllegalArgumentException("HSM not defined on this pool: " + fileAttributes.getStorageInfo().locations());
        }
        HsmSet.HsmInfo hsm = this._hsmSet.getHsmInfoByName(instance);
        _log.debug("getFetchCommand for {} on HSM {}", (Object)fileAttributes, (Object)instance);
        return this.getSystemCommand(file, fileAttributes, hsm, "get");
    }

    public synchronized void setMaxRemoveJobs(int max) {
        this._hsmRemoveTaskExecutor.setCorePoolSize(max);
        this._hsmRemoveTaskExecutor.setMaximumPoolSize(max);
    }

    public synchronized int getMaxRemoveJobs() {
        return this._hsmRemoveTaskExecutor.getMaximumPoolSize();
    }

    public synchronized void remove(CellMessage message) {
        this.assertInitialized();
        assert (message.getMessageObject() instanceof PoolRemoveFilesFromHSMMessage);
        HsmRemoveTask task = new HsmRemoveTask(this.getCellEndpoint(), this._hsmRemoveTaskExecutor, this._hsmSet, this._maxRemoveRun, message);
        this._hsmRemoveExecutor.execute(new FireAndForgetTask(task));
    }

    private synchronized String getStoreCommand(File file, FileAttributes fileAttributes) {
        StorageInfo storageInfo = fileAttributes.getStorageInfo();
        String hsmType = storageInfo.getHsm();
        _log.debug("getStoreCommand for pnfsid=" + fileAttributes.getPnfsId() + ";hsm=" + hsmType + ";si=" + storageInfo);
        List<HsmSet.HsmInfo> hsms = this._hsmSet.getHsmInfoByType(hsmType);
        if (hsms.isEmpty()) {
            throw new IllegalArgumentException("Info not found for : " + hsmType);
        }
        HsmSet.HsmInfo hsm = hsms.get(0);
        return this.getSystemCommand(file, fileAttributes, hsm, "put");
    }

    public synchronized Info getStoreInfoByPnfsId(PnfsId pnfsId) {
        return this._storePnfsidList.get(pnfsId);
    }

    public JobScheduler getStoreScheduler() {
        return this._storeQueue;
    }

    public synchronized boolean store(PnfsId pnfsId, CacheFileAvailable callback) throws CacheException, InterruptedException {
        this.assertInitialized();
        _log.debug("store requested for " + pnfsId + (callback == null ? " w/o " : " with ") + "callback");
        if (this._repository.getState(pnfsId) == EntryState.CACHED) {
            _log.debug("is already cached " + pnfsId);
            return true;
        }
        StoreThread info = this._storePnfsidList.get(pnfsId);
        if (info != null) {
            if (callback != null) {
                info.addCallback(callback);
            }
            _log.debug("flush already in progress " + pnfsId + " (callback=" + callback + ")");
            return false;
        }
        info = new StoreThread(pnfsId);
        if (callback != null) {
            info.addCallback(callback);
        }
        try {
            this._storeQueue.add(info);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Failed to queue store request", e.getCause());
        }
        this._storePnfsidList.put(pnfsId, info);
        _log.debug("added to flush queue " + pnfsId + " (callback=" + callback + ")");
        return false;
    }

    protected synchronized void removeStoreEntry(PnfsId id) {
        this._storePnfsidList.remove(id);
    }

    private class StoreThread
    extends Info
    implements Batchable {
        private final StorageInfoMessage _infoMsg;
        private long _timestamp;
        private int _id;
        private Thread _thread;

        public StoreThread(PnfsId pnfsId) {
            super(pnfsId);
            this._infoMsg = new StorageInfoMessage(HsmStorageHandler2.this.getCellAddress().toString(), pnfsId, false);
        }

        public String toString() {
            return this.getPnfsId().toString();
        }

        @Override
        public String getClient() {
            return "[Unknown]";
        }

        @Override
        public long getClientId() {
            return 0L;
        }

        @Override
        protected synchronized void setThread(Thread thread) {
            this._thread = thread;
        }

        @Override
        public synchronized boolean kill() {
            if (this._thread == null) {
                return false;
            }
            this._thread.interrupt();
            return true;
        }

        @Override
        public void queued(int id) {
            this._timestamp = System.currentTimeMillis();
            this._id = id;
        }

        private void sendBillingInfo() {
            try {
                HsmStorageHandler2.this.sendMessage(new CellMessage(new CellPath("billing"), (Serializable)this._infoMsg));
            }
            catch (NoRouteToCellException e) {
                _log.error("Failed to send message to billing: " + e.getMessage());
            }
        }

        @Override
        public void unqueued() {
            HsmStorageHandler2.this.removeStoreEntry(this.getPnfsId());
            CacheException e = new CacheException(44, "Job dequeued (by operator)");
            this.executeCallbacks(e);
            this._infoMsg.setTimeQueued(System.currentTimeMillis() - this._timestamp);
            this._infoMsg.setResult(e.getRc(), e.getMessage());
            this.sendBillingInfo();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            PnfsId pnfsId = this.getPnfsId();
            Throwable excep = null;
            try {
                this.setThread(Thread.currentThread());
                _log.debug("Store thread started " + this._thread);
                try {
                    _log.debug("Checking if file still exists");
                    HsmStorageHandler2.this._pnfs.getFileAttributes(pnfsId, EnumSet.noneOf(FileAttribute.class));
                }
                catch (CacheException e) {
                    switch (e.getRc()) {
                        case 10001: {
                            try {
                                HsmStorageHandler2.this._repository.setState(pnfsId, EntryState.REMOVED);
                                _log.info("File not found in name space; removed " + pnfsId);
                            }
                            catch (IllegalTransitionException f) {
                                _log.error("File not found in name space, but failed to remove " + pnfsId + ": " + f);
                            }
                            break;
                        }
                        case 10016: {
                            _log.warn("File no longer appears in the name space; the pool can however not confirm that it has been deleted and will thus not remove the file");
                        }
                    }
                    throw e;
                }
                Set<Repository.OpenFlags> flags = Collections.emptySet();
                ReplicaDescriptor handle = HsmStorageHandler2.this._repository.openEntry(pnfsId, flags);
                FileAttributes fileAttributesForNotification = new FileAttributes();
                try {
                    HsmStorageHandler2.this._checksumModule.enforcePreFlushPolicy(handle);
                    FileAttributes fileAttributes = handle.getFileAttributes();
                    StorageInfo storageInfo = fileAttributes.getStorageInfo().clone();
                    this._infoMsg.setStorageInfo(storageInfo);
                    this._infoMsg.setFileSize(fileAttributes.getSize());
                    long now = System.currentTimeMillis();
                    this._infoMsg.setTimeQueued(now - this._timestamp);
                    this._timestamp = now;
                    String storeCommand = HsmStorageHandler2.this.getStoreCommand(handle.getFile(), fileAttributes);
                    RunSystem run = new RunSystem(storeCommand, HsmStorageHandler2.this._maxLines, HsmStorageHandler2.this._maxStoreRun);
                    run.go();
                    int returnCode = run.getExitValue();
                    if (returnCode != 0) {
                        _log.error("HSM script returned " + returnCode + ": " + run.getErrorString());
                        throw new CacheException(returnCode, run.getErrorString());
                    }
                    String outputData = run.getOutputString();
                    if (outputData != null && outputData.length() != 0) {
                        BufferedReader in = new BufferedReader(new StringReader(outputData));
                        String line = null;
                        try {
                            while ((line = in.readLine()) != null) {
                                String uri = line.trim();
                                if (uri.isEmpty()) continue;
                                URI location = new URI(uri);
                                HsmLocationExtractorFactory.validate(location);
                                storageInfo.addLocation(location);
                                storageInfo.isSetAddLocation(true);
                                _log.debug(pnfsId.toString() + ": added HSM location " + location);
                            }
                        }
                        catch (URISyntaxException use) {
                            _log.error("HSM script produced BAD URI: " + line);
                            throw new CacheException(2, use.getMessage());
                        }
                        catch (IOException ie) {
                            throw new RuntimeException("Bug detected");
                        }
                    }
                    fileAttributesForNotification.setAccessLatency(fileAttributes.getAccessLatency());
                    fileAttributesForNotification.setRetentionPolicy(fileAttributes.getRetentionPolicy());
                    fileAttributesForNotification.setStorageInfo(storageInfo);
                    fileAttributesForNotification.setSize(fileAttributes.getSize());
                }
                finally {
                    this.setThread(null);
                    Thread.interrupted();
                    handle.close();
                }
                while (true) {
                    try {
                        HsmStorageHandler2.this._pnfs.fileFlushed(pnfsId, fileAttributesForNotification);
                    }
                    catch (CacheException e) {
                        if (e.getRc() == 10001 || e.getRc() == 10016) break;
                        _log.error("Error notifying PNFS about a flushed file: " + e.getMessage() + "(" + e.getRc() + ")");
                        Thread.sleep(120000L);
                        continue;
                    }
                    break;
                }
                this.notifyFlushMessageTarget(fileAttributesForNotification);
                _log.info("File successfully stored to tape");
                HsmStorageHandler2.this._repository.setState(pnfsId, EntryState.CACHED);
            }
            catch (IllegalTransitionException e) {
            }
            catch (FileNotInCacheException e) {
                this._infoMsg.setResult(e.getRc(), "Flush aborted because file was deleted");
            }
            catch (CacheException e) {
                excep = e;
                _log.error("Error while flushing to tape: " + e);
                this._infoMsg.setResult(e.getRc(), e.getMessage());
            }
            catch (InterruptedException e) {
                excep = e;
                _log.error("Process interrupted (timed out)");
                this._infoMsg.setResult(1, "Flush timed out");
            }
            catch (IOException e) {
                excep = e;
                _log.error("Process got an IOException : " + e);
                this._infoMsg.setResult(2, "IO Error: " + e.getMessage());
            }
            catch (IllegalThreadStateException e) {
                excep = e;
                _log.error("Cannot stop process : " + e);
                this._infoMsg.setResult(3, e.getMessage());
            }
            catch (IllegalArgumentException e) {
                excep = e;
                _log.error("Cannot determine 'hsmInfo': " + e.getMessage());
                this._infoMsg.setResult(4, e.getMessage());
            }
            catch (Throwable t) {
                excep = t;
                _log.error("Unexpected exception", t);
                this._infoMsg.setResult(666, t.getMessage());
            }
            finally {
                HsmStorageHandler2.this.removeStoreEntry(pnfsId);
                this._infoMsg.setTransferTime(System.currentTimeMillis() - this._timestamp);
                this.sendBillingInfo();
                this.executeCallbacks(excep);
            }
        }

        private void notifyFlushMessageTarget(FileAttributes fileAttributes) {
            try {
                PoolFileFlushedMessage poolFileFlushedMessage = new PoolFileFlushedMessage(HsmStorageHandler2.this.getCellName(), this.getPnfsId(), fileAttributes);
                poolFileFlushedMessage.setReplyRequired(false);
                CellMessage msg = new CellMessage(new CellPath(HsmStorageHandler2.this._flushMessageTarget), (Serializable)poolFileFlushedMessage);
                HsmStorageHandler2.this.sendMessage(msg);
            }
            catch (NoRouteToCellException e) {
                _log.info("Failed to send message to " + HsmStorageHandler2.this._flushMessageTarget + ": " + e.getMessage());
            }
        }
    }

    private class FetchThread
    extends Info
    implements Batchable {
        private final ReplicaDescriptor _handle;
        private final StorageInfoMessage _infoMsg;
        private long _timestamp;
        private int _id;
        private Thread _thread;

        public FetchThread(FileAttributes fileAttributes) throws CacheException, FileInCacheException {
            super(fileAttributes.getPnfsId());
            this._infoMsg = new StorageInfoMessage(HsmStorageHandler2.this.getCellAddress().toString(), fileAttributes.getPnfsId(), true);
            this._infoMsg.setStorageInfo(fileAttributes.getStorageInfo());
            long fileSize = fileAttributes.getSize();
            this._infoMsg.setFileSize(fileSize);
            List<StickyRecord> stickyRecords = Collections.emptyList();
            this._handle = HsmStorageHandler2.this._repository.createEntry(fileAttributes, EntryState.FROM_STORE, EntryState.CACHED, stickyRecords, EnumSet.noneOf(Repository.OpenFlags.class));
        }

        public String toString() {
            return this.getPnfsId().toString();
        }

        @Override
        public String getClient() {
            return "[Unknown]";
        }

        @Override
        public long getClientId() {
            return 0L;
        }

        @Override
        public void queued(int id) {
            this._timestamp = System.currentTimeMillis();
            this._id = id;
        }

        public double getTransferRate() {
            return 10.0;
        }

        @Override
        protected synchronized void setThread(Thread thread) {
            this._thread = thread;
        }

        @Override
        public synchronized boolean kill() {
            if (this._thread == null) {
                return false;
            }
            this._thread.interrupt();
            return true;
        }

        private void sendBillingInfo() {
            try {
                HsmStorageHandler2.this.sendMessage(new CellMessage(new CellPath("billing"), (Serializable)this._infoMsg));
            }
            catch (NoRouteToCellException e) {
                _log.error("Failed to send message to billing: " + e.getMessage());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void unqueued() {
            PnfsId pnfsId = this.getPnfsId();
            try {
                _log.info("Dequeuing " + pnfsId);
                this._handle.close();
            }
            finally {
                HsmStorageHandler2.this.removeFetchEntry(pnfsId);
                CacheException e = new CacheException(33, "Job dequeued (by operator)");
                this.executeCallbacks(e);
                this._infoMsg.setTimeQueued(System.currentTimeMillis() - this._timestamp);
                this._infoMsg.setResult(e.getRc(), e.getMessage());
                this.sendBillingInfo();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Exception excep = null;
            PnfsId pnfsId = this.getPnfsId();
            FileAttributes attributes = this._handle.getFileAttributes();
            try {
                this.setThread(Thread.currentThread());
                try {
                    _log.debug("FetchThread started");
                    long now = System.currentTimeMillis();
                    this._infoMsg.setTimeQueued(now - this._timestamp);
                    this._timestamp = now;
                    String fetchCommand = HsmStorageHandler2.this.getFetchCommand(this._handle.getFile(), attributes);
                    long fileSize = attributes.getSize();
                    _log.debug("Waiting for space (" + fileSize + " bytes)");
                    this._handle.allocate(fileSize);
                    _log.debug("Got Space (" + fileSize + " bytes)");
                    RunSystem run = new RunSystem(fetchCommand, HsmStorageHandler2.this._maxLines, HsmStorageHandler2.this._maxRestoreRun);
                    run.go();
                    int returnCode = run.getExitValue();
                    if (returnCode != 0) {
                        if (returnCode == 71) {
                            returnCode = 10013;
                        }
                        throw new CacheException(returnCode, "HSM script failed: " + run.getErrorString());
                    }
                    this.doChecksum(this._handle);
                }
                finally {
                    this.setThread(null);
                    Thread.interrupted();
                }
                this._handle.commit();
                _log.info("File successfully restored from tape");
            }
            catch (CacheException e) {
                _log.error(e.toString());
                boolean returnCode = true;
                excep = e;
            }
            catch (InterruptedException e) {
                _log.error("Process interrupted (timed out)");
                boolean returnCode = true;
                excep = e;
            }
            catch (IOException e) {
                _log.error("Process got an IOException: " + e);
                int returnCode = 2;
                excep = e;
            }
            catch (IllegalThreadStateException e) {
                _log.error("Cannot stop process: " + e);
                int returnCode = 3;
                excep = e;
            }
            catch (IllegalArgumentException e) {
                _log.error("Cannot determine 'hsmInfo': " + e.getMessage());
                int returnCode = 4;
                excep = e;
            }
            catch (RuntimeException e) {
                _log.error(e.toString(), (Throwable)e);
                int returnCode = 5;
                excep = e;
            }
            finally {
                this._handle.close();
                HsmStorageHandler2.this.removeFetchEntry(pnfsId);
                this.executeCallbacks(excep);
                if (excep != null) {
                    if (excep instanceof CacheException) {
                        this._infoMsg.setResult(((CacheException)excep).getRc(), excep.getMessage());
                    } else {
                        this._infoMsg.setResult(44, excep.toString());
                    }
                }
                this._infoMsg.setTransferTime(System.currentTimeMillis() - this._timestamp);
                this.sendBillingInfo();
            }
        }

        private void doChecksum(ReplicaDescriptor handle) throws CacheException, InterruptedException {
            try {
                if (HsmStorageHandler2.this._checksumModule.hasPolicy(ChecksumModule.PolicyFlag.GET_CRC_FROM_HSM)) {
                    this.readChecksumFromHsm(handle);
                }
                HsmStorageHandler2.this._checksumModule.enforcePostRestorePolicy(handle);
            }
            catch (IOException e) {
                throw new DiskErrorCacheException("Checksum calculation failed due to I/O error: " + e.getMessage(), e);
            }
            catch (CacheException | NoSuchAlgorithmException e) {
                throw new CacheException(1010, "Checksum calculation failed: " + e.getMessage(), e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void readChecksumFromHsm(ReplicaDescriptor handle) throws IOException, CacheException {
            block6: {
                File file = new File(handle.getFile().getCanonicalPath() + ".crcval");
                try {
                    if (!file.exists()) break block6;
                    try {
                        String firstLine = Files.readFirstLine((File)file, (Charset)Charsets.US_ASCII);
                        if (firstLine != null) {
                            Checksum checksum = Checksum.parseChecksum((String)("1:" + firstLine));
                            _log.info("Obtained checksum {} for {} from HSM", (Object)checksum, (Object)this.getPnfsId());
                            handle.addChecksums(Collections.singleton(checksum));
                        }
                    }
                    finally {
                        file.delete();
                    }
                }
                catch (FileNotFoundException e) {
                    Throwables.propagate((Throwable)e);
                }
            }
        }
    }

    public class Info {
        private final List<CacheFileAvailable> _callbacks = new ArrayList<CacheFileAvailable>();
        private final PnfsId _pnfsId;
        private long _startTime = System.currentTimeMillis();
        private Thread _thread;
        private boolean _active;

        private Info(PnfsId pnfsId) {
            this._pnfsId = pnfsId;
        }

        public PnfsId getPnfsId() {
            return this._pnfsId;
        }

        public int getListenerCount() {
            return this._callbacks.size();
        }

        public long getStartTime() {
            return this._startTime;
        }

        public Thread getThread() {
            return this._thread;
        }

        public void startThread() {
            this._thread.start();
        }

        public void done() {
            this._active = false;
        }

        synchronized void addCallback(CacheFileAvailable callback) {
            this._callbacks.add(callback);
        }

        synchronized void executeCallbacks(Throwable exc) {
            _log.debug("excecuting callbacks  " + this._pnfsId + " (callback=" + this._callbacks + ") " + exc);
            for (CacheFileAvailable callback : this._callbacks) {
                try {
                    callback.cacheFileAvailable(this._pnfsId, exc);
                }
                catch (Exception e) {
                    _log.error("Exception in callback to " + callback.getClass().getName(), (Throwable)e);
                }
            }
        }

        void setThread(Thread thread) {
            this._thread = thread;
        }
    }
}

