/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.pool.classic;

import diskCacheV111.util.ExternalTask;
import diskCacheV111.util.HsmSet;
import diskCacheV111.vehicles.PoolRemoveFilesFromHSMMessage;
import dmg.cells.nucleus.CellEndpoint;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.NoRouteToCellException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.FutureTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HsmRemoveTask
implements Runnable {
    private static final Logger _log = LoggerFactory.getLogger(HsmRemoveTask.class);
    private final CellEndpoint _endpoint;
    private final HsmSet _hsmSet;
    private final CellMessage _message;
    private final Executor _executor;
    private final long _timeout;

    public HsmRemoveTask(CellEndpoint endpoint, Executor executor, HsmSet hsmSet, long timeout, CellMessage message) {
        assert (message.getMessageObject() instanceof PoolRemoveFilesFromHSMMessage);
        this._endpoint = endpoint;
        this._executor = executor;
        this._hsmSet = hsmSet;
        this._timeout = timeout;
        this._message = message;
    }

    private String getCommand(URI uri) {
        String instance = uri.getAuthority();
        HsmSet.HsmInfo hsm = this._hsmSet.getHsmInfoByName(instance);
        if (hsm == null) {
            throw new IllegalArgumentException("HSM instance " + instance + " not defined");
        }
        String command = hsm.getAttribute("command");
        if (command == null) {
            throw new IllegalArgumentException("command not specified for HSM instance " + instance);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(command).append(" remove");
        sb.append(" -uri=").append(uri);
        for (Map.Entry<String, String> attr : hsm.attributes()) {
            String key = attr.getKey();
            String val = attr.getValue();
            sb.append(" -").append(key);
            if (val == null || val.length() <= 0) continue;
            sb.append("=").append(val);
        }
        return sb.toString();
    }

    @Override
    public void run() {
        try {
            PoolRemoveFilesFromHSMMessage msg = (PoolRemoveFilesFromHSMMessage)this._message.getMessageObject();
            Collection<URI> files = msg.getFiles();
            ArrayList<FutureTask<Integer>> tasks = new ArrayList<FutureTask<Integer>>(files.size());
            for (URI uri : files) {
                String command = this.getCommand(uri);
                ExternalTask task = new ExternalTask(this._timeout, command);
                FutureTask<Integer> future = new FutureTask<Integer>(task);
                tasks.add(future);
                this._executor.execute(future);
            }
            ArrayList<URI> succeeded = new ArrayList<URI>(files.size());
            ArrayList<URI> failed = new ArrayList<URI>();
            Iterator i = tasks.iterator();
            for (URI uri : files) {
                int rc = (Integer)((FutureTask)i.next()).get();
                if (rc == 0) {
                    succeeded.add(uri);
                    continue;
                }
                _log.error(String.format("Failed to delete %s: HSM script terminated with non-zero return code %d.", uri, rc));
                failed.add(uri);
            }
            msg.setResult(succeeded, failed);
            this._message.revertDirection();
            this._endpoint.sendMessage(this._message);
        }
        catch (NoRouteToCellException e) {
            _log.warn("Cannot send reply: " + (Object)((Object)e));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (CancellationException e) {
            throw new RuntimeException("Bug: ExternalTask was unexpectedly cancelled", e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Likely bug: ExternalTask threw an unexpected exception", e);
        }
    }
}

