/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.pool.classic;

import java.util.ArrayList;
import java.util.List;
import org.dcache.pool.repository.Account;
import org.dcache.pool.repository.Allocator;

public class FairQueueAllocation
implements Allocator {
    private Account _account;
    private final List<Thread> _list = new ArrayList<Thread>();

    public synchronized void setAccount(Account account) {
        this._account = account;
    }

    private synchronized void enqueue(Thread thread) {
        this._list.add(thread);
    }

    private synchronized void dequeue(Thread thread) {
        this._list.remove(thread);
        this.notifyAll();
    }

    private synchronized void waitForTurn(Thread thread) throws InterruptedException {
        while (this._list.get(0) != thread) {
            this.wait();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void allocate(long space) throws InterruptedException {
        if (space < 0L) {
            throw new IllegalArgumentException("Cannot allocate negative space");
        }
        Thread self = Thread.currentThread();
        this.enqueue(self);
        try {
            this.waitForTurn(self);
            this._account.allocate(space);
        }
        finally {
            this.dequeue(self);
        }
    }

    @Override
    public void free(long space) {
        this._account.free(space);
    }
}

