/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.pool.classic;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import diskCacheV111.util.CacheException;
import diskCacheV111.util.DiskErrorCacheException;
import diskCacheV111.vehicles.DoorTransferFinishedMessage;
import diskCacheV111.vehicles.MoverInfoMessage;
import diskCacheV111.vehicles.ProtocolInfo;
import dmg.cells.nucleus.NoRouteToCellException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.Serializable;
import java.nio.channels.CompletionHandler;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.dcache.cells.AbstractCellComponent;
import org.dcache.cells.CellStub;
import org.dcache.pool.FaultAction;
import org.dcache.pool.FaultEvent;
import org.dcache.pool.FaultListener;
import org.dcache.pool.classic.ChecksumModule;
import org.dcache.pool.classic.PostTransferService;
import org.dcache.pool.movers.IoMode;
import org.dcache.pool.movers.Mover;
import org.dcache.pool.repository.ReplicaDescriptor;
import org.dcache.util.CDCExecutorServiceDecorator;
import org.dcache.util.FireAndForgetTask;
import org.dcache.vehicles.FileAttributes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;

public class DefaultPostTransferService
extends AbstractCellComponent
implements PostTransferService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultPostTransferService.class);
    private final ExecutorService _executor = new CDCExecutorServiceDecorator(Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("post-transfer-%d").build()));
    private CellStub _billing;
    private String _poolName;
    private FaultListener _faultListener;
    private ChecksumModule _checksumModule;
    private CellStub _door;

    @Required
    public void setBillingStub(CellStub billing) {
        this._billing = billing;
    }

    @Required
    public void setPoolName(String poolName) {
        this._poolName = poolName;
    }

    @Required
    public void setFaultListener(FaultListener faultListener) {
        this._faultListener = faultListener;
    }

    @Required
    public void setChecksumModule(ChecksumModule checksumModule) {
        this._checksumModule = checksumModule;
    }

    public void init() {
        this._door = new CellStub(this.getCellEndpoint());
    }

    @Override
    public void execute(final Mover<?> mover, final CompletionHandler<Void, Void> completionHandler) {
        this._executor.execute(new FireAndForgetTask(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                long fileSize = 0L;
                try {
                    try (ReplicaDescriptor handle = mover.getIoHandle();){
                        fileSize = handle.getFile().length();
                        if (mover.getIoMode() == IoMode.WRITE) {
                            handle.addChecksums(mover.getExpectedChecksums());
                            DefaultPostTransferService.this._checksumModule.enforcePostTransferPolicy(handle, mover.getActualChecksums());
                        }
                        handle.commit();
                    }
                    catch (InterruptedIOException | InterruptedException e) {
                        LOGGER.warn("Transfer was forcefully killed during post-processing");
                        mover.setTransferStatus(666, "Transfer was forcefully killed");
                    }
                    catch (DiskErrorCacheException e) {
                        LOGGER.warn("Transfer failed in post-processing due to disk error: {}", (Object)e.toString());
                        DefaultPostTransferService.this._faultListener.faultOccurred(new FaultEvent("repository", FaultAction.DISABLED, e.getMessage(), e));
                        mover.setTransferStatus(e.getRc(), e.getMessage());
                    }
                    catch (CacheException e) {
                        LOGGER.warn("Transfer failed in post-processing: {}", (Object)e.getMessage());
                        mover.setTransferStatus(e.getRc(), e.getMessage());
                    }
                    catch (IOException e) {
                        LOGGER.warn("Transfer failed in post-processing: {}", (Object)e.toString());
                        mover.setTransferStatus(10011, "Transfer failed in post-processing: " + e.getMessage());
                    }
                    catch (RuntimeException e) {
                        LOGGER.error("Transfer failed in post-processing. Please report this bug to support@dcache.org.", (Throwable)e);
                        mover.setTransferStatus(10011, "Transfer failed due to unexpected exception: " + e.getMessage());
                    }
                    catch (Throwable e) {
                        Thread t = Thread.currentThread();
                        t.getUncaughtExceptionHandler().uncaughtException(t, e);
                        mover.setTransferStatus(10011, "Transfer failed due to unexpected exception: " + e.getMessage());
                    }
                    DefaultPostTransferService.this.sendBillingMessage(mover, fileSize);
                    DefaultPostTransferService.this.sendFinished(mover);
                }
                finally {
                    completionHandler.completed(null, null);
                }
            }
        }));
    }

    public void sendBillingMessage(Mover<?> mover, long fileSize) {
        FileAttributes fileAttributes = mover.getFileAttributes();
        MoverInfoMessage info = new MoverInfoMessage(this.getCellName(), fileAttributes.getPnfsId());
        info.setSubject(mover.getSubject());
        info.setInitiator(mover.getInitiator());
        info.setFileCreated(mover.getIoMode() == IoMode.WRITE);
        info.setStorageInfo(fileAttributes.getStorageInfo());
        info.setP2P(mover.isPoolToPoolTransfer());
        info.setFileSize(fileSize);
        info.setResult(mover.getErrorCode(), mover.getErrorMessage());
        info.setTransferAttributes(mover.getBytesTransferred(), mover.getTransferTime(), (ProtocolInfo)mover.getProtocolInfo());
        try {
            this._billing.send(info);
        }
        catch (NoRouteToCellException e) {
            LOGGER.error("Failed to register transfer in billing: {}", (Object)e.getMessage());
        }
    }

    public void sendFinished(Mover<?> mover) {
        DoorTransferFinishedMessage finished = new DoorTransferFinishedMessage(mover.getClientId(), mover.getFileAttributes().getPnfsId(), (ProtocolInfo)mover.getProtocolInfo(), mover.getFileAttributes(), this._poolName, mover.getQueueName());
        if (mover.getErrorCode() == 0) {
            finished.setSucceeded();
        } else {
            finished.setReply(mover.getErrorCode(), (Serializable)((Object)mover.getErrorMessage()));
        }
        try {
            this._door.send(mover.getPathToDoor(), finished);
        }
        catch (NoRouteToCellException e) {
            LOGGER.error("Failed to notify door about transfer termination: {}", (Object)e.getMessage());
        }
    }

    public void shutdown() {
        this._executor.shutdown();
    }
}

