/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.pool.classic;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import diskCacheV111.util.CacheException;
import diskCacheV111.util.ChecksumFactory;
import diskCacheV111.util.FileCorruptedCacheException;
import dmg.util.command.Argument;
import dmg.util.command.Command;
import dmg.util.command.Option;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.dcache.cells.AbstractCellComponent;
import org.dcache.cells.CellCommandListener;
import org.dcache.pool.classic.ChecksumModule;
import org.dcache.pool.classic.ChecksumScanner;
import org.dcache.pool.repository.ReplicaDescriptor;
import org.dcache.util.Checksum;
import org.dcache.util.ChecksumType;

public class ChecksumModuleV1
extends AbstractCellComponent
implements CellCommandListener,
ChecksumModule {
    private static final Ordering<ChecksumType> PREFERRED_CHECKSUM_TYPE_ORDERING = Ordering.explicit((Object)ChecksumType.MD5_TYPE, (Object[])new ChecksumType[]{ChecksumType.ADLER32, ChecksumType.MD4_TYPE});
    private static final Ordering<Checksum> PREFERRED_CHECKSUM_ORDERING = PREFERRED_CHECKSUM_TYPE_ORDERING.onResultOf((Function)new Function<Checksum, ChecksumType>(){

        public ChecksumType apply(Checksum checksum) {
            return checksum.getType();
        }
    });
    private static final long BYTES_IN_MEBIBYTE = 0x100000L;
    private final EnumSet<ChecksumModule.PolicyFlag> _policy = EnumSet.of(ChecksumModule.PolicyFlag.ON_TRANSFER, ChecksumModule.PolicyFlag.ENFORCE_CRC);
    private double _throughputLimit = Double.POSITIVE_INFINITY;
    private long _scrubPeriod = TimeUnit.HOURS.toMillis(24L);
    private ChecksumType _defaultChecksumType = ChecksumType.ADLER32;
    private ChecksumScanner _scanner;

    public void setChecksumScanner(ChecksumScanner scanner) {
        this._scanner = scanner;
    }

    public synchronized ChecksumType getDefaultChecksumType() {
        return this._defaultChecksumType;
    }

    public synchronized long getScrubPeriod() {
        return this._scrubPeriod;
    }

    public synchronized double getThroughputLimit() {
        return this._throughputLimit;
    }

    @Override
    public synchronized void printSetup(PrintWriter pw) {
        pw.println("csm set checksumtype " + this._defaultChecksumType);
        if (this.hasPolicy(ChecksumModule.PolicyFlag.SCRUB)) {
            pw.print("csm set policy -scrub=on");
            pw.print(" -limit=" + (Double.isInfinite(this._throughputLimit) ? "off" : Double.valueOf(this._throughputLimit / 1048576.0)));
            pw.println(" -period=" + TimeUnit.MILLISECONDS.toHours(this._scrubPeriod));
        } else {
            pw.println("csm set policy -scrub=off");
        }
        pw.print("csm set policy");
        pw.print(" -onread=");
        pw.print(this.hasPolicy(ChecksumModule.PolicyFlag.ON_READ) ? "on" : "off");
        pw.print(" -onwrite=");
        pw.print(this.hasPolicy(ChecksumModule.PolicyFlag.ON_WRITE) ? "on" : "off");
        pw.print(" -onflush=");
        pw.print(this.hasPolicy(ChecksumModule.PolicyFlag.ON_FLUSH) ? "on" : "off");
        pw.print(" -onrestore=");
        pw.print(this.hasPolicy(ChecksumModule.PolicyFlag.ON_RESTORE) ? "on" : "off");
        pw.print(" -ontransfer=");
        pw.print(this.hasPolicy(ChecksumModule.PolicyFlag.ON_TRANSFER) ? "on" : "off");
        pw.print(" -enforcecrc=");
        pw.print(this.hasPolicy(ChecksumModule.PolicyFlag.ENFORCE_CRC) ? "on" : "off");
        pw.print(" -getcrcfromhsm=");
        pw.print(this.hasPolicy(ChecksumModule.PolicyFlag.GET_CRC_FROM_HSM) ? "on" : "off");
        pw.println("");
    }

    @Override
    public synchronized void getInfo(PrintWriter pw) {
        pw.println("          Checksum type : " + this._defaultChecksumType);
        pw.print(" Checkum calculation on : ");
        for (ChecksumModule.PolicyFlag flag : this._policy) {
            switch (flag) {
                case ON_READ: {
                    pw.print("read ");
                    break;
                }
                case ON_WRITE: {
                    pw.print("write ");
                    break;
                }
                case ON_FLUSH: {
                    pw.print("flush ");
                    break;
                }
                case ON_RESTORE: {
                    pw.print("restore ");
                    break;
                }
                case ON_TRANSFER: {
                    pw.print("transfer ");
                    break;
                }
                case ENFORCE_CRC: {
                    pw.print("enforceCRC ");
                    break;
                }
                case GET_CRC_FROM_HSM: {
                    pw.print("getcrcfromhsm ");
                    break;
                }
                case SCRUB: {
                    pw.print("scrub(");
                    pw.print("limit=" + (Double.isInfinite(this._throughputLimit) ? "off" : Double.valueOf(this._throughputLimit / 1048576.0)));
                    pw.print(",");
                    pw.print("period=" + TimeUnit.MILLISECONDS.toHours(this._scrubPeriod));
                    pw.print(") ");
                }
            }
        }
        pw.println("");
    }

    private synchronized String getPolicies() {
        StringBuilder sb = new StringBuilder();
        sb.append(" Policies :\n").append("        on read : ").append(this.hasPolicy(ChecksumModule.PolicyFlag.ON_READ)).append("\n").append("       on write : ").append(this.hasPolicy(ChecksumModule.PolicyFlag.ON_WRITE)).append("\n").append("       on flush : ").append(this.hasPolicy(ChecksumModule.PolicyFlag.ON_FLUSH)).append("\n").append("     on restore : ").append(this.hasPolicy(ChecksumModule.PolicyFlag.ON_RESTORE)).append("\n").append("    on transfer : ").append(this.hasPolicy(ChecksumModule.PolicyFlag.ON_TRANSFER)).append("\n").append("    enforce crc : ").append(this.hasPolicy(ChecksumModule.PolicyFlag.ENFORCE_CRC)).append("\n").append("  getcrcfromhsm : ").append(this.hasPolicy(ChecksumModule.PolicyFlag.GET_CRC_FROM_HSM)).append("\n").append("          scrub : ").append(this.hasPolicy(ChecksumModule.PolicyFlag.SCRUB)).append("\n");
        if (this.hasPolicy(ChecksumModule.PolicyFlag.SCRUB)) {
            if (Double.isInfinite(this._throughputLimit)) {
                sb.append("             limit  = off\n");
            } else {
                sb.append("             limit  = ").append(this._throughputLimit / 1048576.0).append(" MiB/s\n");
            }
            sb.append("             period = ").append(TimeUnit.MILLISECONDS.toHours(this._scrubPeriod)).append(" hours\n");
        }
        return sb.toString();
    }

    @Override
    public synchronized boolean hasPolicy(ChecksumModule.PolicyFlag flag) {
        return this._policy.contains((Object)flag);
    }

    @Override
    public ChecksumFactory getPreferredChecksumFactory(ReplicaDescriptor handle) throws NoSuchAlgorithmException, CacheException {
        List existingChecksumsByPreference = PREFERRED_CHECKSUM_ORDERING.sortedCopy(handle.getChecksums());
        return ChecksumFactory.getFactory(existingChecksumsByPreference, this.getDefaultChecksumType());
    }

    @Override
    public void enforcePostTransferPolicy(ReplicaDescriptor handle, Iterable<Checksum> actualChecksums) throws CacheException, NoSuchAlgorithmException, IOException, InterruptedException {
        if (this.hasPolicy(ChecksumModule.PolicyFlag.ON_WRITE) || this.hasPolicy(ChecksumModule.PolicyFlag.ON_TRANSFER) || this.hasPolicy(ChecksumModule.PolicyFlag.ENFORCE_CRC) || !Iterables.isEmpty(actualChecksums)) {
            Iterable<Checksum> expectedChecksums = handle.getChecksums();
            if (this.hasPolicy(ChecksumModule.PolicyFlag.ON_WRITE) || this.hasPolicy(ChecksumModule.PolicyFlag.ON_TRANSFER) && Iterables.isEmpty(actualChecksums) || this.hasPolicy(ChecksumModule.PolicyFlag.ENFORCE_CRC) && Iterables.isEmpty(expectedChecksums) && Iterables.isEmpty(actualChecksums)) {
                ChecksumFactory factory = ChecksumFactory.getFactory(Iterables.concat(expectedChecksums, actualChecksums), this.getDefaultChecksumType());
                actualChecksums = Iterables.concat(actualChecksums, Collections.singleton(factory.computeChecksum(handle.getFile())));
            }
            this.compareChecksums(expectedChecksums, actualChecksums);
            handle.addChecksums(actualChecksums);
        }
    }

    @Override
    public void enforcePreFlushPolicy(ReplicaDescriptor handle) throws CacheException, InterruptedException, NoSuchAlgorithmException, IOException {
        if (this.hasPolicy(ChecksumModule.PolicyFlag.ON_FLUSH)) {
            this.verifyChecksum(handle);
        }
    }

    @Override
    public void enforcePostRestorePolicy(ReplicaDescriptor handle) throws CacheException, NoSuchAlgorithmException, IOException, InterruptedException {
        if (this.hasPolicy(ChecksumModule.PolicyFlag.ON_RESTORE)) {
            handle.addChecksums(this.verifyChecksum(handle));
        }
    }

    @Override
    public Iterable<Checksum> verifyChecksum(ReplicaDescriptor handle) throws NoSuchAlgorithmException, IOException, InterruptedException, CacheException {
        return this.verifyChecksum(handle.getFile(), handle.getChecksums());
    }

    @Override
    public Iterable<Checksum> verifyChecksum(File file, Iterable<Checksum> expectedChecksums) throws NoSuchAlgorithmException, IOException, InterruptedException, CacheException {
        return this.verifyChecksum(file, expectedChecksums, Double.POSITIVE_INFINITY);
    }

    public Iterable<Checksum> verifyChecksumWithThroughputLimit(ReplicaDescriptor handle) throws IOException, InterruptedException, NoSuchAlgorithmException, CacheException {
        return this.verifyChecksum(handle.getFile(), handle.getChecksums(), this.getThroughputLimit());
    }

    private Iterable<Checksum> verifyChecksum(File file, Iterable<Checksum> expectedChecksums, double throughputLimit) throws NoSuchAlgorithmException, IOException, InterruptedException, CacheException {
        ChecksumFactory factory = ChecksumFactory.getFactory(expectedChecksums, this.getDefaultChecksumType());
        Set<Checksum> actualChecksums = Collections.singleton(factory.computeChecksum(file, throughputLimit));
        this.compareChecksums(expectedChecksums, actualChecksums);
        return actualChecksums;
    }

    private void compareChecksums(Iterable<Checksum> expected, Iterable<Checksum> actual) throws CacheException {
        HashMap checksumByType = Maps.newHashMap();
        for (Checksum checksum : Iterables.concat(expected, actual)) {
            Checksum otherChecksum = (Checksum)checksumByType.get(checksum.getType());
            if (otherChecksum != null && !otherChecksum.equals((Object)checksum)) {
                throw new FileCorruptedCacheException((Set<Checksum>)ImmutableSet.copyOf(expected), (Set<Checksum>)ImmutableSet.copyOf(actual));
            }
            checksumByType.put(checksum.getType(), checksum);
        }
    }

    @Command(name="csm set checksumtype", usage="Sets the default checksum type to compute and store for new files.\n\nUnless the client has specified a checksum of a different type, the default checksum defines the checksum that is computed for each new file and stored in the name space.")
    public class SetChecksumTypeCommand
    implements Callable<String> {
        @Argument(valueSpec="adler32|md5")
        String type;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String call() throws IllegalArgumentException {
            ChecksumModuleV1 checksumModuleV1 = ChecksumModuleV1.this;
            synchronized (checksumModuleV1) {
                ChecksumModuleV1.this._defaultChecksumType = ChecksumType.getChecksumType((String)this.type);
                return "New checksumtype : " + ChecksumModuleV1.this._defaultChecksumType;
            }
        }
    }

    @Command(name="csm set policy", usage="Define the checksum policy of the pool.")
    public class SetPolicyCommand
    implements Callable<String> {
        @Option(name="scrub", category="Scrubber options", usage="Periodically verify pool data against checksums.", values={"", "on", "off"}, valueSpec="on|off")
        String scrub;
        @Option(name="limit", category="Scrubber options", usage="Checksum computation throughput limit.", valueSpec="<MiB/s>|off")
        String limit;
        @Option(name="period", category="Scrubber options", usage="Run scrubber every HOURS hours.", metaVar="hours")
        Integer period;
        @Option(name="onread", category="Transfer options", usage="Not implemented.", values={"", "on", "off"}, valueSpec="on|off")
        String onRead;
        @Option(name="onwrite", category="Transfer options", usage="Compute checksum after receiving the file form the client. In contrast to -ontransfer, -onwrite will read back the file from disk or the disk cache after the transfer has completed. Be aware that this will introduce a delay after the transfer and that some clients may time out in the meantime.", values={"", "on", "off"}, valueSpec="on|off")
        String onWrite;
        @Option(name="ontransfer", category="Transfer options", usage="Compute checksum while receiving data from the client. If not supported by the transfer protocol, the checksum is computed after the upload has completed.", values={"", "on", "off"}, valueSpec="on|off")
        String onTransfer;
        @Option(name="enforcecrc", category="Transfer options", usage="If no checksum was calculated during the transfer and no checksum was provided by the client, then a checksum will be computed from the uploaded file.", values={"", "on", "off"}, valueSpec="on|off")
        String enforceCrc;
        @Option(name="onflush", category="HSM options", usage="Compute checksum before flush to HSM.", values={"", "on", "off"}, valueSpec="on|off")
        String onFlush;
        @Option(name="onrestore", category="HSM options", usage="Compute checksum after restore from HSM.", values={"", "on", "off"}, valueSpec="on|off")
        String onRestore;
        @Option(name="getcrcfromhsm", category="HSM options", usage="If enabled, the pool will collect any checksum provided by the HSM and store it in the name space.", values={"", "on", "off"}, valueSpec="on|off")
        String getCrcFromHsm;
        @Option(name="v", usage="Verbose.")
        boolean verbose;
        @Option(name="frequently", metaVar="IGNORED_VALUE", usage="This option is accepted but ignored.  It exists only for backwards compatibility with older dCache pool 'setup' files")
        String ignoredValue;

        private void updatePolicy(String value, ChecksumModule.PolicyFlag flag) {
            if (value != null) {
                switch (value) {
                    case "on": 
                    case "": {
                        ChecksumModuleV1.this._policy.add(flag);
                        break;
                    }
                    case "off": {
                        ChecksumModuleV1.this._policy.remove((Object)flag);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid value: " + value);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String call() throws IllegalArgumentException {
            ChecksumModuleV1 checksumModuleV1 = ChecksumModuleV1.this;
            synchronized (checksumModuleV1) {
                this.updatePolicy(this.onRead, ChecksumModule.PolicyFlag.ON_READ);
                this.updatePolicy(this.onWrite, ChecksumModule.PolicyFlag.ON_WRITE);
                this.updatePolicy(this.onFlush, ChecksumModule.PolicyFlag.ON_FLUSH);
                this.updatePolicy(this.onRestore, ChecksumModule.PolicyFlag.ON_RESTORE);
                this.updatePolicy(this.onTransfer, ChecksumModule.PolicyFlag.ON_TRANSFER);
                this.updatePolicy(this.enforceCrc, ChecksumModule.PolicyFlag.ENFORCE_CRC);
                this.updatePolicy(this.getCrcFromHsm, ChecksumModule.PolicyFlag.GET_CRC_FROM_HSM);
                this.updatePolicy(this.scrub, ChecksumModule.PolicyFlag.SCRUB);
                if (this.limit != null) {
                    if (this.limit.equals("off")) {
                        ChecksumModuleV1.this._throughputLimit = Double.POSITIVE_INFINITY;
                    } else {
                        double value = Double.parseDouble(this.limit) * 1048576.0;
                        if (value <= 0.0) {
                            throw new IllegalArgumentException("Throughput limit must be > 0");
                        }
                        ChecksumModuleV1.this._throughputLimit = value;
                    }
                }
                if (this.period != null) {
                    long value = TimeUnit.HOURS.toMillis(this.period.intValue());
                    if (value <= 0L) {
                        throw new IllegalArgumentException("Scrub interval must be > 0");
                    }
                    ChecksumModuleV1.this._scrubPeriod = value;
                }
                if (ChecksumModuleV1.this.hasPolicy(ChecksumModule.PolicyFlag.SCRUB)) {
                    ChecksumModuleV1.this._scanner.startScrubber();
                } else {
                    ChecksumModuleV1.this._scanner.stopScrubber();
                }
                return this.verbose ? ChecksumModuleV1.this.getPolicies() : "";
            }
        }
    }

    @Command(name="csm info", usage="Shows current checksum module configuration.")
    public class InfoCommand
    implements Callable<String> {
        @Override
        public String call() throws Exception {
            return ChecksumModuleV1.this.getPolicies();
        }
    }
}

