/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.pool.classic;

import diskCacheV111.util.AccessLatency;
import diskCacheV111.util.RetentionPolicy;
import diskCacheV111.vehicles.StorageInfo;
import java.util.Collections;
import java.util.List;
import org.dcache.pool.classic.ReplicaStatePolicy;
import org.dcache.pool.repository.EntryState;
import org.dcache.pool.repository.StickyRecord;
import org.dcache.vehicles.FileAttributes;

public class ALRPReplicaStatePolicy
implements ReplicaStatePolicy {
    @Override
    public List<StickyRecord> getStickyRecords(FileAttributes fileAttributes) {
        if (fileAttributes.getAccessLatency().equals((Object)AccessLatency.ONLINE)) {
            return Collections.singletonList(new StickyRecord("system", -1L));
        }
        return Collections.emptyList();
    }

    @Override
    public EntryState getTargetState(FileAttributes fileAttributes) {
        StorageInfo info = fileAttributes.getStorageInfo();
        if (info.getKey("overwrite") != null) {
            return EntryState.CACHED;
        }
        if (!info.isStored() && fileAttributes.getRetentionPolicy().equals((Object)RetentionPolicy.CUSTODIAL)) {
            return EntryState.PRECIOUS;
        }
        return EntryState.CACHED;
    }
}

