/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.pinmanager.model;

import diskCacheV111.util.PnfsId;
import java.util.BitSet;
import java.util.Date;
import javax.jdo.JDODetachedFieldAccessException;
import javax.jdo.JDOFatalInternalException;
import javax.jdo.PersistenceManager;
import javax.jdo.annotations.Persistent;
import javax.jdo.annotations.PrimaryKey;
import javax.jdo.identity.LongIdentity;
import javax.jdo.spi.Detachable;
import javax.jdo.spi.JDOImplHelper;
import javax.jdo.spi.PersistenceCapable;
import javax.jdo.spi.StateManager;
import javax.security.auth.Subject;
import org.dcache.auth.Subjects;

@javax.jdo.annotations.PersistenceCapable
public class Pin
implements Detachable,
PersistenceCapable {
    @PrimaryKey
    protected long _id;
    @Persistent
    protected long _uid;
    @Persistent
    protected long _gid;
    @Persistent
    protected String _requestId;
    @Persistent
    protected Date _creationTime;
    @Persistent
    protected Date _expirationTime;
    @Persistent
    protected String _pnfsId;
    @Persistent
    protected String _pool;
    @Persistent
    protected String _sticky;
    @Persistent
    protected State _state;
    protected transient StateManager jdoStateManager;
    protected transient byte jdoFlags;
    protected Object[] jdoDetachedState;
    private static final byte[] jdoFieldFlags;
    private static final Class jdoPersistenceCapableSuperclass;
    private static final Class[] jdoFieldTypes;
    private static final String[] jdoFieldNames;
    private static final int jdoInheritedFieldCount;

    protected Pin() {
    }

    public Pin(Subject subject, PnfsId pnfsId) {
        this._uid = Subjects.getUid((Subject)subject);
        this._gid = Subjects.getPrimaryGid((Subject)subject);
        this._creationTime = new Date();
        this._pnfsId = pnfsId.toString();
        this._state = State.PINNING;
    }

    public long getPinId() {
        return Pin.jdoGet_id(this);
    }

    public long getUid() {
        return Pin.jdoGet_uid(this);
    }

    public long getGid() {
        return Pin.jdoGet_gid(this);
    }

    public void setRequestId(String requestId) {
        Pin.jdoSet_requestId(this, requestId);
    }

    public String getRequestId() {
        return Pin.jdoGet_requestId(this);
    }

    public Date getCreationTime() {
        return Pin.jdoGet_creationTime(this);
    }

    public Date getExpirationTime() {
        return Pin.jdoGet_expirationTime(this);
    }

    public void setExpirationTime(Date date) {
        Pin.jdoSet_expirationTime(this, date);
    }

    public PnfsId getPnfsId() {
        return new PnfsId(Pin.jdoGet_pnfsId(this));
    }

    public String getPool() {
        return Pin.jdoGet_pool(this);
    }

    public void setPool(String pool) {
        Pin.jdoSet_pool(this, pool);
    }

    public String getSticky() {
        return Pin.jdoGet_sticky(this);
    }

    public void setSticky(String sticky) {
        Pin.jdoSet_sticky(this, sticky);
    }

    public State getState() {
        return Pin.jdoGet_state(this);
    }

    public void setState(State state) {
        Pin.jdoSet_state(this, state);
    }

    public boolean hasRemainingLifetimeLessThan(long lifetime) {
        long now = System.currentTimeMillis();
        return Pin.jdoGet_expirationTime(this) != null && (lifetime == -1L || Pin.jdoGet_expirationTime(this).before(new Date(now + lifetime)));
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(String.format("[%d] %s", Pin.jdoGet_id(this), Pin.jdoGet_pnfsId(this)));
        if (Pin.jdoGet_requestId(this) != null) {
            s.append(" (").append(Pin.jdoGet_requestId(this)).append(')');
        }
        s.append(" by ").append(Pin.jdoGet_uid(this)).append(':').append(Pin.jdoGet_gid(this));
        s.append(String.format(" %tF %<tT", Pin.jdoGet_creationTime(this)));
        if (Pin.jdoGet_expirationTime(this) != null) {
            s.append(String.format(" to %tF %<tT", Pin.jdoGet_expirationTime(this)));
        }
        s.append(" is ").append((Object)Pin.jdoGet_state(this));
        if (Pin.jdoGet_pool(this) != null) {
            s.append(" on ").append(Pin.jdoGet_pool(this)).append(':').append(Pin.jdoGet_sticky(this));
        }
        return s.toString();
    }

    static {
        jdoFieldNames = Pin.__jdoFieldNamesInit();
        jdoFieldTypes = Pin.__jdoFieldTypesInit();
        jdoFieldFlags = Pin.__jdoFieldFlagsInit();
        jdoInheritedFieldCount = Pin.__jdoGetInheritedFieldCount();
        jdoPersistenceCapableSuperclass = Pin.__jdoPersistenceCapableSuperclassInit();
        JDOImplHelper.registerClass((Class)Pin.___jdo$loadClass("org.dcache.pinmanager.model.Pin"), (String[])jdoFieldNames, (Class[])jdoFieldTypes, (byte[])jdoFieldFlags, (Class)jdoPersistenceCapableSuperclass, (PersistenceCapable)new Pin());
    }

    public void jdoCopyKeyFieldsFromObjectId(PersistenceCapable.ObjectIdFieldConsumer fc, Object oid) {
        if (fc == null) {
            throw new IllegalArgumentException("ObjectIdFieldConsumer is null");
        }
        if (!(oid instanceof LongIdentity)) {
            throw new ClassCastException("oid is not instanceof javax.jdo.identity.LongIdentity");
        }
        LongIdentity o = (LongIdentity)oid;
        fc.storeLongField(3, o.getKey());
    }

    protected void jdoCopyKeyFieldsFromObjectId(Object oid) {
        if (!(oid instanceof LongIdentity)) {
            throw new ClassCastException("key class is not javax.jdo.identity.LongIdentity or null");
        }
        LongIdentity o = (LongIdentity)oid;
        this._id = o.getKey();
    }

    public void jdoCopyKeyFieldsToObjectId(Object oid) {
        throw new JDOFatalInternalException("It's illegal to call jdoCopyKeyFieldsToObjectId for a class with SingleFieldIdentity.");
    }

    public void jdoCopyKeyFieldsToObjectId(PersistenceCapable.ObjectIdFieldSupplier fs, Object paramObject) {
        throw new JDOFatalInternalException("It's illegal to call jdoCopyKeyFieldsToObjectId for a class with SingleFieldIdentity.");
    }

    public final Object jdoGetObjectId() {
        if (this.jdoStateManager != null) {
            return this.jdoStateManager.getObjectId((PersistenceCapable)this);
        }
        if (!this.jdoIsDetached()) {
            return null;
        }
        return this.jdoDetachedState[0];
    }

    public final Object jdoGetVersion() {
        if (this.jdoStateManager != null) {
            return this.jdoStateManager.getVersion((PersistenceCapable)this);
        }
        if (!this.jdoIsDetached()) {
            return null;
        }
        return this.jdoDetachedState[1];
    }

    protected final void jdoPreSerialize() {
        if (this.jdoStateManager != null) {
            this.jdoStateManager.preSerialize((PersistenceCapable)this);
        }
    }

    public final PersistenceManager jdoGetPersistenceManager() {
        return this.jdoStateManager != null ? this.jdoStateManager.getPersistenceManager((PersistenceCapable)this) : null;
    }

    public final Object jdoGetTransactionalObjectId() {
        return this.jdoStateManager != null ? this.jdoStateManager.getTransactionalObjectId((PersistenceCapable)this) : null;
    }

    public final boolean jdoIsDeleted() {
        return this.jdoStateManager != null ? this.jdoStateManager.isDeleted((PersistenceCapable)this) : false;
    }

    public final boolean jdoIsDirty() {
        if (this.jdoStateManager != null) {
            return this.jdoStateManager.isDirty((PersistenceCapable)this);
        }
        if (!this.jdoIsDetached()) {
            return false;
        }
        return ((BitSet)this.jdoDetachedState[3]).length() > 0;
    }

    public final boolean jdoIsNew() {
        return this.jdoStateManager != null ? this.jdoStateManager.isNew((PersistenceCapable)this) : false;
    }

    public final boolean jdoIsPersistent() {
        return this.jdoStateManager != null ? this.jdoStateManager.isPersistent((PersistenceCapable)this) : false;
    }

    public final boolean jdoIsTransactional() {
        return this.jdoStateManager != null ? this.jdoStateManager.isTransactional((PersistenceCapable)this) : false;
    }

    public void jdoMakeDirty(String fieldName) {
        if (this.jdoStateManager != null) {
            this.jdoStateManager.makeDirty((PersistenceCapable)this, fieldName);
        }
        if (this.jdoIsDetached() && fieldName != null) {
            String fldName = null;
            fldName = fieldName.indexOf(46) >= 0 ? fieldName.substring(fieldName.lastIndexOf(46) + 1) : fieldName;
            int i = 0;
            while (i < jdoFieldNames.length) {
                if (jdoFieldNames[i].equals(fldName)) {
                    if (((BitSet)this.jdoDetachedState[2]).get(i + jdoInheritedFieldCount)) {
                        ((BitSet)this.jdoDetachedState[3]).set(i + jdoInheritedFieldCount);
                        return;
                    }
                    throw new JDODetachedFieldAccessException("You have just attempted to access a field/property that hasn't been detached. Please detach it first before performing this operation");
                }
                ++i;
            }
        }
    }

    public Object jdoNewObjectIdInstance() {
        return new LongIdentity(this.getClass(), this._id);
    }

    public Object jdoNewObjectIdInstance(Object key) {
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        if (!(key instanceof String)) {
            return new LongIdentity(this.getClass(), (Long)key);
        }
        return new LongIdentity(this.getClass(), (String)key);
    }

    public final void jdoProvideFields(int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("argment is null");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.jdoProvideField(indices[i]);
            } while (--i >= 0);
        }
    }

    public final void jdoReplaceFields(int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("argument is null");
        }
        int i = indices.length;
        if (i > 0) {
            int j = 0;
            do {
                this.jdoReplaceField(indices[j]);
            } while (++j < i);
        }
    }

    public final void jdoReplaceFlags() {
        if (this.jdoStateManager != null) {
            this.jdoFlags = this.jdoStateManager.replacingFlags((PersistenceCapable)this);
        }
    }

    public final synchronized void jdoReplaceStateManager(StateManager sm) {
        if (this.jdoStateManager != null) {
            this.jdoStateManager = this.jdoStateManager.replacingStateManager((PersistenceCapable)this, sm);
        } else {
            JDOImplHelper.checkAuthorizedStateManager((StateManager)sm);
            this.jdoStateManager = sm;
            this.jdoFlags = 1;
        }
    }

    public final synchronized void jdoReplaceDetachedState() {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        this.jdoDetachedState = this.jdoStateManager.replacingDetachedState((Detachable)this, this.jdoDetachedState);
    }

    public boolean jdoIsDetached() {
        return this.jdoStateManager == null && this.jdoDetachedState != null;
    }

    public PersistenceCapable jdoNewInstance(StateManager sm) {
        Pin result = new Pin();
        result.jdoFlags = 1;
        result.jdoStateManager = sm;
        return result;
    }

    public PersistenceCapable jdoNewInstance(StateManager sm, Object obj) {
        Pin result = new Pin();
        result.jdoFlags = 1;
        result.jdoStateManager = sm;
        result.jdoCopyKeyFieldsFromObjectId(obj);
        return result;
    }

    public void jdoReplaceField(int index) {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index) {
            case 0: {
                this._creationTime = (Date)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 1: {
                this._expirationTime = (Date)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 2: {
                this._gid = this.jdoStateManager.replacingLongField((PersistenceCapable)this, index);
                break;
            }
            case 3: {
                this._id = this.jdoStateManager.replacingLongField((PersistenceCapable)this, index);
                break;
            }
            case 4: {
                this._pnfsId = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 5: {
                this._pool = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 6: {
                this._requestId = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 7: {
                this._state = (State)((Object)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index));
                break;
            }
            case 8: {
                this._sticky = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 9: {
                this._uid = this.jdoStateManager.replacingLongField((PersistenceCapable)this, index);
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    public void jdoProvideField(int index) {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index) {
            case 0: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this._creationTime);
                break;
            }
            case 1: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this._expirationTime);
                break;
            }
            case 2: {
                this.jdoStateManager.providedLongField((PersistenceCapable)this, index, this._gid);
                break;
            }
            case 3: {
                this.jdoStateManager.providedLongField((PersistenceCapable)this, index, this._id);
                break;
            }
            case 4: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this._pnfsId);
                break;
            }
            case 5: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this._pool);
                break;
            }
            case 6: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this._requestId);
                break;
            }
            case 7: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this._state);
                break;
            }
            case 8: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this._sticky);
                break;
            }
            case 9: {
                this.jdoStateManager.providedLongField((PersistenceCapable)this, index, this._uid);
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    protected final void jdoCopyField(Pin obj, int index) {
        switch (index) {
            case 0: {
                this._creationTime = obj._creationTime;
                break;
            }
            case 1: {
                this._expirationTime = obj._expirationTime;
                break;
            }
            case 2: {
                this._gid = obj._gid;
                break;
            }
            case 3: {
                this._id = obj._id;
                break;
            }
            case 4: {
                this._pnfsId = obj._pnfsId;
                break;
            }
            case 5: {
                this._pool = obj._pool;
                break;
            }
            case 6: {
                this._requestId = obj._requestId;
                break;
            }
            case 7: {
                this._state = obj._state;
                break;
            }
            case 8: {
                this._sticky = obj._sticky;
                break;
            }
            case 9: {
                this._uid = obj._uid;
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    public void jdoCopyFields(Object obj, int[] indices) {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        if (indices == null) {
            throw new IllegalStateException("fieldNumbers is null");
        }
        if (!(obj instanceof Pin)) {
            throw new IllegalArgumentException("object is not an object of type org.dcache.pinmanager.model.Pin");
        }
        Pin other = (Pin)obj;
        if (this.jdoStateManager != other.jdoStateManager) {
            throw new IllegalArgumentException("state managers do not match");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.jdoCopyField(other, indices[i]);
            } while (--i >= 0);
        }
    }

    private static final String[] __jdoFieldNamesInit() {
        return new String[]{"_creationTime", "_expirationTime", "_gid", "_id", "_pnfsId", "_pool", "_requestId", "_state", "_sticky", "_uid"};
    }

    private static final Class[] __jdoFieldTypesInit() {
        return new Class[]{Pin.___jdo$loadClass("java.util.Date"), Pin.___jdo$loadClass("java.util.Date"), Long.TYPE, Long.TYPE, Pin.___jdo$loadClass("java.lang.String"), Pin.___jdo$loadClass("java.lang.String"), Pin.___jdo$loadClass("java.lang.String"), Pin.___jdo$loadClass("org.dcache.pinmanager.model.Pin$State"), Pin.___jdo$loadClass("java.lang.String"), Long.TYPE};
    }

    private static final byte[] __jdoFieldFlagsInit() {
        return new byte[]{21, 21, 21, 24, 21, 21, 21, 21, 21, 21};
    }

    protected static int __jdoGetInheritedFieldCount() {
        return 0;
    }

    protected static int jdoGetManagedFieldCount() {
        return 10;
    }

    private static Class __jdoPersistenceCapableSuperclassInit() {
        return null;
    }

    public static Class ___jdo$loadClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    private Object jdoSuperClone() throws CloneNotSupportedException {
        Pin o = (Pin)super.clone();
        o.jdoFlags = 0;
        o.jdoStateManager = null;
        return o;
    }

    protected static Date jdoGet_creationTime(Pin objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 0)) {
            return (Date)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 0, (Object)objPC._creationTime);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(0)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"_creationTime\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC._creationTime;
    }

    protected static void jdoSet_creationTime(Pin objPC, Date val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 0, (Object)objPC._creationTime, (Object)val);
        } else {
            objPC._creationTime = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(0);
            }
        }
    }

    protected static Date jdoGet_expirationTime(Pin objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 1)) {
            return (Date)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 1, (Object)objPC._expirationTime);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(1)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"_expirationTime\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC._expirationTime;
    }

    protected static void jdoSet_expirationTime(Pin objPC, Date val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 1, (Object)objPC._expirationTime, (Object)val);
        } else {
            objPC._expirationTime = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(1);
            }
        }
    }

    protected static long jdoGet_gid(Pin objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 2)) {
            return objPC.jdoStateManager.getLongField((PersistenceCapable)objPC, 2, objPC._gid);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(2)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"_gid\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC._gid;
    }

    protected static void jdoSet_gid(Pin objPC, long val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setLongField((PersistenceCapable)objPC, 2, objPC._gid, val);
        } else {
            objPC._gid = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(2);
            }
        }
    }

    protected static long jdoGet_id(Pin objPC) {
        return objPC._id;
    }

    protected static void jdoSet_id(Pin objPC, long val) {
        if (objPC.jdoStateManager == null) {
            objPC._id = val;
        } else {
            objPC.jdoStateManager.setLongField((PersistenceCapable)objPC, 3, objPC._id, val);
        }
        if (objPC.jdoIsDetached()) {
            ((BitSet)objPC.jdoDetachedState[3]).set(3);
        }
    }

    protected static String jdoGet_pnfsId(Pin objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 4)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 4, objPC._pnfsId);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(4)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"_pnfsId\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC._pnfsId;
    }

    protected static void jdoSet_pnfsId(Pin objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 4, objPC._pnfsId, val);
        } else {
            objPC._pnfsId = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(4);
            }
        }
    }

    protected static String jdoGet_pool(Pin objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 5)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 5, objPC._pool);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(5)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"_pool\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC._pool;
    }

    protected static void jdoSet_pool(Pin objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 5, objPC._pool, val);
        } else {
            objPC._pool = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(5);
            }
        }
    }

    protected static String jdoGet_requestId(Pin objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 6)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 6, objPC._requestId);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(6)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"_requestId\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC._requestId;
    }

    protected static void jdoSet_requestId(Pin objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 6, objPC._requestId, val);
        } else {
            objPC._requestId = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(6);
            }
        }
    }

    protected static State jdoGet_state(Pin objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 7)) {
            return (State)((Object)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 7, (Object)objPC._state));
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(7)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"_state\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC._state;
    }

    protected static void jdoSet_state(Pin objPC, State val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 7, (Object)objPC._state, (Object)val);
        } else {
            objPC._state = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(7);
            }
        }
    }

    protected static String jdoGet_sticky(Pin objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 8)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 8, objPC._sticky);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(8)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"_sticky\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC._sticky;
    }

    protected static void jdoSet_sticky(Pin objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 8, objPC._sticky, val);
        } else {
            objPC._sticky = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(8);
            }
        }
    }

    protected static long jdoGet_uid(Pin objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 9)) {
            return objPC.jdoStateManager.getLongField((PersistenceCapable)objPC, 9, objPC._uid);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(9)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"_uid\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC._uid;
    }

    protected static void jdoSet_uid(Pin objPC, long val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setLongField((PersistenceCapable)objPC, 9, objPC._uid, val);
        } else {
            objPC._uid = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(9);
            }
        }
    }

    public static enum State {
        PINNING,
        PINNED,
        UNPINNING;

    }
}

