/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.pinmanager;

import diskCacheV111.util.CacheException;
import diskCacheV111.util.PermissionDeniedCacheException;
import diskCacheV111.util.PnfsId;
import org.dcache.cells.CellMessageReceiver;
import org.dcache.pinmanager.AuthorizationPolicy;
import org.dcache.pinmanager.PinDao;
import org.dcache.pinmanager.PinManagerUnpinMessage;
import org.dcache.pinmanager.model.Pin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.transaction.annotation.Transactional;

public class UnpinRequestProcessor
implements CellMessageReceiver {
    private static final Logger _log = LoggerFactory.getLogger(UnpinRequestProcessor.class);
    private PinDao _dao;
    private AuthorizationPolicy _pdp;

    @Required
    public void setDao(PinDao dao) {
        this._dao = dao;
    }

    @Required
    public void setAuthorizationPolicy(AuthorizationPolicy pdp) {
        this._pdp = pdp;
    }

    @Transactional
    public PinManagerUnpinMessage messageArrived(PinManagerUnpinMessage message) throws CacheException {
        PnfsId pnfsId = message.getPnfsId();
        if (message.getPinId() != null) {
            this.unpin(message, this._dao.getPin(pnfsId, message.getPinId()));
        } else if (message.getRequestId() != null) {
            this.unpin(message, this._dao.getPin(pnfsId, message.getRequestId()));
        } else {
            for (Pin pin : this._dao.getPins(pnfsId)) {
                if (this._pdp.canUnpin(message.getSubject(), pin)) {
                    pin.setState(Pin.State.UNPINNING);
                }
                _log.info("Unpinned {} ({})", (Object)pin.getPnfsId(), (Object)pin.getPinId());
                this._dao.storePin(pin);
            }
        }
        return message;
    }

    private void unpin(PinManagerUnpinMessage message, Pin pin) throws CacheException {
        if (pin != null) {
            if (!this._pdp.canUnpin(message.getSubject(), pin)) {
                throw new PermissionDeniedCacheException("Access denied");
            }
            pin.setState(Pin.State.UNPINNING);
            pin = this._dao.storePin(pin);
            message.setPinId(pin.getPinId());
            message.setRequestId(pin.getRequestId());
            _log.info("Unpinned {} ({})", (Object)pin.getPnfsId(), (Object)pin.getPinId());
        }
    }
}

