/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.pinmanager;

import diskCacheV111.util.PnfsId;
import diskCacheV111.vehicles.PoolMgrSelectReadPoolMsg;
import diskCacheV111.vehicles.ProtocolInfo;
import java.io.Serializable;
import java.util.Date;
import javax.security.auth.Subject;
import org.dcache.cells.MessageReply;
import org.dcache.pinmanager.PinManagerPinMessage;
import org.dcache.pinmanager.model.Pin;
import org.dcache.vehicles.FileAttributes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PinTask {
    private static final Logger _log = LoggerFactory.getLogger(PinTask.class);
    private PinManagerPinMessage _request;
    private MessageReply<PinManagerPinMessage> _reply;
    private Pin _pin;
    private PoolMgrSelectReadPoolMsg.Context _readPoolSelectionContext;

    public PinTask(PinManagerPinMessage request, MessageReply<PinManagerPinMessage> reply, Pin pin) {
        this._request = request;
        this._reply = reply;
        this._pin = pin;
    }

    public Pin getPin() {
        return this._pin;
    }

    public void setPin(Pin pin) {
        this._pin = pin;
    }

    public boolean isValidIn(long delay) {
        return this._reply.isValidIn(delay);
    }

    public PnfsId getPnfsId() {
        return this._request.getFileAttributes().getPnfsId();
    }

    public FileAttributes getFileAttributes() {
        return this._request.getFileAttributes();
    }

    public void setFileAttributes(FileAttributes attributes) {
        this._request.setFileAttributes(attributes);
    }

    public ProtocolInfo getProtocolInfo() {
        return this._request.getProtocolInfo();
    }

    public Subject getSubject() {
        return this._request.getSubject();
    }

    public String getRequestId() {
        return this._request.getRequestId();
    }

    public long getLifetime() {
        return this._request.getLifetime();
    }

    public long getPinId() {
        return this._pin.getPinId();
    }

    public String getPool() {
        return this._pin.getPool();
    }

    public String getSticky() {
        return this._pin.getSticky();
    }

    public PoolMgrSelectReadPoolMsg.Context getReadPoolSelectionContext() {
        return this._readPoolSelectionContext;
    }

    public void setReadPoolSelectionContext(PoolMgrSelectReadPoolMsg.Context context) {
        this._readPoolSelectionContext = context;
    }

    public Date freezeExpirationTime() {
        long now = System.currentTimeMillis();
        long lifetime = this.getLifetime();
        Date date = lifetime == -1L ? null : new Date(now + lifetime);
        this._request.setExpirationTime(date);
        return date;
    }

    public Date getExpirationTime() {
        return this._request.getExpirationTime();
    }

    public void fail(int rc, String error) {
        this._reply.fail(this._request, rc, (Serializable)((Object)error));
        _log.warn("Failed to pin {}: {} [{}]", new Object[]{this._pin.getPnfsId(), error, rc});
    }

    public void success() {
        this._request.setPin(this._pin);
        this._reply.reply(this._request);
        _log.info("Pinned {} on {} ({})", new Object[]{this._pin.getPnfsId(), this._pin.getPool(), this._pin.getPinId()});
    }
}

