/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.pinmanager;

import diskCacheV111.poolManager.RequestContainerV5;
import diskCacheV111.util.CacheException;
import diskCacheV111.util.CheckStagePermission;
import diskCacheV111.util.FileNotOnlineCacheException;
import diskCacheV111.util.PnfsId;
import diskCacheV111.vehicles.PoolMgrSelectReadPoolMsg;
import diskCacheV111.vehicles.PoolSetStickyMessage;
import diskCacheV111.vehicles.StorageInfo;
import dmg.cells.nucleus.CellAddressCore;
import dmg.cells.nucleus.CellPath;
import java.io.IOException;
import java.util.Date;
import java.util.EnumSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.regex.PatternSyntaxException;
import javax.security.auth.Subject;
import org.dcache.cells.AbstractMessageCallback;
import org.dcache.cells.CellMessageReceiver;
import org.dcache.cells.CellStub;
import org.dcache.cells.MessageReply;
import org.dcache.namespace.FileAttribute;
import org.dcache.pinmanager.PinDao;
import org.dcache.pinmanager.PinManagerPinMessage;
import org.dcache.pinmanager.PinTask;
import org.dcache.pinmanager.model.Pin;
import org.dcache.poolmanager.PoolInfo;
import org.dcache.poolmanager.PoolMonitor;
import org.dcache.poolmanager.PoolSelector;
import org.dcache.vehicles.PnfsGetFileAttributes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;

public class PinRequestProcessor
implements CellMessageReceiver {
    private static final Logger _log = LoggerFactory.getLogger(PinRequestProcessor.class);
    private static final long RETRY_DELAY = TimeUnit.SECONDS.toMillis(30L);
    private static final long SMALL_DELAY = TimeUnit.MILLISECONDS.toMillis(10L);
    private static final long CLOCK_DRIFT_MARGIN = TimeUnit.MINUTES.toMillis(30L);
    private static final Set<FileAttribute> REQUIRED_ATTRIBUTES = PoolMgrSelectReadPoolMsg.getRequiredAttributes();
    private ScheduledExecutorService _executor;
    private PinDao _dao;
    private CellStub _poolStub;
    private CellStub _pnfsStub;
    private CellStub _poolManagerStub;
    private CheckStagePermission _checkStagePermission;
    private long _maxLifetime;
    private PoolMonitor _poolMonitor;

    @Required
    public void setExecutor(ScheduledExecutorService executor) {
        this._executor = executor;
    }

    @Required
    public void setDao(PinDao dao) {
        this._dao = dao;
    }

    @Required
    public void setPoolStub(CellStub stub) {
        this._poolStub = stub;
    }

    @Required
    public void setPnfsStub(CellStub stub) {
        this._pnfsStub = stub;
    }

    @Required
    public void setPoolManagerStub(CellStub stub) {
        this._poolManagerStub = stub;
    }

    @Required
    public void setStagePermission(CheckStagePermission checker) {
        this._checkStagePermission = checker;
    }

    @Required
    public void setMaxLifetime(long maxLifetime) {
        this._maxLifetime = maxLifetime;
    }

    @Required
    public void setPoolMonitor(PoolMonitor poolMonitor) {
        this._poolMonitor = poolMonitor;
    }

    public long getMaxLifetime() {
        return this._maxLifetime;
    }

    private void enforceLifetimeLimit(PinManagerPinMessage message) {
        if (this._maxLifetime > -1L) {
            long requestedLifetime = message.getLifetime();
            if (requestedLifetime == -1L) {
                message.setLifetime(this._maxLifetime);
            } else {
                message.setLifetime(Math.min(this._maxLifetime, requestedLifetime));
            }
        }
    }

    public MessageReply<PinManagerPinMessage> messageArrived(PinManagerPinMessage message) throws CacheException {
        MessageReply<PinManagerPinMessage> reply = new MessageReply<PinManagerPinMessage>();
        this.enforceLifetimeLimit(message);
        PinTask task = this.createTask(message, reply);
        if (task != null) {
            if (!task.getFileAttributes().isDefined(REQUIRED_ATTRIBUTES)) {
                this.rereadNameSpaceEntry(task);
            } else {
                this.selectReadPool(task);
            }
        }
        return reply;
    }

    protected EnumSet<RequestContainerV5.RequestState> checkStaging(PinTask task) {
        try {
            Subject subject = task.getSubject();
            StorageInfo info = task.getFileAttributes().getStorageInfo();
            return this._checkStagePermission.canPerformStaging(subject, info) ? RequestContainerV5.allStates : RequestContainerV5.allStatesExceptStage;
        }
        catch (IOException | PatternSyntaxException ex) {
            _log.error("Failed to check stage permission: " + ex);
            return RequestContainerV5.allStatesExceptStage;
        }
    }

    private void retry(final PinTask task, long delay) {
        if (!task.isValidIn(delay)) {
            this.fail(task, 10006, "Pin request TTL exceeded");
        } else {
            this._executor.schedule(new Runnable(){

                @Override
                public void run() {
                    try {
                        PinRequestProcessor.this.rereadNameSpaceEntry(task);
                    }
                    catch (CacheException e) {
                        PinRequestProcessor.this.fail(task, e.getRc(), e.getMessage());
                    }
                    catch (RuntimeException e) {
                        PinRequestProcessor.this.fail(task, 10011, e.toString());
                    }
                }
            }, delay, TimeUnit.MILLISECONDS);
        }
    }

    private void fail(PinTask task, int rc, String error) {
        try {
            task.fail(rc, error);
            this.clearPin(task);
        }
        catch (RuntimeException e) {
            _log.error(e.toString());
        }
    }

    private void rereadNameSpaceEntry(final PinTask task) throws CacheException {
        this.refreshTimeout(task, this.getExpirationTimeForNameSpaceLookup());
        EnumSet<FileAttribute> attributes = EnumSet.noneOf(FileAttribute.class);
        attributes.addAll(task.getFileAttributes().getDefinedAttributes());
        attributes.addAll(PoolMgrSelectReadPoolMsg.getRequiredAttributes());
        this._pnfsStub.send(new PnfsGetFileAttributes(task.getPnfsId(), attributes), PnfsGetFileAttributes.class, new AbstractMessageCallback<PnfsGetFileAttributes>(){

            @Override
            public void success(PnfsGetFileAttributes msg) {
                try {
                    task.setFileAttributes(msg.getFileAttributes());
                    PinRequestProcessor.this.refreshTimeout(task, PinRequestProcessor.this.getExpirationTimeForPoolSelection());
                    PinRequestProcessor.this.selectReadPool(task);
                }
                catch (CacheException e) {
                    PinRequestProcessor.this.fail(task, e.getRc(), e.getMessage());
                }
                catch (RuntimeException e) {
                    PinRequestProcessor.this.fail(task, 10011, e.toString());
                }
            }

            @Override
            public void failure(int rc, Object error) {
                PinRequestProcessor.this.fail(task, rc, error.toString());
            }

            @Override
            public void noroute(CellPath path) {
                PinRequestProcessor.this.retry(task, RETRY_DELAY);
            }

            @Override
            public void timeout(CellPath path) {
                PinRequestProcessor.this.retry(task, SMALL_DELAY);
            }
        });
    }

    private void selectReadPool(PinTask task) throws CacheException {
        try {
            PoolSelector poolSelector = this._poolMonitor.getPoolSelector(task.getFileAttributes(), task.getProtocolInfo(), null);
            PoolInfo pool = poolSelector.selectPinPool();
            this.setPool(task, pool.getName());
            this.setStickyFlag(task, pool.getName(), pool.getAddress());
        }
        catch (FileNotOnlineCacheException e) {
            this.askPoolManager(task);
        }
    }

    private void askPoolManager(final PinTask task) {
        PoolMgrSelectReadPoolMsg msg = new PoolMgrSelectReadPoolMsg(task.getFileAttributes(), task.getProtocolInfo(), task.getReadPoolSelectionContext(), this.checkStaging(task));
        msg.setSubject(task.getSubject());
        msg.setSkipCostUpdate(true);
        this._poolManagerStub.send(msg, PoolMgrSelectReadPoolMsg.class, new AbstractMessageCallback<PoolMgrSelectReadPoolMsg>(){

            @Override
            public void success(PoolMgrSelectReadPoolMsg msg) {
                try {
                    task.setReadPoolSelectionContext(msg.getContext());
                    String poolName = msg.getPoolName();
                    CellAddressCore poolAddress = msg.getPoolAddress();
                    task.getFileAttributes().getLocations().add(poolName);
                    PinRequestProcessor.this.setPool(task, poolName);
                    PinRequestProcessor.this.setStickyFlag(task, poolName, poolAddress);
                }
                catch (CacheException e) {
                    PinRequestProcessor.this.fail(task, e.getRc(), e.getMessage());
                }
                catch (RuntimeException e) {
                    PinRequestProcessor.this.fail(task, 10011, e.toString());
                }
            }

            @Override
            public void failure(int rc, Object error) {
                task.setReadPoolSelectionContext(((PoolMgrSelectReadPoolMsg)this.getReply()).getContext());
                switch (rc) {
                    case 10021: {
                        PinRequestProcessor.this.retry(task, 0L);
                        break;
                    }
                    case 10007: 
                    case 10018: {
                        PinRequestProcessor.this.fail(task, rc, error.toString());
                        break;
                    }
                    default: {
                        PinRequestProcessor.this.retry(task, RETRY_DELAY);
                    }
                }
            }

            @Override
            public void noroute(CellPath path) {
                PinRequestProcessor.this.retry(task, RETRY_DELAY);
            }

            @Override
            public void timeout(CellPath path) {
                PinRequestProcessor.this.retry(task, SMALL_DELAY);
            }
        });
    }

    private void setStickyFlag(final PinTask task, String poolName, CellAddressCore poolAddress) {
        Date pinExpiration = task.freezeExpirationTime();
        long poolExpiration = pinExpiration == null ? -1L : pinExpiration.getTime() + CLOCK_DRIFT_MARGIN;
        PoolSetStickyMessage msg = new PoolSetStickyMessage(poolName, task.getPnfsId(), true, task.getSticky(), poolExpiration);
        this._poolStub.send(new CellPath(poolAddress), msg, PoolSetStickyMessage.class, new AbstractMessageCallback<PoolSetStickyMessage>(){

            @Override
            public void success(PoolSetStickyMessage msg) {
                try {
                    PinRequestProcessor.this.setToPinned(task);
                    task.success();
                }
                catch (CacheException e) {
                    PinRequestProcessor.this.fail(task, e.getRc(), e.getMessage());
                }
                catch (RuntimeException e) {
                    PinRequestProcessor.this.fail(task, 10011, e.toString());
                }
            }

            @Override
            public void failure(int rc, Object error) {
                switch (rc) {
                    case 104: {
                        PinRequestProcessor.this.retry(task, RETRY_DELAY);
                        break;
                    }
                    case 10007: {
                        PinRequestProcessor.this.retry(task, SMALL_DELAY);
                        break;
                    }
                    default: {
                        PinRequestProcessor.this.fail(task, rc, error.toString());
                    }
                }
            }

            @Override
            public void noroute(CellPath path) {
                PinRequestProcessor.this.retry(task, RETRY_DELAY);
            }

            @Override
            public void timeout(CellPath path) {
                PinRequestProcessor.this.fail(task, 10006, "No reply from " + path);
            }
        });
    }

    private Date getExpirationTimeForNameSpaceLookup() {
        long now = System.currentTimeMillis();
        long timeout = this._pnfsStub.getTimeout();
        return new Date(now + 2L * (timeout + RETRY_DELAY));
    }

    private Date getExpirationTimeForPoolSelection() {
        long now = System.currentTimeMillis();
        long timeout = this._poolManagerStub.getTimeout();
        return new Date(now + 2L * (timeout + RETRY_DELAY));
    }

    private Date getExpirationTimeForSettingFlag() {
        long now = System.currentTimeMillis();
        long timeout = this._poolStub.getTimeout();
        return new Date(now + 2L * timeout);
    }

    @Transactional
    protected PinTask createTask(PinManagerPinMessage message, MessageReply<PinManagerPinMessage> reply) {
        Pin pin;
        PnfsId pnfsId = message.getFileAttributes().getPnfsId();
        if (message.getRequestId() != null && (pin = this._dao.getPin(pnfsId, message.getRequestId())) != null) {
            if (pin.getState() == Pin.State.PINNED) {
                message.setPin(pin);
                reply.reply(message);
                return null;
            }
            pin.setState(Pin.State.UNPINNING);
            pin.setRequestId(null);
            this._dao.storePin(pin);
        }
        pin = new Pin(message.getSubject(), pnfsId);
        pin.setRequestId(message.getRequestId());
        pin.setSticky("PinManager-" + UUID.randomUUID().toString());
        pin.setExpirationTime(this.getExpirationTimeForPoolSelection());
        return new PinTask(message, reply, this._dao.storePin(pin));
    }

    protected Pin loadPinBelongingTo(PinTask task) throws CacheException {
        Pin pin = this._dao.getPin(task.getPinId(), task.getSticky(), Pin.State.PINNING);
        if (pin == null) {
            throw new CacheException("Operation was aborted");
        }
        return pin;
    }

    @Transactional(isolation=Isolation.REPEATABLE_READ)
    protected void refreshTimeout(PinTask task, Date date) throws CacheException {
        Pin pin = this.loadPinBelongingTo(task);
        pin.setExpirationTime(date);
        task.setPin(this._dao.storePin(pin));
    }

    @Transactional(isolation=Isolation.REPEATABLE_READ)
    protected void setPool(PinTask task, String pool) throws CacheException {
        Pin pin = this.loadPinBelongingTo(task);
        pin.setExpirationTime(this.getExpirationTimeForSettingFlag());
        pin.setPool(pool);
        task.setPin(this._dao.storePin(pin));
    }

    @Transactional(isolation=Isolation.REPEATABLE_READ)
    protected void setToPinned(PinTask task) throws CacheException {
        Pin pin = this.loadPinBelongingTo(task);
        pin.setExpirationTime(task.getExpirationTime());
        pin.setState(Pin.State.PINNED);
        task.setPin(this._dao.storePin(pin));
    }

    @Transactional
    protected void clearPin(PinTask task) {
        if (task.getPool() != null) {
            this._dao.deletePin(task.getPin());
            Pin pin = new Pin(task.getSubject(), task.getPnfsId());
            pin.setState(Pin.State.UNPINNING);
            this._dao.storePin(pin);
        } else {
            this._dao.deletePin(task.getPin());
        }
    }
}

