/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.pinmanager;

import com.google.common.base.Preconditions;
import diskCacheV111.util.PnfsId;
import diskCacheV111.vehicles.Message;
import diskCacheV111.vehicles.PoolMgrSelectReadPoolMsg;
import diskCacheV111.vehicles.ProtocolInfo;
import diskCacheV111.vehicles.StorageInfo;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import org.dcache.namespace.FileAttribute;
import org.dcache.pinmanager.model.Pin;
import org.dcache.vehicles.FileAttributes;

public class PinManagerPinMessage
extends Message {
    private static final long serialVersionUID = -146552359952271936L;
    private FileAttributes _fileAttributes;
    private ProtocolInfo _protocolInfo;
    private long _lifetime;
    private long _pinId;
    private String _pool;
    private String _requestId;
    private Date _expirationTime;

    public PinManagerPinMessage(FileAttributes fileAttributes, ProtocolInfo protocolInfo, String requestId, long lifetime) {
        Preconditions.checkNotNull((Object)fileAttributes);
        Preconditions.checkNotNull((Object)protocolInfo);
        this._fileAttributes = fileAttributes;
        this._protocolInfo = protocolInfo;
        this._requestId = requestId;
        this._lifetime = lifetime;
    }

    public String getRequestId() {
        return this._requestId;
    }

    public void setLifetime(long lifetime) {
        this._lifetime = lifetime;
    }

    public long getLifetime() {
        return this._lifetime;
    }

    public PnfsId getPnfsId() {
        return this._fileAttributes.getPnfsId();
    }

    public StorageInfo getStorageInfo() {
        return this._fileAttributes.getStorageInfo();
    }

    public FileAttributes getFileAttributes() {
        return this._fileAttributes;
    }

    public void setFileAttributes(FileAttributes attributes) {
        this._fileAttributes = attributes;
    }

    public ProtocolInfo getProtocolInfo() {
        return this._protocolInfo;
    }

    public String getPool() {
        return this._pool;
    }

    public void setPool(String pool) {
        this._pool = pool;
    }

    public long getPinId() {
        return this._pinId;
    }

    public void setPinId(long pinId) {
        this._pinId = pinId;
    }

    public void setExpirationTime(Date expirationTime) {
        this._expirationTime = expirationTime;
    }

    public Date getExpirationTime() {
        return this._expirationTime;
    }

    public void setPin(Pin pin) {
        this.setPool(pin.getPool());
        this.setPinId(pin.getPinId());
        this.setExpirationTime(pin.getExpirationTime());
    }

    @Override
    public String toString() {
        return "PinManagerPinMessage[" + this._fileAttributes + "," + this._protocolInfo + "," + this._lifetime + "]";
    }

    public static Collection<FileAttribute> getRequiredAttributes() {
        EnumSet<FileAttribute> attributes = EnumSet.of(FileAttribute.PNFSID);
        attributes.addAll(PoolMgrSelectReadPoolMsg.getRequiredAttributes());
        return attributes;
    }
}

