/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.pinmanager;

import diskCacheV111.util.CacheException;
import diskCacheV111.util.PnfsHandler;
import diskCacheV111.util.PnfsId;
import diskCacheV111.vehicles.DCapProtocolInfo;
import dmg.util.command.Argument;
import dmg.util.command.Command;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.dcache.cells.AbstractCellComponent;
import org.dcache.cells.CellCommandListener;
import org.dcache.cells.CellStub;
import org.dcache.namespace.FileAttribute;
import org.dcache.pinmanager.MovePinRequestProcessor;
import org.dcache.pinmanager.PinDao;
import org.dcache.pinmanager.PinManager;
import org.dcache.pinmanager.PinManagerExtendPinMessage;
import org.dcache.pinmanager.PinManagerPinMessage;
import org.dcache.pinmanager.PinManagerUnpinMessage;
import org.dcache.pinmanager.PinRequestProcessor;
import org.dcache.pinmanager.UnpinRequestProcessor;
import org.dcache.pinmanager.model.Pin;
import org.dcache.vehicles.FileAttributes;
import org.springframework.beans.factory.annotation.Required;

public class PinManagerCLI
extends AbstractCellComponent
implements CellCommandListener {
    private static final AtomicInteger _counter = new AtomicInteger(0);
    private final Map<Integer, BulkJob> _jobs = new ConcurrentHashMap<Integer, BulkJob>();
    private PnfsHandler _pnfs;
    private PinManager _pinManager;
    private PinDao _dao;
    private PinRequestProcessor _pinProcessor;
    private UnpinRequestProcessor _unpinProcessor;
    private MovePinRequestProcessor _moveProcessor;

    @Required
    public void setPnfsStub(CellStub stub) {
        this._pnfs = new PnfsHandler(stub);
    }

    @Required
    public void setPinManager(PinManager pinManager) {
        this._pinManager = pinManager;
    }

    @Required
    public void setPinProcessor(PinRequestProcessor processor) {
        this._pinProcessor = processor;
    }

    @Required
    public void setUnpinProcessor(UnpinRequestProcessor processor) {
        this._unpinProcessor = processor;
    }

    @Required
    public void setMoveProcessor(MovePinRequestProcessor processor) {
        this._moveProcessor = processor;
    }

    @Required
    public void setDao(PinDao dao) {
        this._dao = dao;
    }

    private Future<PinManagerPinMessage> pin(PnfsId pnfsId, String requestId, long lifetime) throws CacheException {
        FileAttributes attributes = new FileAttributes();
        attributes.setPnfsId(pnfsId);
        DCapProtocolInfo protocolInfo = new DCapProtocolInfo("DCap", 3, 0, new InetSocketAddress("localhost", 0));
        PinManagerPinMessage message = new PinManagerPinMessage(attributes, protocolInfo, requestId, lifetime);
        return this._pinProcessor.messageArrived(message);
    }

    private List<PnfsId> parse(File file) throws IOException {
        ArrayList<PnfsId> list = new ArrayList<PnfsId>();
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            String line;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
                list.add(new PnfsId(line));
            }
        }
        catch (IllegalArgumentException e) {
            throw new IOException("Invalid file format: " + e.getMessage());
        }
        return list;
    }

    static /* synthetic */ AtomicInteger access$700() {
        return _counter;
    }

    private class BulkJob
    implements Runnable {
        protected final Map<PnfsId, Future<PinManagerPinMessage>> _tasks = new HashMap<PnfsId, Future<PinManagerPinMessage>>();
        private final StringBuilder _errors = new StringBuilder();
        protected final String _requestId = UUID.randomUUID().toString();
        protected final int _id = PinManagerCLI.access$700().incrementAndGet();
        protected final long _lifetime;
        protected boolean _cancelled;

        public BulkJob(List<PnfsId> files, long lifetime) {
            this._lifetime = lifetime;
            for (PnfsId pnfsId : files) {
                this._tasks.put(pnfsId, null);
            }
        }

        @Override
        public void run() {
            ArrayList<PnfsId> list = new ArrayList<PnfsId>(this._tasks.keySet());
            for (PnfsId pnfsId : list) {
                try {
                    this._tasks.put(pnfsId, PinManagerCLI.this.pin(pnfsId, this._requestId, this._lifetime));
                }
                catch (CacheException e) {
                    this._tasks.remove(pnfsId);
                    this._errors.append("    ").append(pnfsId).append(": ").append(e.getMessage()).append('\n');
                }
                catch (RuntimeException e) {
                    this._tasks.remove(pnfsId);
                    this._errors.append("    ").append(pnfsId).append(": ").append(e.toString()).append('\n');
                }
            }
        }

        public int getId() {
            return this._id;
        }

        public synchronized void cancel() throws CacheException {
            if (!this._cancelled) {
                for (PnfsId pnfsId : this._tasks.keySet()) {
                    PinManagerUnpinMessage message = new PinManagerUnpinMessage(pnfsId);
                    message.setRequestId(this._requestId);
                    PinManagerCLI.this._unpinProcessor.messageArrived(message);
                }
                this._cancelled = true;
            }
        }

        public synchronized boolean isCancelled() {
            return this._cancelled;
        }

        public boolean isDone() {
            for (Future<PinManagerPinMessage> task : this._tasks.values()) {
                if (task != null && task.isDone()) continue;
                return false;
            }
            return true;
        }

        public String getJobDescription() {
            String state = this.isCancelled() ? "CANCELLED" : (this.isDone() ? "DONE" : "PROCESSING");
            return String.format("[%d] %s", this._id, state);
        }

        public String toString() {
            try {
                StringBuilder out = new StringBuilder();
                for (Map.Entry<PnfsId, Future<PinManagerPinMessage>> entry : this._tasks.entrySet()) {
                    out.append("  ").append(entry.getKey()).append(": ");
                    try {
                        Future<PinManagerPinMessage> future = entry.getValue();
                        if (future == null) {
                            out.append("INITIALIZING");
                        } else if (!future.isDone()) {
                            out.append("PROCESSING");
                        } else if (this.isCancelled()) {
                            out.append("CANCELLED");
                        } else {
                            future.get();
                            out.append("DONE");
                        }
                    }
                    catch (ExecutionException e) {
                        out.append(e.getMessage());
                    }
                    out.append('\n');
                }
                if (this._errors.length() > 0) {
                    out.append("Failed during initialization:\n");
                    out.append((CharSequence)this._errors);
                }
                return out.toString();
            }
            catch (InterruptedException e) {
                return e.toString();
            }
        }
    }

    @Command(name="bulk ls", hint="list bulk jobs", usage="Lists background jobs. If a job id is specified then additional status information about the job is provided.")
    public class BulkListCommand
    implements Callable<String> {
        @Argument(required=false)
        Integer id;

        @Override
        public String call() {
            if (this.id == 0) {
                StringBuilder sb = new StringBuilder();
                for (Map.Entry entry : PinManagerCLI.this._jobs.entrySet()) {
                    int id = (Integer)entry.getKey();
                    BulkJob job = (BulkJob)entry.getValue();
                    sb.append(job.getJobDescription()).append('\n');
                }
                return sb.toString();
            }
            BulkJob job = (BulkJob)PinManagerCLI.this._jobs.get(this.id);
            if (job == null) {
                return "No such job";
            }
            return job.toString();
        }
    }

    @Command(name="bulk cancel", hint="cancel bulk job", usage="Cancels a background job. Note that cancelling a bulk job will cause all pins already created by the job to be released.")
    public class BulkCancelCommand
    implements Callable<String> {
        @Argument
        int id;

        @Override
        public String call() throws CacheException {
            BulkJob job = (BulkJob)PinManagerCLI.this._jobs.get(this.id);
            if (job == null) {
                return "No such job";
            }
            job.cancel();
            return job.getJobDescription();
        }
    }

    @Command(name="bulk clear", hint="remove completed bulk jobs", usage="Removes completed jobs. For reference, information about background jobs is kept until explicitly cleared.")
    public class BulkClearCommand
    implements Callable<String> {
        @Override
        public String call() throws Exception {
            int count = 0;
            Iterator i = PinManagerCLI.this._jobs.values().iterator();
            while (i.hasNext()) {
                if (!((BulkJob)i.next()).isDone()) continue;
                i.remove();
                ++count;
            }
            return String.format("%d jobs removed", count);
        }
    }

    @Command(name="bulk unpin", hint="unpin several files", usage="Unpin a list of PNFS IDs from FILE. Each line of FILE must be a PNFS ID.")
    public class BulkUnpinCommand
    implements Callable<String> {
        @Argument(index=0)
        File file;

        @Override
        public String call() throws IOException {
            StringBuilder out = new StringBuilder();
            for (PnfsId pnfsId : PinManagerCLI.this.parse(this.file)) {
                try {
                    PinManagerUnpinMessage message = new PinManagerUnpinMessage(pnfsId);
                    PinManagerCLI.this._unpinProcessor.messageArrived(message);
                }
                catch (CacheException e) {
                    out.append(pnfsId).append(": ").append(e.getMessage()).append('\n');
                }
            }
            return out.toString();
        }
    }

    @Command(name="bulk pin", hint="pin several files", usage="Pin a list of PNFS IDs from FILE for a specified number of seconds. Each line FILE must be a PNFS ID.")
    public class BulkPinCommand
    implements Callable<String> {
        @Argument(index=0)
        File file;
        @Argument(index=1, metaVar="seconds")
        long lifetime;

        @Override
        public String call() throws IOException {
            long millis = this.lifetime == -1L ? -1L : TimeUnit.SECONDS.toMillis(this.lifetime);
            BulkJob job = new BulkJob(PinManagerCLI.this.parse(this.file), millis);
            PinManagerCLI.this._jobs.put(job.getId(), job);
            new Thread((Runnable)job, "BulkPin-" + job.getId()).start();
            return job.getJobDescription();
        }
    }

    @Command(name="ls", hint="list pins", usage="Lists all pins or a specified pin by pin id or PNFSID.")
    public class ListCommand
    implements Callable<String> {
        @Argument(index=0, required=false, valueSpec="PIN|PNFSID")
        String id;

        @Override
        public String call() throws IllegalArgumentException {
            Collection<Pin> pins;
            if (this.id != null) {
                if (!PnfsId.isValid(this.id)) {
                    Pin pin = PinManagerCLI.this._dao.getPin(Long.parseLong(this.id));
                    return pin == null ? "" : pin.toString();
                }
                pins = PinManagerCLI.this._dao.getPins(new PnfsId(this.id));
            } else {
                pins = PinManagerCLI.this._dao.getPins();
            }
            StringBuilder out = new StringBuilder();
            for (Pin pin : pins) {
                out.append(pin).append("\n");
            }
            out.append("total ").append(pins.size());
            return out.toString();
        }
    }

    @Command(name="extend", hint="extend lifetime of a pin", usage="Extend the lifetime of an existing pin. A pin with a lifetime of -1 will never expire and has to be unpinned explicitly. The lifetime of a pin can only be extended, not shortened.")
    public class ExtendCommand
    implements Callable<String> {
        @Argument(index=0)
        long pin;
        @Argument(index=1)
        PnfsId pnfsId;
        @Argument(index=2, metaVar="seconds")
        long lifetime;

        @Override
        public String call() throws CacheException, InterruptedException {
            long millis = this.lifetime == -1L ? -1L : TimeUnit.SECONDS.toMillis(this.lifetime);
            Set<FileAttribute> attributes = PinManagerExtendPinMessage.getRequiredAttributes();
            FileAttributes fileAttributes = PinManagerCLI.this._pnfs.getFileAttributes(this.pnfsId, attributes);
            PinManagerExtendPinMessage message = new PinManagerExtendPinMessage(fileAttributes, this.pin, millis);
            message = PinManagerCLI.this._moveProcessor.messageArrived(message);
            if (message.getExpirationTime() == null) {
                return String.format("[%d] %s pinned", message.getPinId(), this.pnfsId);
            }
            return String.format("[%d] %s pinned until %tc", message.getPinId(), this.pnfsId, message.getExpirationTime());
        }
    }

    @Command(name="unpin", hint="unpin a file", usage="Unpin a previously pinned file. Either a specific pin or all pins on a specific file can be removed.")
    public class UnpinCommand
    implements Callable<String> {
        @Argument(index=0, valueSpec="*|PIN")
        String pin;
        @Argument(index=1)
        PnfsId pnfsId;

        @Override
        public String call() throws NumberFormatException, CacheException {
            PinManagerUnpinMessage message = new PinManagerUnpinMessage(this.pnfsId);
            if (!this.pin.equals("*")) {
                message.setPinId(Long.parseLong(this.pin));
            }
            PinManagerCLI.this._unpinProcessor.messageArrived(message);
            return "The pin is now scheduled for removal";
        }
    }

    @Command(name="pin", hint="pin a file to disk", usage="Pins a file to disk for some time. A file may be pinned forever by specifying a lifetime of -1. Pinning a file may involve staging it or copying it from one pool to another. For that reason pinning may take awhile and the pin command may time out. The pin request will however stay active and progress may be tracked by listing the pins on the file.")
    public class PinCommand
    implements Callable<String> {
        @Argument(index=0)
        PnfsId pnfsId;
        @Argument(index=1, metaVar="seconds")
        long lifetime;

        @Override
        public String call() throws CacheException, ExecutionException, InterruptedException {
            long millis = this.lifetime == -1L ? -1L : TimeUnit.SECONDS.toMillis(this.lifetime);
            PinManagerPinMessage message = (PinManagerPinMessage)PinManagerCLI.this.pin(this.pnfsId, null, millis).get();
            if (message.getExpirationTime() == null) {
                return String.format("[%d] %s pinned", message.getPinId(), this.pnfsId);
            }
            return String.format("[%d] %s pinned until %tc", message.getPinId(), this.pnfsId, message.getExpirationTime());
        }
    }
}

