/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.pinmanager;

import com.google.common.base.Predicate;
import diskCacheV111.util.PnfsId;
import java.util.Collection;
import java.util.Date;
import javax.jdo.JDOObjectNotFoundException;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.Query;
import org.dcache.pinmanager.PinDao;
import org.dcache.pinmanager.model.Pin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class JdoDao
implements PinDao {
    private static final Logger _log = LoggerFactory.getLogger(JdoDao.class);
    private PersistenceManagerFactory _pmf;

    @Required
    public void setPersistenceManagerFactory(PersistenceManagerFactory pmf) {
        this._pmf = pmf;
    }

    @Override
    @Transactional
    public Pin storePin(Pin pin) {
        PersistenceManager pm = this._pmf.getPersistenceManager();
        pin = (Pin)pm.detachCopy(pm.makePersistent((Object)pin));
        if (_log.isDebugEnabled()) {
            _log.debug(pin.toString());
        }
        return pin;
    }

    @Override
    @Transactional(readOnly=true)
    public Pin getPin(long id) {
        PersistenceManager pm = this._pmf.getPersistenceManager();
        Query query = pm.newQuery(Pin.class, "_id == :id");
        query.setUnique(true);
        Pin pin = (Pin)query.execute((Object)id);
        return pin == null ? null : (Pin)pm.detachCopy((Object)pin);
    }

    @Override
    @Transactional(readOnly=true)
    public Pin getPin(PnfsId pnfsId, long id) {
        PersistenceManager pm = this._pmf.getPersistenceManager();
        Query query = pm.newQuery(Pin.class, "_pnfsId == :pnfsId && _id == :id");
        query.setUnique(true);
        Pin pin = (Pin)query.execute((Object)pnfsId.toString(), (Object)id);
        return pin == null ? null : (Pin)pm.detachCopy((Object)pin);
    }

    @Override
    @Transactional(readOnly=true)
    public Pin getPin(long id, String sticky, Pin.State state) {
        PersistenceManager pm = this._pmf.getPersistenceManager();
        Query query = pm.newQuery(Pin.class, "_id == :id && _sticky == :sticky && _state == :state");
        query.setUnique(true);
        Pin pin = (Pin)query.execute((Object)id, (Object)sticky, (Object)state);
        return pin == null ? null : (Pin)pm.detachCopy((Object)pin);
    }

    @Override
    @Transactional(readOnly=true)
    public Pin getPin(PnfsId pnfsId, String requestId) {
        PersistenceManager pm = this._pmf.getPersistenceManager();
        Query query = pm.newQuery(Pin.class, "_pnfsId == :pnfsId && _requestId == :requestId");
        query.setUnique(true);
        Pin pin = (Pin)query.execute((Object)pnfsId.toString(), (Object)requestId);
        return pin == null ? null : (Pin)pm.detachCopy((Object)pin);
    }

    @Override
    @Transactional(readOnly=true)
    public Collection<Pin> getPins() {
        PersistenceManager pm = this._pmf.getPersistenceManager();
        Query query = pm.newQuery(Pin.class);
        Collection pins = (Collection)query.execute();
        return pm.detachCopyAll(pins);
    }

    @Override
    @Transactional(readOnly=true)
    public Collection<Pin> getPins(PnfsId pnfsId) {
        PersistenceManager pm = this._pmf.getPersistenceManager();
        Query query = pm.newQuery(Pin.class, "_pnfsId == :pnfsId");
        Collection pins = (Collection)query.execute((Object)pnfsId.toString());
        return pm.detachCopyAll(pins);
    }

    @Override
    @Transactional(readOnly=true)
    public Collection<Pin> getPins(Pin.State state) {
        PersistenceManager pm = this._pmf.getPersistenceManager();
        Query query = pm.newQuery(Pin.class, "_state == :state");
        Collection pins = (Collection)query.execute((Object)state);
        return pm.detachCopyAll(pins);
    }

    @Override
    @Transactional(readOnly=true)
    public Collection<Pin> getPins(PnfsId pnfsId, String pool) {
        PersistenceManager pm = this._pmf.getPersistenceManager();
        Query query = pm.newQuery(Pin.class, "_pnfsId == :pnfsId && _pool == :pool");
        Collection pins = (Collection)query.execute((Object)pnfsId.toString(), (Object)pool);
        return pm.detachCopyAll(pins);
    }

    @Override
    @Transactional(readOnly=true)
    public boolean hasSharedSticky(Pin pin) {
        PersistenceManager pm = this._pmf.getPersistenceManager();
        Query query = pm.newQuery(Pin.class, "_pnfsId == :pnfsId && _id != :id && _pool == :pool && _sticky == :sticky && _state != 'UNPINNING'");
        query.setResult("count(this)");
        return (Long)query.executeWithArray(new Object[]{pin.getPnfsId().toString(), pin.getPinId(), pin.getPool(), pin.getSticky()}) > 0L;
    }

    @Override
    @Transactional
    public void deletePins(String[] pnfsIds) {
        PersistenceManager pm = this._pmf.getPersistenceManager();
        for (String pnfsId : pnfsIds) {
            pm.newQuery(Pin.class, "_pnfsId == :pnfsId").deletePersistentAll(new Object[]{pnfsId});
        }
    }

    @Override
    @Transactional
    public void deletePin(Pin pin) {
        try {
            PersistenceManager pm = this._pmf.getPersistenceManager();
            pm.deletePersistent((Object)pin);
        }
        catch (JDOObjectNotFoundException e) {
            _log.debug("Pin deletion failed: {}", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    public void expirePins() {
        Date now = new Date();
        PersistenceManager pm = this._pmf.getPersistenceManager();
        Query query = pm.newQuery(Pin.class, "_expirationTime < :now && _state != 'UNPINNING'");
        query.addExtension("datanucleus.rdbms.query.resultSetType", (Object)"scroll-insensitive");
        query.addExtension("datanucleus.query.resultCacheType", (Object)"none");
        query.getFetchPlan().setFetchSize(0);
        try {
            for (Pin pin : (Collection)query.execute((Object)now)) {
                pin.setState(Pin.State.UNPINNING);
            }
        }
        finally {
            query.closeAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    public boolean all(Pin.State state, Predicate<Pin> f) {
        PersistenceManager pm = this._pmf.getPersistenceManager();
        Query query = pm.newQuery(Pin.class, "_state == :state");
        query.addExtension("datanucleus.rdbms.query.resultSetType", (Object)"scroll-insensitive");
        query.addExtension("datanucleus.query.resultCacheType", (Object)"none");
        query.getFetchPlan().setFetchSize(0);
        try {
            for (Pin pin : (Collection)query.execute((Object)state)) {
                if (f.apply(pm.detachCopy((Object)pin))) continue;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            query.closeAll();
        }
        return true;
    }
}

