/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.net;

import java.io.IOException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.Map;
import org.dcache.net.ChallengeReader;
import org.dcache.util.PortRange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtocolConnectionPool
extends Thread {
    private static Logger _logSocketIO = LoggerFactory.getLogger((String)"logger.dev.org.dcache.io.socket");
    private final ServerSocketChannel _serverSocketChannel;
    private final Map<Object, SocketChannel> _acceptedSockets = new HashMap<Object, SocketChannel>();
    private final ChallengeReader _challengeReader;
    private boolean _stop;

    ProtocolConnectionPool(int listenPort, int receiveBufferSize, ChallengeReader challengeReader) throws IOException {
        super("ProtocolConnectionPool");
        String dcachePorts;
        this._challengeReader = challengeReader;
        this._serverSocketChannel = ServerSocketChannel.open();
        if (receiveBufferSize > 0) {
            this._serverSocketChannel.socket().setReceiveBufferSize(receiveBufferSize);
        }
        PortRange portRange = listenPort != 0 ? new PortRange(listenPort) : ((dcachePorts = System.getProperty("org.dcache.net.tcp.portrange")) != null ? PortRange.valueOf(dcachePorts) : new PortRange(0));
        portRange.bind(this._serverSocketChannel.socket());
        if (_logSocketIO.isDebugEnabled()) {
            _logSocketIO.debug("Socket BIND local = " + this._serverSocketChannel.socket().getInetAddress() + ":" + this._serverSocketChannel.socket().getLocalPort());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SocketChannel getSocket(Object challenge) throws InterruptedException {
        Map<Object, SocketChannel> map = this._acceptedSockets;
        synchronized (map) {
            while (this._acceptedSockets.isEmpty() || !this._acceptedSockets.containsKey(challenge)) {
                this._acceptedSockets.wait();
            }
            return this._acceptedSockets.remove(challenge);
        }
    }

    public int getLocalPort() {
        return this._serverSocketChannel.socket().getLocalPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this._stop) {
            try {
                Object challenge;
                SocketChannel newSocketChannel = this._serverSocketChannel.accept();
                if (_logSocketIO.isDebugEnabled()) {
                    _logSocketIO.debug("Socket OPEN (ACCEPT) remote = " + newSocketChannel.socket().getInetAddress() + ":" + newSocketChannel.socket().getPort() + " local = " + newSocketChannel.socket().getLocalAddress() + ":" + newSocketChannel.socket().getLocalPort());
                }
                if ((challenge = this._challengeReader.getChallenge(newSocketChannel)) == null) {
                    if (_logSocketIO.isDebugEnabled()) {
                        _logSocketIO.debug("Socket CLOSE (no challenge) remote = " + newSocketChannel.socket().getInetAddress() + ":" + newSocketChannel.socket().getPort() + " local = " + newSocketChannel.socket().getLocalAddress() + ":" + newSocketChannel.socket().getLocalPort());
                    }
                    newSocketChannel.close();
                    continue;
                }
                Map<Object, SocketChannel> map = this._acceptedSockets;
                synchronized (map) {
                    this._acceptedSockets.put(challenge, newSocketChannel);
                    this._acceptedSockets.notifyAll();
                    Thread.yield();
                }
            }
            catch (IOException e) {
                _logSocketIO.error("Accept loop", (Throwable)e);
                this._stop = true;
                try {
                    _logSocketIO.debug("Socket SHUTDOWN local = {}:{}", (Object)this._serverSocketChannel.socket().getInetAddress(), (Object)this._serverSocketChannel.socket().getLocalPort());
                    this._serverSocketChannel.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

