/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.namespace;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import javax.security.auth.Subject;
import org.dcache.acl.enums.AccessType;
import org.dcache.auth.Subjects;
import org.dcache.namespace.FileAttribute;
import org.dcache.namespace.PermissionHandler;
import org.dcache.vehicles.FileAttributes;

public class PosixPermissionHandler
implements PermissionHandler {
    private Set<FileAttribute> _requiredAttributes = Collections.unmodifiableSet(EnumSet.of(FileAttribute.OWNER, FileAttribute.OWNER_GROUP, FileAttribute.MODE));

    @Override
    public Set<FileAttribute> getRequiredAttributes() {
        return this._requiredAttributes;
    }

    private boolean isSet(int mode, int flag) {
        return (mode & flag) == flag;
    }

    @Override
    public AccessType canReadFile(Subject subject, FileAttributes attr) {
        int mode = attr.getMode();
        if (Subjects.hasUid((Subject)subject, (long)attr.getOwner())) {
            return AccessType.valueOf((boolean)this.isSet(mode, 256));
        }
        if (Subjects.hasGid((Subject)subject, (long)attr.getGroup())) {
            return AccessType.valueOf((boolean)this.isSet(mode, 32));
        }
        return AccessType.valueOf((boolean)this.isSet(mode, 4));
    }

    @Override
    public AccessType canWriteFile(Subject subject, FileAttributes attr) {
        int mode = attr.getMode();
        if (Subjects.hasUid((Subject)subject, (long)attr.getOwner())) {
            return AccessType.valueOf((boolean)this.isSet(mode, 128));
        }
        if (Subjects.hasGid((Subject)subject, (long)attr.getGroup())) {
            return AccessType.valueOf((boolean)this.isSet(mode, 16));
        }
        return AccessType.valueOf((boolean)this.isSet(mode, 2));
    }

    @Override
    public AccessType canCreateSubDir(Subject subject, FileAttributes parentAttr) {
        if (parentAttr == null) {
            return AccessType.ACCESS_DENIED;
        }
        int mode = parentAttr.getMode();
        if (Subjects.hasUid((Subject)subject, (long)parentAttr.getOwner())) {
            return AccessType.valueOf((boolean)this.isSet(mode, 192));
        }
        if (Subjects.hasGid((Subject)subject, (long)parentAttr.getGroup())) {
            return AccessType.valueOf((boolean)this.isSet(mode, 24));
        }
        return AccessType.valueOf((boolean)this.isSet(mode, 3));
    }

    @Override
    public AccessType canCreateFile(Subject subject, FileAttributes parentAttr) {
        if (parentAttr == null) {
            return AccessType.ACCESS_DENIED;
        }
        int mode = parentAttr.getMode();
        if (Subjects.hasUid((Subject)subject, (long)parentAttr.getOwner())) {
            return AccessType.valueOf((boolean)this.isSet(mode, 192));
        }
        if (Subjects.hasGid((Subject)subject, (long)parentAttr.getGroup())) {
            return AccessType.valueOf((boolean)this.isSet(mode, 24));
        }
        return AccessType.valueOf((boolean)this.isSet(mode, 3));
    }

    @Override
    public AccessType canDeleteFile(Subject subject, FileAttributes parentAttr, FileAttributes childAttr) {
        if (parentAttr == null) {
            return AccessType.ACCESS_DENIED;
        }
        int mode = parentAttr.getMode();
        if (Subjects.hasUid((Subject)subject, (long)parentAttr.getOwner())) {
            return AccessType.valueOf((boolean)this.isSet(mode, 192));
        }
        if (Subjects.hasGid((Subject)subject, (long)parentAttr.getGroup())) {
            return AccessType.valueOf((boolean)this.isSet(mode, 24));
        }
        return AccessType.valueOf((boolean)this.isSet(mode, 3));
    }

    @Override
    public AccessType canDeleteDir(Subject subject, FileAttributes parentAttr, FileAttributes childAttr) {
        if (parentAttr == null) {
            return AccessType.ACCESS_DENIED;
        }
        int mode = parentAttr.getMode();
        if (Subjects.hasUid((Subject)subject, (long)parentAttr.getOwner())) {
            return AccessType.valueOf((boolean)this.isSet(mode, 192));
        }
        if (Subjects.hasGid((Subject)subject, (long)parentAttr.getGroup())) {
            return AccessType.valueOf((boolean)this.isSet(mode, 24));
        }
        return AccessType.valueOf((boolean)this.isSet(mode, 3));
    }

    @Override
    public AccessType canListDir(Subject subject, FileAttributes attr) {
        int mode = attr.getMode();
        if (Subjects.hasUid((Subject)subject, (long)attr.getOwner())) {
            return AccessType.valueOf((boolean)this.isSet(mode, 320));
        }
        if (Subjects.hasGid((Subject)subject, (long)attr.getGroup())) {
            return AccessType.valueOf((boolean)this.isSet(mode, 40));
        }
        return AccessType.valueOf((boolean)this.isSet(mode, 5));
    }

    @Override
    public AccessType canLookup(Subject subject, FileAttributes attr) {
        int mode = attr.getMode();
        if (Subjects.hasUid((Subject)subject, (long)attr.getOwner())) {
            return AccessType.valueOf((boolean)this.isSet(mode, 64));
        }
        if (Subjects.hasGid((Subject)subject, (long)attr.getGroup())) {
            return AccessType.valueOf((boolean)this.isSet(mode, 8));
        }
        return AccessType.valueOf((boolean)this.isSet(mode, 1));
    }

    @Override
    public AccessType canRename(Subject subject, FileAttributes parentAttr, FileAttributes newParentAttr, boolean isDirectory) {
        if (parentAttr == null || newParentAttr == null) {
            return AccessType.ACCESS_DENIED;
        }
        int parentMode = parentAttr.getMode();
        int newParentMode = newParentAttr.getMode();
        AccessType result = Subjects.hasUid((Subject)subject, (long)parentAttr.getOwner()) ? AccessType.valueOf((boolean)this.isSet(parentMode, 192)) : (Subjects.hasGid((Subject)subject, (long)parentAttr.getGroup()) ? AccessType.valueOf((boolean)this.isSet(parentMode, 24)) : AccessType.valueOf((boolean)this.isSet(parentMode, 3)));
        if (result != AccessType.ACCESS_ALLOWED) {
            return AccessType.ACCESS_DENIED;
        }
        if (Subjects.hasUid((Subject)subject, (long)newParentAttr.getOwner())) {
            return AccessType.valueOf((boolean)this.isSet(newParentMode, 192));
        }
        if (Subjects.hasGid((Subject)subject, (long)newParentAttr.getGroup())) {
            return AccessType.valueOf((boolean)this.isSet(newParentMode, 24));
        }
        return AccessType.valueOf((boolean)this.isSet(newParentMode, 3));
    }

    @Override
    public AccessType canSetAttributes(Subject subject, FileAttributes parentAttr, FileAttributes attr, Set<FileAttribute> attributes) {
        if ((attributes.contains((Object)FileAttribute.OWNER) || attributes.contains((Object)FileAttribute.OWNER_GROUP) || attributes.contains((Object)FileAttribute.MODE) || attributes.contains((Object)FileAttribute.PERMISSION)) && !Subjects.hasUid((Subject)subject, (long)attr.getOwner())) {
            return AccessType.ACCESS_DENIED;
        }
        int mode = attr.getMode();
        if (Subjects.hasUid((Subject)subject, (long)attr.getOwner())) {
            return AccessType.valueOf((boolean)this.isSet(mode, 128));
        }
        if (Subjects.hasGid((Subject)subject, (long)attr.getGroup())) {
            return AccessType.valueOf((boolean)this.isSet(mode, 16));
        }
        return AccessType.valueOf((boolean)this.isSet(mode, 2));
    }

    @Override
    public AccessType canGetAttributes(Subject subject, FileAttributes parentAttr, FileAttributes attr, Set<FileAttribute> attributes) {
        if (parentAttr == null) {
            return AccessType.ACCESS_ALLOWED;
        }
        int mode = parentAttr.getMode();
        if (Subjects.hasUid((Subject)subject, (long)parentAttr.getOwner())) {
            return AccessType.valueOf((boolean)this.isSet(mode, 64));
        }
        if (Subjects.hasGid((Subject)subject, (long)parentAttr.getGroup())) {
            return AccessType.valueOf((boolean)this.isSet(mode, 8));
        }
        return AccessType.valueOf((boolean)this.isSet(mode, 1));
    }
}

