/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.namespace;

import dmg.util.CollectionFactory;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.security.auth.Subject;
import org.dcache.acl.enums.AccessType;
import org.dcache.namespace.FileAttribute;
import org.dcache.namespace.PermissionHandler;
import org.dcache.vehicles.FileAttributes;

public class ChainedPermissionHandler
implements PermissionHandler {
    private final List<PermissionHandler> _chain = CollectionFactory.newArrayList();

    public ChainedPermissionHandler() {
    }

    public ChainedPermissionHandler(List<PermissionHandler> chain) {
        this._chain.addAll(chain);
    }

    public ChainedPermissionHandler(PermissionHandler ... chain) {
        this._chain.addAll(Arrays.asList(chain));
    }

    public void setChain(List<PermissionHandler> chain) {
        this._chain.clear();
        this._chain.addAll(chain);
    }

    @Override
    public Set<FileAttribute> getRequiredAttributes() {
        EnumSet<FileAttribute> attributes = EnumSet.noneOf(FileAttribute.class);
        for (PermissionHandler handler : this._chain) {
            attributes.addAll(handler.getRequiredAttributes());
        }
        return attributes;
    }

    @Override
    public AccessType canReadFile(Subject subject, FileAttributes attr) {
        for (PermissionHandler handler : this._chain) {
            AccessType res = handler.canReadFile(subject, attr);
            if (res == null || res == AccessType.ACCESS_UNDEFINED) continue;
            return res;
        }
        return AccessType.ACCESS_UNDEFINED;
    }

    @Override
    public AccessType canWriteFile(Subject subject, FileAttributes attr) {
        for (PermissionHandler handler : this._chain) {
            AccessType res = handler.canWriteFile(subject, attr);
            if (res == null || res == AccessType.ACCESS_UNDEFINED) continue;
            return res;
        }
        return AccessType.ACCESS_UNDEFINED;
    }

    @Override
    public AccessType canCreateSubDir(Subject subject, FileAttributes parentAttr) {
        for (PermissionHandler handler : this._chain) {
            AccessType res = handler.canCreateSubDir(subject, parentAttr);
            if (res == null || res == AccessType.ACCESS_UNDEFINED) continue;
            return res;
        }
        return AccessType.ACCESS_UNDEFINED;
    }

    @Override
    public AccessType canCreateFile(Subject subject, FileAttributes parentAttr) {
        for (PermissionHandler handler : this._chain) {
            AccessType res = handler.canCreateFile(subject, parentAttr);
            if (res == null || res == AccessType.ACCESS_UNDEFINED) continue;
            return res;
        }
        return AccessType.ACCESS_UNDEFINED;
    }

    @Override
    public AccessType canDeleteFile(Subject subject, FileAttributes parentAttr, FileAttributes childAttr) {
        for (PermissionHandler handler : this._chain) {
            AccessType res = handler.canDeleteFile(subject, parentAttr, childAttr);
            if (res == null || res == AccessType.ACCESS_UNDEFINED) continue;
            return res;
        }
        return AccessType.ACCESS_UNDEFINED;
    }

    @Override
    public AccessType canDeleteDir(Subject subject, FileAttributes parentAttr, FileAttributes childAttr) {
        for (PermissionHandler handler : this._chain) {
            AccessType res = handler.canDeleteDir(subject, parentAttr, childAttr);
            if (res == null || res == AccessType.ACCESS_UNDEFINED) continue;
            return res;
        }
        return AccessType.ACCESS_UNDEFINED;
    }

    @Override
    public AccessType canRename(Subject subject, FileAttributes existingParentAttr, FileAttributes newParentAttr, boolean isDirectory) {
        for (PermissionHandler handler : this._chain) {
            AccessType res = handler.canRename(subject, existingParentAttr, newParentAttr, isDirectory);
            if (res == null || res == AccessType.ACCESS_UNDEFINED) continue;
            return res;
        }
        return AccessType.ACCESS_UNDEFINED;
    }

    @Override
    public AccessType canListDir(Subject subject, FileAttributes attr) {
        for (PermissionHandler handler : this._chain) {
            AccessType res = handler.canListDir(subject, attr);
            if (res == null || res == AccessType.ACCESS_UNDEFINED) continue;
            return res;
        }
        return AccessType.ACCESS_UNDEFINED;
    }

    @Override
    public AccessType canLookup(Subject subject, FileAttributes attr) {
        for (PermissionHandler handler : this._chain) {
            AccessType res = handler.canLookup(subject, attr);
            if (res == null || res == AccessType.ACCESS_UNDEFINED) continue;
            return res;
        }
        return AccessType.ACCESS_UNDEFINED;
    }

    private AccessType canSetAttribute(Subject subject, FileAttributes parentAttrs, FileAttributes attrs, FileAttribute attribute) {
        Set<FileAttribute> set = Collections.singleton(attribute);
        for (PermissionHandler handler : this._chain) {
            AccessType res = handler.canSetAttributes(subject, parentAttrs, attrs, set);
            switch (res) {
                case ACCESS_DENIED: {
                    return AccessType.ACCESS_DENIED;
                }
                case ACCESS_ALLOWED: {
                    return AccessType.ACCESS_ALLOWED;
                }
            }
        }
        return AccessType.ACCESS_UNDEFINED;
    }

    private AccessType canGetAttribute(Subject subject, FileAttributes parentAttrs, FileAttributes attrs, FileAttribute attribute) {
        Set<FileAttribute> set = Collections.singleton(attribute);
        for (PermissionHandler handler : this._chain) {
            AccessType res = handler.canGetAttributes(subject, parentAttrs, attrs, set);
            switch (res) {
                case ACCESS_DENIED: {
                    return AccessType.ACCESS_DENIED;
                }
                case ACCESS_ALLOWED: {
                    return AccessType.ACCESS_ALLOWED;
                }
            }
        }
        return AccessType.ACCESS_UNDEFINED;
    }

    @Override
    public AccessType canSetAttributes(Subject subject, FileAttributes parentAttrs, FileAttributes attrs, Set<FileAttribute> attributes) {
        boolean allAllowed = true;
        for (FileAttribute attribute : attributes) {
            AccessType res = this.canSetAttribute(subject, parentAttrs, attrs, attribute);
            switch (res) {
                case ACCESS_DENIED: {
                    return AccessType.ACCESS_DENIED;
                }
                case ACCESS_UNDEFINED: {
                    allAllowed = false;
                    break;
                }
            }
        }
        return allAllowed ? AccessType.ACCESS_ALLOWED : AccessType.ACCESS_UNDEFINED;
    }

    @Override
    public AccessType canGetAttributes(Subject subject, FileAttributes parentAttrs, FileAttributes attrs, Set<FileAttribute> attributes) {
        boolean allAllowed = true;
        for (FileAttribute attribute : attributes) {
            AccessType res = this.canGetAttribute(subject, parentAttrs, attrs, attribute);
            switch (res) {
                case ACCESS_DENIED: {
                    return AccessType.ACCESS_DENIED;
                }
                case ACCESS_UNDEFINED: {
                    allAllowed = false;
                    break;
                }
            }
        }
        return allAllowed ? AccessType.ACCESS_ALLOWED : AccessType.ACCESS_UNDEFINED;
    }
}

