/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.namespace;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import javax.security.auth.Subject;
import org.dcache.acl.ACL;
import org.dcache.acl.Owner;
import org.dcache.acl.Permission;
import org.dcache.acl.enums.AccessMask;
import org.dcache.acl.enums.AccessType;
import org.dcache.acl.mapper.AclMapper;
import org.dcache.acl.matcher.AclNFSv4Matcher;
import org.dcache.auth.Origin;
import org.dcache.auth.Subjects;
import org.dcache.namespace.FileAttribute;
import org.dcache.namespace.PermissionHandler;
import org.dcache.vehicles.FileAttributes;

public class ACLPermissionHandler
implements PermissionHandler {
    private Set<FileAttribute> _requiredAttributes = Collections.unmodifiableSet(EnumSet.of(FileAttribute.ACL, FileAttribute.OWNER, FileAttribute.OWNER_GROUP));

    @Override
    public Set<FileAttribute> getRequiredAttributes() {
        return this._requiredAttributes;
    }

    private Permission getPermission(Subject subject, FileAttributes attr) {
        ACL acl = attr.getAcl();
        Owner owner = new Owner(attr.getOwner(), attr.getGroup());
        Origin origin = Subjects.getOrigin((Subject)subject);
        return AclMapper.getPermission((Subject)subject, (Origin)origin, (Owner)owner, (ACL)acl);
    }

    @Override
    public AccessType canReadFile(Subject subject, FileAttributes attr) {
        Permission permission = this.getPermission(subject, attr);
        return AccessType.valueOf((Boolean)AclNFSv4Matcher.isAllowed((Permission)permission, (AccessMask)AccessMask.READ_DATA));
    }

    @Override
    public AccessType canWriteFile(Subject subject, FileAttributes attr) {
        Permission permission = this.getPermission(subject, attr);
        return AccessType.valueOf((Boolean)AclNFSv4Matcher.isAllowed((Permission)permission, (AccessMask)AccessMask.WRITE_DATA));
    }

    @Override
    public AccessType canCreateSubDir(Subject subject, FileAttributes parentAttr) {
        if (parentAttr == null) {
            return AccessType.ACCESS_DENIED;
        }
        Permission permission = this.getPermission(subject, parentAttr);
        return AccessType.valueOf((Boolean)AclNFSv4Matcher.isAllowed((Permission)permission, (AccessMask)AccessMask.ADD_SUBDIRECTORY));
    }

    @Override
    public AccessType canCreateFile(Subject subject, FileAttributes parentAttr) {
        if (parentAttr == null) {
            return AccessType.ACCESS_DENIED;
        }
        Permission permission = this.getPermission(subject, parentAttr);
        return AccessType.valueOf((Boolean)AclNFSv4Matcher.isAllowed((Permission)permission, (AccessMask)AccessMask.ADD_FILE));
    }

    @Override
    public AccessType canDeleteFile(Subject subject, FileAttributes parentAttr, FileAttributes childAttr) {
        if (parentAttr == null) {
            return AccessType.ACCESS_DENIED;
        }
        Permission permissionParent = this.getPermission(subject, parentAttr);
        AccessType ofParent = AccessType.valueOf((Boolean)AclNFSv4Matcher.isAllowed((Permission)permissionParent, (AccessMask)AccessMask.DELETE_CHILD));
        if (ofParent == AccessType.ACCESS_ALLOWED) {
            return ofParent;
        }
        Permission permissionChild = this.getPermission(subject, childAttr);
        AccessType ofChild = AccessType.valueOf((Boolean)AclNFSv4Matcher.isAllowed((Permission)permissionChild, (AccessMask)AccessMask.DELETE));
        if (ofChild == AccessType.ACCESS_ALLOWED) {
            return ofChild;
        }
        if (ofParent == AccessType.ACCESS_DENIED || ofChild == AccessType.ACCESS_DENIED) {
            return AccessType.ACCESS_DENIED;
        }
        return AccessType.ACCESS_UNDEFINED;
    }

    @Override
    public AccessType canDeleteDir(Subject subject, FileAttributes parentAttr, FileAttributes childAttr) {
        return this.canDeleteFile(subject, parentAttr, childAttr);
    }

    @Override
    public AccessType canListDir(Subject subject, FileAttributes attr) {
        Permission permission = this.getPermission(subject, attr);
        return AccessType.valueOf((Boolean)AclNFSv4Matcher.isAllowed((Permission)permission, (AccessMask)AccessMask.LIST_DIRECTORY));
    }

    @Override
    public AccessType canLookup(Subject subject, FileAttributes attr) {
        Permission permission = this.getPermission(subject, attr);
        return AccessType.valueOf((Boolean)AclNFSv4Matcher.isAllowed((Permission)permission, (AccessMask)AccessMask.EXECUTE));
    }

    @Override
    public AccessType canRename(Subject subject, FileAttributes parentAttr, FileAttributes newParentAttr, boolean isDirectory) {
        if (parentAttr == null || newParentAttr == null) {
            return AccessType.ACCESS_DENIED;
        }
        Permission permission1 = this.getPermission(subject, parentAttr);
        Permission permission2 = this.getPermission(subject, newParentAttr);
        Boolean ofSrcParent = AclNFSv4Matcher.isAllowed((Permission)permission1, (AccessMask)AccessMask.DELETE_CHILD);
        Boolean ofDestParent = AclNFSv4Matcher.isAllowed((Permission)permission2, (AccessMask)AccessMask.ADD_FILE);
        if (ofDestParent == ofSrcParent) {
            return AccessType.valueOf((Boolean)ofSrcParent);
        }
        if (AccessType.valueOf((Boolean)ofSrcParent) == AccessType.ACCESS_DENIED || AccessType.valueOf((Boolean)ofDestParent) == AccessType.ACCESS_DENIED) {
            return AccessType.ACCESS_DENIED;
        }
        return AccessType.ACCESS_UNDEFINED;
    }

    @Override
    public AccessType canSetAttributes(Subject subject, FileAttributes parentAttr, FileAttributes attr, Set<FileAttribute> attributes) {
        Permission permission = this.getPermission(subject, attr);
        return this.canSetAttributes(permission, attributes);
    }

    @Override
    public AccessType canGetAttributes(Subject subject, FileAttributes parentAttr, FileAttributes attr, Set<FileAttribute> attributes) {
        Permission permission = this.getPermission(subject, attr);
        return this.canGetAttributes(permission, attributes);
    }

    private AccessType canGetAttributes(Permission permission, Set<FileAttribute> attributes) {
        if (attributes.contains((Object)FileAttribute.ACL)) {
            return AccessType.valueOf((Boolean)AclNFSv4Matcher.isAllowed((Permission)permission, (AccessMask)AccessMask.READ_ACL));
        }
        return AccessType.valueOf((Boolean)AclNFSv4Matcher.isAllowed((Permission)permission, (AccessMask)AccessMask.READ_ATTRIBUTES));
    }

    private AccessType canSetAttributes(Permission permission, Set<FileAttribute> attributes) {
        if (attributes.contains((Object)FileAttribute.ACL)) {
            return AccessType.valueOf((Boolean)AclNFSv4Matcher.isAllowed((Permission)permission, (AccessMask)AccessMask.WRITE_ACL));
        }
        return AccessType.valueOf((Boolean)AclNFSv4Matcher.isAllowed((Permission)permission, (AccessMask)AccessMask.WRITE_ATTRIBUTES));
    }
}

