/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.missingfiles.plugins;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import dmg.cells.nucleus.EnvironmentAware;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.ServiceLoader;
import org.dcache.commons.util.NDC;
import org.dcache.missingfiles.plugins.Plugin;
import org.dcache.missingfiles.plugins.PluginFactory;
import org.dcache.missingfiles.plugins.PluginVisitor;
import org.dcache.util.ConfigurationProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;

public class PluginChain
implements EnvironmentAware {
    private static final Logger _log = LoggerFactory.getLogger(PluginChain.class);
    private static final ServiceLoader<PluginFactory> _factories = ServiceLoader.load(PluginFactory.class);
    private final List<PluginInstance> _plugins = new ArrayList<PluginInstance>();
    private String _pluginList;
    private final ConfigurationProperties _properties = new ConfigurationProperties();
    private static final Function<PluginFactory, String> getName = new Function<PluginFactory, String>(){

        public String apply(PluginFactory factory) {
            return factory.getName();
        }
    };

    @Required
    public void setPluginList(String plugins) {
        this._pluginList = plugins;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        this._plugins.clear();
        Splitter splitter = Splitter.on((char)',').trimResults().omitEmptyStrings();
        for (String name : splitter.split((CharSequence)this._pluginList)) {
            NDC ndc = NDC.cloneNdc();
            NDC.push((String)name);
            try {
                this.createPlugin(name);
            }
            finally {
                NDC.set((NDC)ndc);
            }
        }
    }

    private void createPlugin(String name) {
        try {
            PluginFactory factory = (PluginFactory)Iterables.find(_factories, (Predicate)Predicates.compose((Predicate)Predicates.equalTo((Object)name), getName));
            Plugin plugin = factory.createPlugin(this._properties);
            PluginInstance pi = new PluginInstance(name, plugin);
            this._plugins.add(pi);
        }
        catch (NoSuchElementException e) {
            _log.error("Unknown plugin");
        }
        catch (RuntimeException e) {
            _log.error("Failed to instantiate plugin: {}", (Object)e.getMessage());
        }
    }

    @Required
    public void setEnvironment(Map<String, Object> environment) {
        this._properties.clear();
        for (Map.Entry<String, Object> entry : environment.entrySet()) {
            Object value = entry.getValue();
            this._properties.put(entry.getKey(), value == null ? null : value.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void accept(PluginVisitor visitor) {
        for (PluginInstance pi : this._plugins) {
            NDC ndc = NDC.cloneNdc();
            NDC.push((String)pi.getName());
            try {
                if (visitor.visit(pi.getPlugin())) continue;
                break;
            }
            finally {
                NDC.set((NDC)ndc);
            }
        }
    }

    private static class PluginInstance {
        private final Plugin _plugin;
        private final String _name;

        PluginInstance(String name, Plugin plugin) {
            this._plugin = plugin;
            this._name = name;
        }

        public String getName() {
            return this._name;
        }

        public Plugin getPlugin() {
            return this._plugin;
        }
    }
}

