/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.missingfiles;

import dmg.cells.nucleus.Reply;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.dcache.cells.CellMessageReceiver;
import org.dcache.cells.MessageReply;
import org.dcache.missingfiles.Action;
import org.dcache.missingfiles.MissingFileMessage;
import org.dcache.missingfiles.RemoteMissingFileStrategy;
import org.dcache.missingfiles.plugins.Plugin;
import org.dcache.missingfiles.plugins.PluginChain;
import org.dcache.missingfiles.plugins.PluginVisitor;
import org.dcache.missingfiles.plugins.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;

public class MissingFileHandler
implements CellMessageReceiver {
    private static final Logger _log = LoggerFactory.getLogger(RemoteMissingFileStrategy.class);
    private ExecutorService _executor;
    private PluginChain _chain;

    public Reply messageArrived(MissingFileMessage message) {
        _log.debug("Received notice {} {}", (Object)message.getRequestedPath(), (Object)message.getInternalPath());
        MessageReply<MissingFileMessage> reply = new MessageReply<MissingFileMessage>();
        Request request = new Request(message, reply);
        this._executor.submit(request);
        return reply;
    }

    @Required
    public void setPluginChain(PluginChain chain) {
        this._chain = chain;
    }

    @Required
    public void setExecutorService(ExecutorService service) {
        this._executor = service;
    }

    private static Action actionFor(Result result) {
        switch (result) {
            case FAIL: {
                return Action.FAIL;
            }
            case RETRY: {
                return Action.RETRY;
            }
        }
        throw new IllegalArgumentException("No Action for Result." + (Object)((Object)result));
    }

    private static boolean isTerminalResult(Result result) {
        switch (result) {
            case FAIL: 
            case RETRY: {
                return true;
            }
        }
        return false;
    }

    public class Request
    implements PluginVisitor,
    Runnable {
        private final MissingFileMessage _msg;
        private final MessageReply<MissingFileMessage> _reply;
        private final String _id = UUID.randomUUID().toString();

        public Request(MissingFileMessage msg, MessageReply<MissingFileMessage> reply) {
            this._msg = msg;
            this._reply = reply;
        }

        public String getId() {
            return this._id;
        }

        @Override
        public void run() {
            MissingFileHandler.this._chain.accept(this);
            this.replyWith(Action.FAIL);
        }

        @Override
        public boolean visit(Plugin plugin) {
            Result result;
            Future<Result> future = plugin.accept(this._msg.getSubject(), this._msg.getRequestedPath(), this._msg.getInternalPath());
            try {
                result = future.get();
            }
            catch (CancellationException e) {
                _log.debug("Operation was cancelled");
                return false;
            }
            catch (InterruptedException e) {
                _log.debug("Interrupted while waiting for plugin result");
                return false;
            }
            catch (ExecutionException e) {
                Throwable t = e.getCause();
                _log.error("Plugin bug: " + t.getMessage(), t);
                return true;
            }
            if (MissingFileHandler.isTerminalResult(result)) {
                Action action = MissingFileHandler.actionFor(result);
                this.replyWith(action);
                return false;
            }
            return true;
        }

        private void replyWith(Action action) {
            this._msg.setAction(action);
            this._reply.reply(this._msg);
        }
    }
}

