/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.http;

import java.nio.ByteBuffer;
import org.dcache.pool.repository.RepositoryChannel;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.handler.stream.ChunkedInput;

public class ReusableChunkedNioFile
implements ChunkedInput {
    private final RepositoryChannel _channel;
    private final long _endOffset;
    private final int _chunkSize;
    private volatile long _offset;

    public ReusableChunkedNioFile(RepositoryChannel channel, long offset, long length, int chunkSize) {
        if (channel == null) {
            throw new NullPointerException("Channel must not be null");
        }
        if (offset < 0L) {
            throw new IllegalArgumentException("offset: " + offset + " (expected: 0 or greater)");
        }
        if (length < 0L) {
            throw new IllegalArgumentException("length: " + length + " (expected: 0 or greater)");
        }
        if (chunkSize <= 0) {
            throw new IllegalArgumentException("chunkSize: " + chunkSize + " (expected: 1 or greater)");
        }
        this._channel = channel;
        this._chunkSize = chunkSize;
        this._offset = offset;
        this._endOffset = this._offset + length;
    }

    public void close() throws Exception {
    }

    public boolean hasNextChunk() throws Exception {
        return this._offset < this._endOffset && this._channel.isOpen();
    }

    public boolean isEndOfInput() throws Exception {
        return !this.hasNextChunk();
    }

    public Object nextChunk() throws Exception {
        int localReadBytes;
        long offset = this._offset;
        if (this._offset >= this._endOffset) {
            return null;
        }
        int chunkSize = (int)Math.min((long)this._chunkSize, this._endOffset - offset);
        byte[] chunkArray = new byte[chunkSize];
        ByteBuffer chunk = ByteBuffer.wrap(chunkArray);
        int readBytes = 0;
        while ((localReadBytes = this._channel.read(chunk, this._offset)) >= 0 && (readBytes += localReadBytes) != chunkSize) {
        }
        this._offset += (long)readBytes;
        return ChannelBuffers.wrappedBuffer((byte[])chunkArray);
    }

    RepositoryChannel getChannel() {
        return this._channel;
    }

    long getEndOffset() {
        return this._endOffset;
    }

    long getOffset() {
        return this._offset;
    }
}

