/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.http;

import com.google.common.base.Strings;
import diskCacheV111.util.CacheException;
import diskCacheV111.util.ChecksumFactory;
import diskCacheV111.util.DiskErrorCacheException;
import diskCacheV111.vehicles.HttpDoorUrlInfoMessage;
import diskCacheV111.vehicles.HttpProtocolInfo;
import diskCacheV111.vehicles.PoolIoFileMessage;
import dmg.cells.nucleus.CellAddressCore;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.CellPath;
import dmg.cells.nucleus.NoRouteToCellException;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.CompletionHandler;
import java.security.NoSuchAlgorithmException;
import java.util.UUID;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.dcache.cells.AbstractCellComponent;
import org.dcache.http.HttpMover;
import org.dcache.http.HttpPoolNettyServer;
import org.dcache.pool.FaultAction;
import org.dcache.pool.FaultEvent;
import org.dcache.pool.FaultListener;
import org.dcache.pool.classic.Cancellable;
import org.dcache.pool.classic.ChecksumModule;
import org.dcache.pool.classic.PostTransferService;
import org.dcache.pool.classic.TransferService;
import org.dcache.pool.movers.Mover;
import org.dcache.pool.movers.MoverChannel;
import org.dcache.pool.movers.MoverFactory;
import org.dcache.pool.repository.ReplicaDescriptor;
import org.dcache.util.NetworkUtils;
import org.dcache.util.TryCatchTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;

public class HttpTransferService
extends AbstractCellComponent
implements MoverFactory,
TransferService<HttpMover> {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpTransferService.class);
    public static final String UUID_QUERY_PARAM = "dcache-http-uuid";
    private static final String QUERY_PARAM_ASSIGN = "=";
    private static final String PROTOCOL_HTTP = "http";
    private PostTransferService postTransferService;
    private FaultListener faultListener;
    private ChecksumModule checksumModule;
    private long connectTimeout;
    private int diskThreads;
    private int maxMemoryPerConnection;
    private int maxMemory;
    private int chunkSize;
    private long clientIdleTimeout;
    private Integer socketThreads;
    private HttpPoolNettyServer server;

    @Required
    public void setPostTransferService(PostTransferService postTransferService) {
        this.postTransferService = postTransferService;
    }

    @Required
    public void setFaultListener(FaultListener faultListener) {
        this.faultListener = faultListener;
    }

    @Required
    public void setChecksumModule(ChecksumModule checksumModule) {
        this.checksumModule = checksumModule;
    }

    public long getConnectTimeout() {
        return this.connectTimeout;
    }

    @Required
    public void setConnectTimeout(long connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public int getDiskThreads() {
        return this.diskThreads;
    }

    @Required
    public void setDiskThreads(int diskThreads) {
        this.diskThreads = diskThreads;
    }

    public int getMaxMemoryPerConnection() {
        return this.maxMemoryPerConnection;
    }

    @Required
    public void setMaxMemoryPerConnection(int maxMemoryPerConnection) {
        this.maxMemoryPerConnection = maxMemoryPerConnection;
    }

    public int getMaxMemory() {
        return this.maxMemory;
    }

    @Required
    public void setMaxMemory(int maxMemory) {
        this.maxMemory = maxMemory;
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    @Required
    public void setChunkSize(int chunkSize) {
        this.chunkSize = chunkSize;
    }

    public long getClientIdleTimeout() {
        return this.clientIdleTimeout;
    }

    @Required
    public void setClientIdleTimeout(long clientIdleTimeout) {
        this.clientIdleTimeout = clientIdleTimeout;
    }

    public String getSocketThreads() {
        return this.socketThreads == null ? null : String.valueOf(this.socketThreads);
    }

    public void setSocketThreads(String socketThreads) {
        this.socketThreads = Strings.isNullOrEmpty((String)socketThreads) ? null : Integer.valueOf(socketThreads);
    }

    @PostConstruct
    public synchronized void init() {
        this.server = this.socketThreads == null ? new HttpPoolNettyServer(this.diskThreads, this.maxMemoryPerConnection, this.maxMemory, this.chunkSize, this.clientIdleTimeout) : new HttpPoolNettyServer(this.diskThreads, this.maxMemoryPerConnection, this.maxMemory, this.chunkSize, this.clientIdleTimeout, this.socketThreads);
    }

    @PreDestroy
    public synchronized void shutdown() {
        if (this.server != null) {
            this.server.shutdown();
        }
    }

    @Override
    public Mover<?> createMover(ReplicaDescriptor handle, PoolIoFileMessage message, CellPath pathToDoor) throws CacheException {
        ChecksumFactory checksumFactory;
        if (this.checksumModule.hasPolicy(ChecksumModule.PolicyFlag.ON_TRANSFER)) {
            try {
                checksumFactory = this.checksumModule.getPreferredChecksumFactory(handle);
            }
            catch (NoSuchAlgorithmException e) {
                throw new CacheException("Failed to instantiate HTTP mover due to unsupported checksum type: " + e.getMessage(), e);
            }
        } else {
            checksumFactory = null;
        }
        return new HttpMover(handle, message, pathToDoor, this, this.postTransferService, checksumFactory);
    }

    @Override
    public Cancellable execute(final HttpMover mover, CompletionHandler<Void, Void> completionHandler) throws Exception {
        return new TryCatchTemplate<Void, Void>(completionHandler){

            @Override
            public void execute() throws IOException, CacheException, NoRouteToCellException {
                UUID uuid = UUID.randomUUID();
                MoverChannel channel = this.autoclose(mover.open());
                this.setCancellable(HttpTransferService.this.server.register(channel, uuid, HttpTransferService.this.connectTimeout, this));
                HttpTransferService.this.sendAddressToDoor(mover, HttpTransferService.this.server.getServerAddress().getPort(), uuid);
            }

            @Override
            public void onFailure(Throwable t, Void attachment) throws CacheException {
                if (t instanceof DiskErrorCacheException) {
                    HttpTransferService.this.faultListener.faultOccurred(new FaultEvent("repository", FaultAction.DISABLED, t.getMessage(), t));
                } else if (t instanceof NoRouteToCellException) {
                    throw new CacheException("Failed to send redirect message to door: " + t.getMessage(), t);
                }
            }
        };
    }

    private void sendAddressToDoor(HttpMover mover, int port, UUID uuid) throws SocketException, CacheException, NoRouteToCellException {
        String uri;
        HttpProtocolInfo protocolInfo = (HttpProtocolInfo)mover.getProtocolInfo();
        try {
            uri = this.getUri(protocolInfo, port, uuid).toASCIIString();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Failed to create URI for HTTP mover. Please report to support@dcache.org", e);
        }
        CellAddressCore httpDoor = new CellAddressCore(protocolInfo.getHttpDoorCellName(), protocolInfo.getHttpDoorDomainName());
        LOGGER.debug("Sending redirect URI {}\u00a0to {}", (Object)uri, (Object)httpDoor);
        HttpDoorUrlInfoMessage httpDoorMessage = new HttpDoorUrlInfoMessage(mover.getFileAttributes().getPnfsId().getId(), uri);
        httpDoorMessage.setId(protocolInfo.getSessionId());
        this.sendMessage(new CellMessage(new CellPath(httpDoor), (Serializable)httpDoorMessage));
    }

    private URI getUri(HttpProtocolInfo protocolInfo, int port, UUID uuid) throws SocketException, CacheException, URISyntaxException {
        String path = protocolInfo.getPath();
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        InetAddress localIP = NetworkUtils.getLocalAddress((InetAddress)protocolInfo.getSocketAddress().getAddress());
        return new URI(PROTOCOL_HTTP, null, localIP.getCanonicalHostName(), port, path, "dcache-http-uuid=" + uuid.toString(), null);
    }
}

