/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.http;

import diskCacheV111.util.HttpByteRange;
import dmg.util.HttpException;
import java.nio.channels.ClosedChannelException;
import java.nio.charset.Charset;
import java.util.List;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.handler.codec.frame.TooLongFrameException;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpChunk;
import org.jboss.netty.handler.codec.http.HttpHeaders;
import org.jboss.netty.handler.codec.http.HttpMessage;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.jboss.netty.handler.timeout.IdleStateAwareChannelHandler;
import org.jboss.netty.util.CharsetUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRequestHandler
extends IdleStateAwareChannelHandler {
    protected static final String CRLF = "\r\n";
    private static final Logger _logger = LoggerFactory.getLogger(HttpRequestHandler.class);
    private boolean _isKeepAlive;

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent event) {
        if (event.getMessage() instanceof HttpRequest) {
            HttpRequest request = (HttpRequest)event.getMessage();
            this._isKeepAlive = HttpHeaders.isKeepAlive((HttpMessage)request);
            if (request.getMethod() == HttpMethod.GET) {
                this.doOnGet(ctx, event, request);
            } else if (request.getMethod() == HttpMethod.PUT) {
                this.doOnPut(ctx, event, request);
            } else if (request.getMethod() == HttpMethod.POST) {
                this.doOnPost(ctx, event, request);
            } else if (request.getMethod() == HttpMethod.DELETE) {
                this.doOnDelete(ctx, event, request);
            } else {
                HttpRequestHandler.unsupported(ctx, event);
            }
        } else if (event.getMessage() instanceof HttpChunk) {
            this.doOnChunk(ctx, event, (HttpChunk)event.getMessage());
        }
    }

    protected void doOnGet(ChannelHandlerContext context, MessageEvent event, HttpRequest request) {
        _logger.info("Received a GET request, writing a default response.");
        HttpRequestHandler.unsupported(context, event);
    }

    protected void doOnPut(ChannelHandlerContext context, MessageEvent event, HttpRequest request) {
        _logger.info("Received a PUT request, writing a default response.");
        HttpRequestHandler.unsupported(context, event);
    }

    protected void doOnPost(ChannelHandlerContext context, MessageEvent event, HttpRequest request) {
        _logger.info("Received a POST request, writing default response.");
        HttpRequestHandler.unsupported(context, event);
    }

    protected void doOnDelete(ChannelHandlerContext context, MessageEvent event, HttpRequest request) {
        _logger.info("Received a DELETE request, writing default response.");
        HttpRequestHandler.unsupported(context, event);
    }

    protected void doOnChunk(ChannelHandlerContext context, MessageEvent event, HttpChunk chunk) {
        _logger.info("Received an HTTP chunk, writing default response.");
        HttpRequestHandler.unsupported(context, event);
    }

    protected static ChannelFuture sendHTTPError(ChannelHandlerContext context, HttpResponseStatus statusCode, String message) {
        _logger.info("Sending error {} with message {} to client.", (Object)statusCode, (Object)message);
        if (message == null || message.isEmpty()) {
            message = "An unexpected server error has occurred.";
        }
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, statusCode);
        response.setHeader("Content-Type", (Object)"text/plain; charset=UTF-8");
        response.setContent(ChannelBuffers.copiedBuffer((CharSequence)(message + CRLF), (Charset)CharsetUtil.UTF_8));
        HttpHeaders.setContentLength((HttpMessage)response, (long)response.getContent().readableBytes());
        return context.getChannel().write((Object)response);
    }

    protected static ChannelFuture sendFatalError(ChannelHandlerContext context, HttpResponseStatus statusCode, String message) {
        _logger.info("Sending error {} with message {} to client.", (Object)statusCode, (Object)message);
        if (message == null || message.isEmpty()) {
            message = "An unexpected server error has occurred.";
        }
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, statusCode);
        response.setHeader("Content-Type", (Object)"text/plain; charset=UTF-8");
        response.setHeader("Connection", (Object)"close");
        response.setContent(ChannelBuffers.copiedBuffer((CharSequence)(message + CRLF), (Charset)CharsetUtil.UTF_8));
        HttpHeaders.setContentLength((HttpMessage)response, (long)response.getContent().readableBytes());
        ChannelFuture future = context.getChannel().write((Object)response);
        future.addListener(ChannelFutureListener.CLOSE);
        return future;
    }

    protected static ChannelFuture unsupported(ChannelHandlerContext context, MessageEvent event) {
        return HttpRequestHandler.sendHTTPError(context, HttpResponseStatus.NOT_IMPLEMENTED, "The requested operation is not supported by dCache");
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent event) {
        Throwable t = event.getCause();
        if (t instanceof TooLongFrameException) {
            HttpRequestHandler.sendFatalError(ctx, HttpResponseStatus.BAD_REQUEST, "Max request length exceeded");
        } else if (event.getChannel().isConnected()) {
            event.getChannel().close();
        }
        if (t instanceof ClosedChannelException) {
            _logger.trace("ClosedChannelException for HTTP channel to {}", (Object)ctx.getChannel().getRemoteAddress());
        } else if (t instanceof RuntimeException || t instanceof Error) {
            Thread me = Thread.currentThread();
            me.getUncaughtExceptionHandler().uncaughtException(me, t);
        } else {
            _logger.warn(t.toString());
        }
    }

    protected boolean isKeepAlive() {
        return this._isKeepAlive;
    }

    protected List<HttpByteRange> parseHttpRange(HttpRequest request, long lowerRange, long upperRange) throws HttpException {
        block3: {
            String rangeHeader = request.getHeader("Range");
            if (rangeHeader != null) {
                try {
                    return HttpByteRange.parseRanges(rangeHeader, lowerRange, upperRange);
                }
                catch (HttpException e) {
                    if (request.getHeader("If-Range") != null) break block3;
                    throw e;
                }
            }
        }
        return null;
    }
}

