/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.http;

import com.google.common.base.CharMatcher;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import diskCacheV111.util.FsPath;
import diskCacheV111.util.HttpByteRange;
import diskCacheV111.vehicles.HttpProtocolInfo;
import dmg.util.HttpException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.dcache.http.HttpPoolNettyServer;
import org.dcache.http.HttpRequestHandler;
import org.dcache.http.ReusableChunkedNioFile;
import org.dcache.namespace.FileAttribute;
import org.dcache.pool.movers.IoMode;
import org.dcache.pool.movers.MoverChannel;
import org.dcache.pool.repository.RepositoryChannel;
import org.dcache.util.Checksum;
import org.dcache.util.Checksums;
import org.dcache.util.StringMarkup;
import org.dcache.vehicles.FileAttributes;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpChunk;
import org.jboss.netty.handler.codec.http.HttpChunkTrailer;
import org.jboss.netty.handler.codec.http.HttpHeaders;
import org.jboss.netty.handler.codec.http.HttpMessage;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.jboss.netty.handler.codec.http.QueryStringDecoder;
import org.jboss.netty.handler.stream.ChunkedInput;
import org.jboss.netty.handler.timeout.IdleState;
import org.jboss.netty.handler.timeout.IdleStateEvent;
import org.jboss.netty.util.CharsetUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpPoolRequestHandler
extends HttpRequestHandler {
    private static final Logger _logger = LoggerFactory.getLogger(HttpPoolRequestHandler.class);
    private static final String DIGEST = "Digest";
    private static final String RANGE_SEPARATOR = "-";
    private static final String RANGE_PRE_TOTAL = "/";
    private static final String RANGE_SP = " ";
    private static final String BOUNDARY = "__AAAAAAAAAAAAAAAA__";
    private static final String MULTIPART_TYPE = "multipart/byteranges; boundary=\"__AAAAAAAAAAAAAAAA__\"";
    private static final CharMatcher TSPECIAL = CharMatcher.anyOf((CharSequence)"()<>@,;:\\\"/[]?=");
    private static final ChannelBuffer CONTINUE = ChannelBuffers.copiedBuffer((CharSequence)"HTTP/1.1 100 Continue\r\n\r\n", (Charset)CharsetUtil.US_ASCII);
    private final Multiset<MoverChannel<HttpProtocolInfo>> _files = HashMultiset.create();
    private final HttpPoolNettyServer _server;
    private final int _chunkSize;
    private MoverChannel<HttpProtocolInfo> _writeChannel;

    public HttpPoolRequestHandler(HttpPoolNettyServer server, int chunkSize) {
        this._server = server;
        this._chunkSize = chunkSize;
    }

    private static ChannelFuture sendPartialHeader(ChannelHandlerContext context, long lower, long upper, long total, String digest) {
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.PARTIAL_CONTENT);
        String contentRange = "bytes " + lower + RANGE_SEPARATOR + upper + RANGE_PRE_TOTAL + total;
        response.setHeader("Accept-Ranges", (Object)"bytes");
        response.setHeader("Content-Length", (Object)String.valueOf(upper - lower + 1L));
        response.setHeader("Content-Range", (Object)contentRange);
        if (!digest.isEmpty()) {
            response.setHeader(DIGEST, (Object)digest);
        }
        return context.getChannel().write((Object)response);
    }

    private static ChannelFuture sendMultipartHeader(ChannelHandlerContext context, String digest) {
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.PARTIAL_CONTENT);
        response.setHeader("Accept-Ranges", (Object)"bytes");
        response.setHeader("Content-Type", (Object)MULTIPART_TYPE);
        if (!digest.isEmpty()) {
            response.setHeader(DIGEST, (Object)digest);
        }
        return context.getChannel().write((Object)response);
    }

    private static ChannelFuture sendMultipartFragment(ChannelHandlerContext context, long lower, long upper, long total) {
        StringBuilder sb = new StringBuilder(64);
        sb.append("\r\n");
        sb.append("--").append(BOUNDARY).append("\r\n");
        sb.append("Content-Length").append(": ").append(upper - lower + 1L).append("\r\n");
        sb.append("Content-Range").append(": ").append("bytes").append(RANGE_SP).append(lower).append(RANGE_SEPARATOR).append(upper).append(RANGE_PRE_TOTAL).append(total).append("\r\n");
        sb.append("\r\n");
        ChannelBuffer buffer = ChannelBuffers.copiedBuffer((CharSequence)sb, (Charset)CharsetUtil.UTF_8);
        return context.getChannel().write((Object)buffer);
    }

    private static ChannelFuture sendMultipartEnd(ChannelHandlerContext context) {
        StringBuilder sb = new StringBuilder(64);
        sb.append("\r\n");
        sb.append("--").append(BOUNDARY).append("--").append("\r\n");
        ChannelBuffer buffer = ChannelBuffers.copiedBuffer((CharSequence)sb, (Charset)CharsetUtil.UTF_8);
        return context.getChannel().write((Object)buffer);
    }

    private static ChannelFuture sendGetResponse(ChannelHandlerContext context, MoverChannel<HttpProtocolInfo> file) throws IOException {
        FsPath path = new FsPath(file.getProtocolInfo().getPath());
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        response.setHeader("Content-Length", (Object)file.size());
        String digest = HttpPoolRequestHandler.buildDigest(file);
        if (!digest.isEmpty()) {
            response.setHeader(DIGEST, (Object)digest);
        }
        response.setHeader("Content-Disposition", (Object)HttpPoolRequestHandler.contentDisposition(path.getName()));
        if (file.getProtocolInfo().getLocation() != null) {
            response.setHeader("Content-Location", (Object)file.getProtocolInfo().getLocation());
        }
        return context.getChannel().write((Object)response);
    }

    private static String contentDisposition(String filename) {
        StringBuilder sb = new StringBuilder();
        sb.append("attachment");
        HttpPoolRequestHandler.appendDispositionParm(sb, "filename", filename);
        return sb.toString();
    }

    private static void appendDispositionParm(StringBuilder sb, String name, String value) {
        sb.append(';');
        if (value.length() > 78 || !CharMatcher.ASCII.matchesAllOf((CharSequence)value)) {
            HttpPoolRequestHandler.appendUsingRfc2231Encoding(sb, name, "UTF-8", null, value);
        } else if (TSPECIAL.matchesAnyOf((CharSequence)value)) {
            HttpPoolRequestHandler.appendAsQuotedString(sb, name, value);
        } else {
            sb.append(name).append("=").append(value);
        }
    }

    private static void appendAsQuotedString(StringBuilder sb, String name, String value) {
        sb.append(name).append("=");
        StringMarkup.quotedString((StringBuilder)sb, (String)value);
    }

    private static void appendUsingRfc2231Encoding(StringBuilder sb, String name, String charSet, String language, String value) {
        sb.append(name).append("*=");
        if (charSet != null) {
            sb.append(charSet);
        }
        sb.append('\'');
        if (language != null) {
            sb.append(language);
        }
        sb.append('\'');
        StringMarkup.percentEncode((StringBuilder)sb, (String)value);
    }

    private static void checkContentHeader(Collection<String> headerNames, Collection<String> excludes) throws HttpException {
        block0: for (String headerName : headerNames) {
            if (!headerName.toLowerCase().startsWith("content-")) continue;
            for (String exclude : excludes) {
                if (!exclude.equalsIgnoreCase(headerName)) continue;
                continue block0;
            }
            throw new HttpException(HttpResponseStatus.NOT_IMPLEMENTED.getCode(), headerName + " is not implemented");
        }
    }

    private static ChannelFuture sendPutResponse(ChannelHandlerContext ctx, MoverChannel<HttpProtocolInfo> file) throws IOException {
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.CREATED);
        response.setContent(ChannelBuffers.copiedBuffer((CharSequence)(String.valueOf(file.size()) + " bytes uploaded\r\n"), (Charset)CharsetUtil.UTF_8));
        HttpHeaders.setContentLength((HttpMessage)response, (long)response.getContent().readableBytes());
        HttpHeaders.setHeader((HttpMessage)response, (String)"Content-Type", (Object)"text/plain; charset=UTF-8");
        if (file.getProtocolInfo().getLocation() != null) {
            HttpHeaders.setHeader((HttpMessage)response, (String)"Location", (Object)file.getProtocolInfo().getLocation());
        }
        return ctx.getChannel().write((Object)response);
    }

    private static ChannelFuture conditionalSendError(ChannelHandlerContext ctx, HttpMethod method, ChannelFuture future, HttpResponseStatus statusCode, String message) {
        if (future == null) {
            return HttpPoolRequestHandler.sendHTTPError(ctx, statusCode, message);
        }
        _logger.warn("Failure in HTTP {}: {}", (Object)method, (Object)message);
        ctx.getChannel().close();
        return null;
    }

    public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        _logger.debug("HTTP connection from {} established", (Object)ctx.getChannel().getRemoteAddress());
    }

    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent event) {
        _logger.debug("HTTP connection from {} closed", (Object)ctx.getChannel().getRemoteAddress());
        for (MoverChannel file : this._files) {
            this._server.close(file);
        }
        this._files.clear();
    }

    public void channelIdle(ChannelHandlerContext ctx, IdleStateEvent event) throws Exception {
        if (event.getState() == IdleState.ALL_IDLE) {
            if (_logger.isInfoEnabled()) {
                long idleTime = System.currentTimeMillis() - event.getLastActivityTimeMillis();
                _logger.info("Connection from {} has been idle for {} ms; disconnecting.", (Object)ctx.getChannel().getRemoteAddress(), (Object)idleTime);
            }
            ctx.getChannel().close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doOnGet(ChannelHandlerContext context, MessageEvent event, HttpRequest request) {
        ChannelFuture future = null;
        try {
            MoverChannel<HttpProtocolInfo> file = this.open(request, false);
            if (file.getIoMode() != IoMode.READ) {
                throw new HttpException(HttpResponseStatus.METHOD_NOT_ALLOWED.getCode(), "Resource is not open for reading");
            }
            long fileSize = file.size();
            List<HttpByteRange> ranges = this.parseHttpRange(request, 0L, fileSize - 1L);
            if (ranges == null || ranges.isEmpty()) {
                ChunkedInput responseContent = this.read(file);
                future = HttpPoolRequestHandler.sendGetResponse(context, file);
                future = event.getChannel().write((Object)responseContent);
            } else if (ranges.size() == 1) {
                HttpByteRange range = ranges.get(0);
                future = HttpPoolRequestHandler.sendPartialHeader(context, range.getLower(), range.getUpper(), fileSize, HttpPoolRequestHandler.buildDigest(file));
                ChunkedInput responseContent = this.read(file, range.getLower(), range.getUpper());
                future = event.getChannel().write((Object)responseContent);
            } else {
                future = HttpPoolRequestHandler.sendMultipartHeader(context, HttpPoolRequestHandler.buildDigest(file));
                for (HttpByteRange range : ranges) {
                    ChunkedInput responseContent = this.read(file, range.getLower(), range.getUpper());
                    HttpPoolRequestHandler.sendMultipartFragment(context, range.getLower(), range.getUpper(), fileSize);
                    event.getChannel().write((Object)responseContent);
                }
                future = HttpPoolRequestHandler.sendMultipartEnd(context);
            }
        }
        catch (HttpException e) {
            future = HttpPoolRequestHandler.conditionalSendError(context, request.getMethod(), future, HttpResponseStatus.valueOf((int)e.getErrorCode()), e.getMessage());
        }
        catch (IOException e) {
            future = HttpPoolRequestHandler.conditionalSendError(context, request.getMethod(), future, HttpResponseStatus.BAD_REQUEST, e.getMessage());
        }
        catch (URISyntaxException e) {
            future = HttpPoolRequestHandler.conditionalSendError(context, request.getMethod(), future, HttpResponseStatus.BAD_REQUEST, "URI not valid: " + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            future = HttpPoolRequestHandler.conditionalSendError(context, request.getMethod(), future, HttpResponseStatus.BAD_REQUEST, e.getMessage());
        }
        catch (RuntimeException e) {
            future = HttpPoolRequestHandler.conditionalSendError(context, request.getMethod(), future, HttpResponseStatus.INTERNAL_SERVER_ERROR, e.getMessage());
        }
        finally {
            if (future != null && !this.isKeepAlive()) {
                future.addListener(ChannelFutureListener.CLOSE);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doOnPut(ChannelHandlerContext context, MessageEvent event, HttpRequest request) {
        ChannelFuture future = null;
        MoverChannel<HttpProtocolInfo> file = null;
        Throwable exception = null;
        try {
            HttpPoolRequestHandler.checkContentHeader(request.getHeaderNames(), Arrays.asList("Content-Length"));
            file = this.open(request, true);
            if (file.getIoMode() != IoMode.WRITE) {
                throw new HttpException(HttpResponseStatus.METHOD_NOT_ALLOWED.getCode(), "Resource is not open for writing");
            }
            if (request.isChunked()) {
                if (HttpHeaders.is100ContinueExpected((HttpMessage)request)) {
                    context.getChannel().write((Object)CONTINUE.duplicate());
                }
                this._writeChannel = file;
                file = null;
            } else {
                long length = this.write(file, request.getContent());
                if (HttpHeaders.getContentLength((HttpMessage)request, (long)length) != length) {
                    throw new HttpException(HttpResponseStatus.BAD_REQUEST.getCode(), "Incomplete entity");
                }
                future = HttpPoolRequestHandler.sendPutResponse(context, file);
            }
        }
        catch (HttpException e) {
            exception = e;
            future = HttpPoolRequestHandler.conditionalSendError(context, request.getMethod(), future, HttpResponseStatus.valueOf((int)e.getErrorCode()), e.getMessage());
        }
        catch (IOException e) {
            exception = e;
            future = HttpPoolRequestHandler.conditionalSendError(context, request.getMethod(), future, HttpResponseStatus.INTERNAL_SERVER_ERROR, e.getMessage());
        }
        catch (URISyntaxException e) {
            exception = e;
            future = HttpPoolRequestHandler.conditionalSendError(context, request.getMethod(), future, HttpResponseStatus.BAD_REQUEST, "URI is not valid: " + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            exception = e;
            future = HttpPoolRequestHandler.conditionalSendError(context, request.getMethod(), future, HttpResponseStatus.BAD_REQUEST, e.getMessage());
        }
        catch (RuntimeException e) {
            exception = e;
            future = HttpPoolRequestHandler.conditionalSendError(context, request.getMethod(), future, HttpResponseStatus.INTERNAL_SERVER_ERROR, e.getMessage());
        }
        finally {
            if (file != null) {
                this.close(file, (Exception)exception);
            }
            if (future != null && (!this.isKeepAlive() || request.isChunked())) {
                future.addListener(ChannelFutureListener.CLOSE);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doOnChunk(ChannelHandlerContext context, MessageEvent event, HttpChunk chunk) {
        if (this._writeChannel != null) {
            Throwable exception = null;
            ChannelFuture future = null;
            try {
                this.write(this._writeChannel, chunk.getContent());
                if (chunk.isLast()) {
                    if (chunk instanceof HttpChunkTrailer) {
                        HttpPoolRequestHandler.checkContentHeader(((HttpChunkTrailer)chunk).getHeaderNames(), Arrays.asList("Content-Length"));
                    }
                    future = HttpPoolRequestHandler.sendPutResponse(context, this._writeChannel);
                }
            }
            catch (IOException e) {
                exception = e;
                future = HttpPoolRequestHandler.conditionalSendError(context, HttpMethod.PUT, future, HttpResponseStatus.INTERNAL_SERVER_ERROR, e.getMessage());
            }
            catch (HttpException e) {
                exception = e;
                future = HttpPoolRequestHandler.conditionalSendError(context, HttpMethod.PUT, future, HttpResponseStatus.valueOf((int)e.getErrorCode()), e.getMessage());
            }
            finally {
                if (chunk.isLast() || exception != null) {
                    this.close(this._writeChannel, (Exception)exception);
                    this._writeChannel = null;
                }
                if (!(future == null || this.isKeepAlive() && chunk.isLast())) {
                    future.addListener(ChannelFutureListener.CLOSE);
                }
            }
        }
    }

    private MoverChannel<HttpProtocolInfo> open(HttpRequest request, boolean exclusive) throws IllegalArgumentException, URISyntaxException {
        FsPath transferFile;
        QueryStringDecoder queryStringDecoder = new QueryStringDecoder(request.getUri());
        Map params = queryStringDecoder.getParameters();
        if (!params.containsKey("dcache-http-uuid")) {
            if (!request.getUri().equals("/favicon.ico")) {
                _logger.error("Received request without UUID in the query string. Request-URI was {}", (Object)request.getUri());
            }
            throw new IllegalArgumentException("Query string does not include any UUID.");
        }
        List uuidList = (List)params.get("dcache-http-uuid");
        if (uuidList.isEmpty()) {
            throw new IllegalArgumentException("UUID parameter does not include any value.");
        }
        UUID uuid = UUID.fromString((String)uuidList.get(0));
        MoverChannel<HttpProtocolInfo> file = this._server.open(uuid, exclusive);
        if (file == null) {
            throw new IllegalArgumentException("Request is no longer valid. Please resubmit to door.");
        }
        URI uri = new URI(request.getUri());
        FsPath requestedFile = new FsPath(uri.getPath());
        if (!requestedFile.equals(transferFile = new FsPath(((HttpProtocolInfo)file.getProtocolInfo()).getPath()))) {
            _logger.warn("Received an illegal request for file {}, while serving {}", (Object)requestedFile, (Object)transferFile);
            throw new IllegalArgumentException("The file you specified does not match the UUID you specified!");
        }
        this._files.add(file);
        return file;
    }

    private void close(MoverChannel<HttpProtocolInfo> channel, Exception exception) {
        this._server.close(channel, exception);
        this._files.remove(channel);
    }

    private ChunkedInput read(MoverChannel<HttpProtocolInfo> file, long lowerRange, long upperRange) {
        long length = upperRange - lowerRange + 1L;
        return new ReusableChunkedNioFile(file, lowerRange, length, this._chunkSize);
    }

    private ChunkedInput read(MoverChannel<HttpProtocolInfo> file) throws IOException {
        return this.read(file, 0L, file.size() - 1L);
    }

    private long write(RepositoryChannel file, ChannelBuffer channelBuffer) throws IOException {
        long bytes = 0L;
        for (ByteBuffer buffer : channelBuffer.toByteBuffers()) {
            while (buffer.hasRemaining()) {
                bytes += (long)file.write(buffer);
            }
        }
        return bytes;
    }

    private static String buildDigest(MoverChannel<HttpProtocolInfo> file) {
        FileAttributes attributes = file.getFileAttributes();
        if (attributes.isDefined(FileAttribute.CHECKSUM)) {
            Set<Checksum> checksums = attributes.getChecksums();
            return Checksums.rfc3230Encoded(checksums);
        }
        return "";
    }
}

