/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.http;

import diskCacheV111.vehicles.HttpProtocolInfo;
import java.util.concurrent.TimeUnit;
import org.dcache.http.HttpPoolRequestHandler;
import org.dcache.pool.movers.AbstractNettyServer;
import org.dcache.util.PortRange;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.handler.codec.http.HttpRequestDecoder;
import org.jboss.netty.handler.codec.http.HttpResponseEncoder;
import org.jboss.netty.handler.execution.ExecutionHandler;
import org.jboss.netty.handler.logging.LoggingHandler;
import org.jboss.netty.handler.stream.ChunkedWriteHandler;
import org.jboss.netty.handler.timeout.IdleStateHandler;
import org.jboss.netty.util.HashedWheelTimer;
import org.jboss.netty.util.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpPoolNettyServer
extends AbstractNettyServer<HttpProtocolInfo> {
    private static final Logger _logger = LoggerFactory.getLogger(HttpPoolNettyServer.class);
    private static final PortRange DEFAULT_PORTRANGE = new PortRange(20000, 25000);
    private final Timer _timer;
    private final long _clientIdleTimeout;
    private final int _chunkSize;

    public HttpPoolNettyServer(int threadPoolSize, int memoryPerConnection, int maxMemory, int chunkSize, long clientIdleTimeout) {
        this(threadPoolSize, memoryPerConnection, maxMemory, chunkSize, clientIdleTimeout, -1);
    }

    public HttpPoolNettyServer(int threadPoolSize, int memoryPerConnection, int maxMemory, int chunkSize, long clientIdleTimeout, int socketThreads) {
        super("http", threadPoolSize, memoryPerConnection, maxMemory, socketThreads);
        this._clientIdleTimeout = clientIdleTimeout;
        this._chunkSize = chunkSize;
        this._timer = new HashedWheelTimer();
        String range = System.getProperty("org.globus.tcp.port.range");
        PortRange portRange = range != null ? PortRange.valueOf(range) : DEFAULT_PORTRANGE;
        this.setPortRange(portRange);
    }

    public void shutdown() {
        this.stopServer();
        this._timer.stop();
    }

    @Override
    protected ChannelPipelineFactory newPipelineFactory() {
        return new HttpPoolPipelineFactory();
    }

    class HttpPoolPipelineFactory
    implements ChannelPipelineFactory {
        HttpPoolPipelineFactory() {
        }

        public ChannelPipeline getPipeline() throws Exception {
            ChannelPipeline pipeline = Channels.pipeline();
            pipeline.addLast("decoder", (ChannelHandler)new HttpRequestDecoder());
            pipeline.addLast("encoder", (ChannelHandler)new HttpResponseEncoder());
            if (_logger.isDebugEnabled()) {
                pipeline.addLast("logger", (ChannelHandler)new LoggingHandler(HttpPoolNettyServer.class));
            }
            pipeline.addLast("executor", (ChannelHandler)new ExecutionHandler(HttpPoolNettyServer.this.getDiskExecutor()));
            pipeline.addLast("idle-state-handler", (ChannelHandler)new IdleStateHandler(HttpPoolNettyServer.this._timer, 0L, 0L, HttpPoolNettyServer.this._clientIdleTimeout, TimeUnit.MILLISECONDS));
            pipeline.addLast("chunkedWriter", (ChannelHandler)new ChunkedWriteHandler());
            pipeline.addLast("transfer", (ChannelHandler)new HttpPoolRequestHandler(HttpPoolNettyServer.this, HttpPoolNettyServer.this._chunkSize));
            return pipeline;
        }
    }
}

