/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.http;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import diskCacheV111.util.ChecksumFactory;
import diskCacheV111.util.DiskErrorCacheException;
import diskCacheV111.vehicles.HttpProtocolInfo;
import diskCacheV111.vehicles.PoolIoFileMessage;
import dmg.cells.nucleus.CellPath;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import org.dcache.http.HttpTransferService;
import org.dcache.pool.classic.PostTransferService;
import org.dcache.pool.movers.ChecksumChannel;
import org.dcache.pool.movers.IoMode;
import org.dcache.pool.movers.MoverChannelMover;
import org.dcache.pool.repository.ReplicaDescriptor;
import org.dcache.pool.repository.RepositoryChannel;
import org.dcache.util.Checksum;

public class HttpMover
extends MoverChannelMover<HttpProtocolInfo, HttpMover> {
    private final ChecksumFactory checksumFactory;
    private ChecksumChannel checksumChannel;

    public HttpMover(ReplicaDescriptor handle, PoolIoFileMessage message, CellPath pathToDoor, HttpTransferService httpTransferService, PostTransferService postTransferService, ChecksumFactory checksumFactory) {
        super(handle, message, pathToDoor, httpTransferService, postTransferService);
        this.checksumFactory = checksumFactory;
    }

    @Override
    public Set<Checksum> getActualChecksums() {
        return this.checksumChannel == null ? Collections.emptySet() : Optional.fromNullable((Object)this.checksumChannel.getChecksum()).asSet();
    }

    @Override
    public Set<Checksum> getExpectedChecksums() {
        return Collections.emptySet();
    }

    @Override
    public synchronized RepositoryChannel openChannel() throws DiskErrorCacheException {
        Preconditions.checkState((this.checksumChannel == null ? 1 : 0) != 0);
        RepositoryChannel channel = super.openChannel();
        try {
            if (this.getIoMode() == IoMode.WRITE && this.checksumFactory != null) {
                this.checksumChannel = new ChecksumChannel(channel, this.checksumFactory);
                channel = this.checksumChannel;
            }
        }
        catch (Throwable t) {
            try {
                channel.close();
            }
            catch (IOException e) {
                t.addSuppressed(e);
            }
            Throwables.propagate((Throwable)t);
        }
        return channel;
    }
}

