/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera.nfsv41.mover;

import diskCacheV111.util.CacheException;
import diskCacheV111.vehicles.PoolIoFileMessage;
import diskCacheV111.vehicles.PoolPassiveIoFileMessage;
import dmg.cells.nucleus.CellPath;
import dmg.util.Args;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.CompletionHandler;
import java.util.List;
import org.dcache.cells.AbstractCellComponent;
import org.dcache.cells.CellCommandListener;
import org.dcache.cells.CellStub;
import org.dcache.chimera.ChimeraFsException;
import org.dcache.chimera.nfs.v4.NFS4Client;
import org.dcache.chimera.nfs.v4.NFSv41Session;
import org.dcache.chimera.nfs.v4.xdr.stateid4;
import org.dcache.chimera.nfsv41.mover.MoverBridge;
import org.dcache.chimera.nfsv41.mover.NFS4ProtocolInfo;
import org.dcache.chimera.nfsv41.mover.NFSv41ProtocolMover;
import org.dcache.chimera.nfsv41.mover.NFSv4MoverHandler;
import org.dcache.pool.classic.Cancellable;
import org.dcache.pool.classic.PostTransferService;
import org.dcache.pool.classic.TransferService;
import org.dcache.pool.movers.ManualMover;
import org.dcache.pool.movers.Mover;
import org.dcache.pool.movers.MoverFactory;
import org.dcache.pool.movers.MoverProtocolMover;
import org.dcache.pool.repository.ReplicaDescriptor;
import org.dcache.pool.repository.RepositoryChannel;
import org.dcache.util.NetworkUtils;
import org.dcache.util.PortRange;
import org.dcache.xdr.OncRpcException;
import org.ietf.jgss.GSSException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;

public class NfsTransferService
extends AbstractCellComponent
implements MoverFactory,
TransferService<MoverProtocolMover>,
CellCommandListener {
    private static final Logger _log = LoggerFactory.getLogger(NfsTransferService.class);
    private NFSv4MoverHandler _nfsIO;
    private boolean _withGss;
    private InetSocketAddress[] _localSocketAddresses;
    private CellStub _door;
    private PostTransferService _postTransferService;
    public static final String hh_nfs_stats = " # show nfs mover statstics";
    public static final String hh_nfs_sessions = " # show nfs sessions";

    public void init() throws ChimeraFsException, IOException, GSSException, OncRpcException {
        String dcachePorts = System.getProperty("org.dcache.net.tcp.portrange");
        PortRange portRange = dcachePorts != null ? PortRange.valueOf(dcachePorts) : new PortRange(0);
        this._nfsIO = new NFSv4MoverHandler(portRange, this._withGss, this.getCellName());
        this._localSocketAddresses = this.localSocketAddresses(NetworkUtils.getLocalAddresses(), this._nfsIO.getLocalAddress().getPort());
        this._door = new CellStub(this.getCellEndpoint());
    }

    @Required
    public void setPostTransferService(PostTransferService postTransferService) {
        this._postTransferService = postTransferService;
    }

    public void shutdown() throws IOException {
        this._nfsIO.shutdown();
    }

    @Override
    public Mover<?> createMover(ReplicaDescriptor handle, PoolIoFileMessage message, CellPath pathToDoor) throws CacheException {
        return new MoverProtocolMover(handle, message, pathToDoor, this, this._postTransferService, new NFSv41ProtocolMover(this.getCellEndpoint()));
    }

    @Override
    public Cancellable execute(MoverProtocolMover transfer, final CompletionHandler<Void, Void> completionHandler) {
        try {
            NFS4ProtocolInfo nfs4ProtocolInfo = (NFS4ProtocolInfo)transfer.getProtocolInfo();
            stateid4 stateid = nfs4ProtocolInfo.stateId();
            final RepositoryChannel repositoryChannel = transfer.openChannel();
            final MoverBridge moverBridge = new MoverBridge((ManualMover)transfer.getMover(), transfer.getFileAttributes().getPnfsId(), stateid, repositoryChannel, transfer.getIoMode(), transfer.getIoHandle());
            this._nfsIO.addHandler(moverBridge);
            CellPath directDoorPath = new CellPath(transfer.getPathToDoor().getDestinationAddress());
            this._door.send(directDoorPath, new PoolPassiveIoFileMessage<stateid4>(this.getCellName(), this._localSocketAddresses, stateid));
            return new Cancellable(){

                @Override
                public void cancel() {
                    NfsTransferService.this._nfsIO.removeHandler(moverBridge);
                    try {
                        repositoryChannel.close();
                    }
                    catch (IOException e) {
                        _log.error("failed to close RAF", (Throwable)e);
                    }
                    completionHandler.completed(null, null);
                }
            };
        }
        catch (Throwable e) {
            completionHandler.failed(e, null);
            return null;
        }
    }

    public void setEnableGss(boolean withGss) {
        this._withGss = withGss;
    }

    private InetSocketAddress[] localSocketAddresses(List<InetAddress> addresses, int port) {
        InetSocketAddress[] socketAddresses = new InetSocketAddress[addresses.size()];
        int i = 0;
        for (InetAddress address : addresses) {
            socketAddresses[i] = new InetSocketAddress(address, port);
            ++i;
        }
        return socketAddresses;
    }

    public String ac_nfs_stats(Args args) {
        StringBuilder sb = new StringBuilder();
        sb.append("Stats:").append("\n").append(this._nfsIO.getNFSServer().getStatistics());
        return sb.toString();
    }

    public String ac_nfs_sessions(Args args) {
        StringBuilder sb = new StringBuilder();
        for (NFS4Client client : this._nfsIO.getNFSServer().getClients()) {
            sb.append(client).append('\n');
            for (NFSv41Session session : client.sessions()) {
                sb.append("  ").append(session).append(" slots (max/used): ").append(session.getHighestSlot()).append('/').append(session.getHighestUsedSlot()).append('\n');
            }
        }
        return sb.toString();
    }
}

