/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera.nfsv41.mover;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.Principal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.security.auth.Subject;
import org.dcache.auth.Subjects;
import org.dcache.chimera.nfs.v4.AbstractNFSv4Operation;
import org.dcache.chimera.nfs.v4.NFSServerV41;
import org.dcache.chimera.nfs.v4.NFSv4OperationFactory;
import org.dcache.chimera.nfs.v4.NfsIdMapping;
import org.dcache.chimera.nfs.v4.OperationBIND_CONN_TO_SESSION;
import org.dcache.chimera.nfs.v4.OperationCOMMIT;
import org.dcache.chimera.nfs.v4.OperationCREATE_SESSION;
import org.dcache.chimera.nfs.v4.OperationDESTROY_CLIENTID;
import org.dcache.chimera.nfs.v4.OperationDESTROY_SESSION;
import org.dcache.chimera.nfs.v4.OperationEXCHANGE_ID;
import org.dcache.chimera.nfs.v4.OperationGETATTR;
import org.dcache.chimera.nfs.v4.OperationILLEGAL;
import org.dcache.chimera.nfs.v4.OperationPUTFH;
import org.dcache.chimera.nfs.v4.OperationPUTROOTFH;
import org.dcache.chimera.nfs.v4.OperationRECLAIM_COMPLETE;
import org.dcache.chimera.nfs.v4.OperationSEQUENCE;
import org.dcache.chimera.nfs.v4.SimpleIdMap;
import org.dcache.chimera.nfs.v4.xdr.nfs_argop4;
import org.dcache.chimera.nfs.v4.xdr.nfsace4;
import org.dcache.chimera.nfs.v4.xdr.stateid4;
import org.dcache.chimera.nfs.vfs.DirectoryEntry;
import org.dcache.chimera.nfs.vfs.FsStat;
import org.dcache.chimera.nfs.vfs.Inode;
import org.dcache.chimera.nfs.vfs.Stat;
import org.dcache.chimera.nfs.vfs.VirtualFileSystem;
import org.dcache.chimera.nfsv41.mover.EDSOperationREAD;
import org.dcache.chimera.nfsv41.mover.EDSOperationWRITE;
import org.dcache.chimera.nfsv41.mover.MoverBridge;
import org.dcache.util.PortRange;
import org.dcache.xdr.OncRpcException;
import org.dcache.xdr.OncRpcProgram;
import org.dcache.xdr.OncRpcSvc;
import org.dcache.xdr.OncRpcSvcBuilder;
import org.dcache.xdr.RpcLoginService;
import org.dcache.xdr.gss.GssSessionManager;
import org.ietf.jgss.GSSException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NFSv4MoverHandler {
    private static final Logger _log = LoggerFactory.getLogger((String)NFSv4MoverHandler.class.getName());
    private final VirtualFileSystem _fs = new VirtualFileSystem(){

        public int access(Inode inode, int mode) throws IOException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Inode create(Inode parent, Stat.Type type, String path, int uid, int gid, int mode) throws IOException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public FsStat getFsStat() throws IOException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Inode getRootInode() throws IOException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Inode lookup(Inode parent, String path) throws IOException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Inode link(Inode parent, Inode link, String path, int uid, int gid) throws IOException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public List<DirectoryEntry> list(Inode inode) throws IOException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Inode mkdir(Inode parent, String path, int uid, int gid, int mode) throws IOException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void move(Inode src, String oldName, Inode dest, String newName) throws IOException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Inode parentOf(Inode inode) throws IOException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public int read(Inode inode, byte[] data, long offset, int count) throws IOException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public String readlink(Inode inode) throws IOException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public boolean remove(Inode parent, String path) throws IOException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Inode symlink(Inode parent, String path, String link, int uid, int gid, int mode) throws IOException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public int write(Inode inode, byte[] data, long offset, int count) throws IOException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Stat getattr(Inode inode) throws IOException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void setattr(Inode inode, Stat stat) throws IOException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public nfsace4[] getAcl(Inode inode) throws IOException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void setAcl(Inode inode, nfsace4[] acl) throws IOException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public boolean hasIOLayout(Inode inode) throws IOException {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    };
    private final OncRpcSvc _rpcService;
    private final Map<stateid4, MoverBridge> _activeIO = new ConcurrentHashMap<stateid4, MoverBridge>();
    private final NFSv4OperationFactory _operationFactory = new EDSNFSv4OperationFactory(this._activeIO);
    private final NFSServerV41 _embededDS = new NFSServerV41(this._operationFactory, null, this._fs, (NfsIdMapping)new SimpleIdMap(), null);

    public NFSv4MoverHandler(PortRange portRange, boolean withGss, String serverId) throws IOException, GSSException, OncRpcException {
        this._rpcService = new OncRpcSvcBuilder().withMinPort(portRange.getLower()).withMaxPort(portRange.getUpper()).withTCP().withoutAutoPublish().withWorkerThreadIoStrategy().build();
        HashMap<OncRpcProgram, NFSServerV41> programs = new HashMap<OncRpcProgram, NFSServerV41>();
        programs.put(new OncRpcProgram(100003, 4), this._embededDS);
        this._rpcService.setPrograms(programs);
        if (withGss) {
            RpcLoginService rpcLoginService = new RpcLoginService(){

                public Subject login(Principal principal) {
                    return Subjects.NOBODY;
                }
            };
            GssSessionManager gss = new GssSessionManager(rpcLoginService);
            this._rpcService.setGssSessionManager(gss);
        }
        this._rpcService.start();
    }

    public void addHandler(MoverBridge moverBridge) {
        _log.debug("added io handler: {}", (Object)moverBridge);
        this._activeIO.put(moverBridge.getStateid(), moverBridge);
    }

    public void removeHandler(MoverBridge moverBridge) {
        _log.debug("removing io handler: {}", (Object)moverBridge);
        this._activeIO.remove(moverBridge.getStateid());
    }

    public InetSocketAddress getLocalAddress() {
        return this._rpcService.getInetSocketAddress(6);
    }

    public void shutdown() throws IOException {
        this._rpcService.stop();
    }

    NFSServerV41 getNFSServer() {
        return this._embededDS;
    }

    private static class EDSNFSv4OperationFactory
    implements NFSv4OperationFactory {
        private final Map<stateid4, MoverBridge> _activeIO;

        EDSNFSv4OperationFactory(Map<stateid4, MoverBridge> activeIO) {
            this._activeIO = activeIO;
        }

        public AbstractNFSv4Operation getOperation(nfs_argop4 op) {
            switch (op.argop) {
                case 5: {
                    return new OperationCOMMIT(op);
                }
                case 9: {
                    return new OperationGETATTR(op);
                }
                case 22: {
                    return new OperationPUTFH(op);
                }
                case 24: {
                    return new OperationPUTROOTFH(op);
                }
                case 25: {
                    return new EDSOperationREAD(op, this._activeIO);
                }
                case 38: {
                    return new EDSOperationWRITE(op, this._activeIO);
                }
                case 42: {
                    return new OperationEXCHANGE_ID(op, 262144);
                }
                case 43: {
                    return new OperationCREATE_SESSION(op);
                }
                case 44: {
                    return new OperationDESTROY_SESSION(op);
                }
                case 53: {
                    return new OperationSEQUENCE(op);
                }
                case 58: {
                    return new OperationRECLAIM_COMPLETE(op);
                }
                case 41: {
                    return new OperationBIND_CONN_TO_SESSION(op);
                }
                case 57: {
                    return new OperationDESTROY_CLIENTID(op);
                }
            }
            return new OperationILLEGAL(op);
        }
    }
}

