/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera.nfsv41.mover;

import diskCacheV111.vehicles.ProtocolInfo;
import dmg.cells.nucleus.CellEndpoint;
import org.dcache.pool.movers.IoMode;
import org.dcache.pool.movers.ManualMover;
import org.dcache.pool.repository.Allocator;
import org.dcache.pool.repository.RepositoryChannel;
import org.dcache.vehicles.FileAttributes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NFSv41ProtocolMover
implements ManualMover {
    private final CellEndpoint _cell;
    private long _bytesTransferred;
    private final long _started;
    private long _lastAccessTime;
    private IoMode _ioMode;
    private static final Logger _log = LoggerFactory.getLogger(NFSv41ProtocolMover.class);

    public NFSv41ProtocolMover(CellEndpoint cell) {
        this._lastAccessTime = this._started = System.currentTimeMillis();
        this._ioMode = IoMode.READ;
        this._cell = cell;
    }

    @Override
    public long getBytesTransferred() {
        return this._bytesTransferred;
    }

    @Override
    public long getLastTransferred() {
        return this._lastAccessTime;
    }

    @Override
    public long getTransferTime() {
        return System.currentTimeMillis() - this._started;
    }

    @Override
    public void runIO(FileAttributes fileAttributes, RepositoryChannel raf, ProtocolInfo protocol, Allocator allocator, IoMode access) throws Exception {
        throw new RuntimeException("This mover it not suposed to run in legacy mode");
    }

    @Override
    public void setBytesTransferred(long bytesTransferred) {
        if (bytesTransferred < 0L) {
            return;
        }
        this._bytesTransferred += bytesTransferred;
        this._lastAccessTime = System.currentTimeMillis();
    }

    public String toString() {
        return "NFSv4.1/pNFS";
    }
}

