/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera.nfsv41.mover;

import diskCacheV111.vehicles.IpProtocolInfo;
import dmg.cells.nucleus.CellPath;
import java.net.InetSocketAddress;
import org.dcache.chimera.nfs.v4.xdr.stateid4;

public class NFS4ProtocolInfo
implements IpProtocolInfo {
    private static final long serialVersionUID = -2283394435195441798L;
    private static final String _protocolName = "NFS4";
    private static final int _minor = 1;
    private static final int _major = 4;
    private final stateid4 _stateId;
    @Deprecated
    private final String[] _knownNames;
    private CellPath _door;
    private final InetSocketAddress _socketAddress;

    public NFS4ProtocolInfo(InetSocketAddress clientSocketAddress, stateid4 stateId) {
        this._stateId = stateId;
        this._socketAddress = clientSocketAddress;
        this._knownNames = new String[]{this._socketAddress.getAddress().getHostAddress()};
    }

    @Override
    public String getProtocol() {
        return _protocolName;
    }

    @Override
    public int getMinorVersion() {
        return 1;
    }

    @Override
    public int getMajorVersion() {
        return 4;
    }

    @Override
    public String getVersionString() {
        return "NFS4-4.1";
    }

    public boolean isFileCheckRequired() {
        return false;
    }

    public CellPath door() {
        return this._door;
    }

    public void door(CellPath door) {
        this._door = door;
    }

    public stateid4 stateId() {
        return this._stateId;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getVersionString()).append(":").append(this._socketAddress);
        return sb.toString();
    }

    @Override
    public InetSocketAddress getSocketAddress() {
        return this._socketAddress;
    }
}

