/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera.nfsv41.mover;

import java.io.IOException;
import java.util.Map;
import org.dcache.chimera.nfs.ChimeraNFSException;
import org.dcache.chimera.nfs.v4.AbstractNFSv4Operation;
import org.dcache.chimera.nfs.v4.CompoundContext;
import org.dcache.chimera.nfs.v4.xdr.WRITE4res;
import org.dcache.chimera.nfs.v4.xdr.WRITE4resok;
import org.dcache.chimera.nfs.v4.xdr.count4;
import org.dcache.chimera.nfs.v4.xdr.nfs_argop4;
import org.dcache.chimera.nfs.v4.xdr.nfs_resop4;
import org.dcache.chimera.nfs.v4.xdr.stateid4;
import org.dcache.chimera.nfs.v4.xdr.uint32_t;
import org.dcache.chimera.nfs.v4.xdr.verifier4;
import org.dcache.chimera.nfsv41.mover.MoverBridge;
import org.dcache.pool.movers.IoMode;
import org.dcache.pool.repository.RepositoryChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EDSOperationWRITE
extends AbstractNFSv4Operation {
    private static final Logger _log = LoggerFactory.getLogger((String)EDSOperationWRITE.class.getName());
    private final Map<stateid4, MoverBridge> _activeIO;
    private static final int INC_SPACE = 0x3200000;

    public EDSOperationWRITE(nfs_argop4 args, Map<stateid4, MoverBridge> activeIO) {
        super(args, 38);
        this._activeIO = activeIO;
    }

    public void process(CompoundContext context, nfs_resop4 result) {
        WRITE4res res = result.opwrite;
        try {
            MoverBridge moverBridge = this._activeIO.get(this._args.opwrite.stateid);
            if (moverBridge == null) {
                throw new ChimeraNFSException(10025, "No mover associated with given stateid");
            }
            if (moverBridge.getIoMode() != IoMode.WRITE) {
                throw new ChimeraNFSException(1, "an attempt to write without IO mode enabled");
            }
            long offset = this._args.opwrite.offset.value.value;
            int count = this._args.opwrite.data.remaining();
            RepositoryChannel fc = moverBridge.getFileChannel();
            if (offset + (long)count > moverBridge.getAllocated()) {
                moverBridge.getAllocator().allocate(0x3200000L);
                moverBridge.setAllocated(moverBridge.getAllocated() + 0x3200000L);
            }
            this._args.opwrite.data.rewind();
            int bytesWritten = fc.write(this._args.opwrite.data, offset);
            moverBridge.getMover().setBytesTransferred(bytesWritten);
            res.status = 0;
            res.resok4 = new WRITE4resok();
            res.resok4.count = new count4(new uint32_t(bytesWritten));
            res.resok4.committed = 2;
            res.resok4.writeverf = new verifier4();
            res.resok4.writeverf.value = new byte[8];
            _log.debug("MOVER: {}@{} written, {} requested.", new Object[]{bytesWritten, offset, bytesWritten});
        }
        catch (ChimeraNFSException he) {
            _log.debug(he.getMessage());
            res.status = he.getStatus();
        }
        catch (IOException ioe) {
            _log.error("DSWRITE: ", (Throwable)ioe);
            res.status = 5;
        }
        catch (Exception e) {
            _log.error("DSWRITE: ", (Throwable)e);
            res.status = 10006;
        }
    }
}

