/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera.nfsv41.mover;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;
import org.dcache.chimera.nfs.ChimeraNFSException;
import org.dcache.chimera.nfs.v4.AbstractNFSv4Operation;
import org.dcache.chimera.nfs.v4.CompoundContext;
import org.dcache.chimera.nfs.v4.xdr.READ4res;
import org.dcache.chimera.nfs.v4.xdr.READ4resok;
import org.dcache.chimera.nfs.v4.xdr.nfs_argop4;
import org.dcache.chimera.nfs.v4.xdr.nfs_resop4;
import org.dcache.chimera.nfs.v4.xdr.stateid4;
import org.dcache.chimera.nfsv41.mover.MoverBridge;
import org.dcache.pool.repository.RepositoryChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EDSOperationREAD
extends AbstractNFSv4Operation {
    private static final Logger _log = LoggerFactory.getLogger((String)EDSOperationREAD.class.getName());
    private final Map<stateid4, MoverBridge> _activeIO;

    public EDSOperationREAD(nfs_argop4 args, Map<stateid4, MoverBridge> activeIO) {
        super(args, 25);
        this._activeIO = activeIO;
    }

    public void process(CompoundContext context, nfs_resop4 result) {
        READ4res res = result.opread;
        try {
            long offset = this._args.opread.offset.value.value;
            int count = this._args.opread.count.value.value;
            MoverBridge moverBridge = this._activeIO.get(this._args.opread.stateid);
            if (moverBridge == null) {
                throw new ChimeraNFSException(10025, "No mover associated with given stateid");
            }
            ByteBuffer bb = ByteBuffer.allocate(count);
            RepositoryChannel fc = moverBridge.getFileChannel();
            bb.rewind();
            int bytesReaded = fc.read(bb, offset);
            moverBridge.getMover().setBytesTransferred(bytesReaded);
            res.status = 0;
            res.resok4 = new READ4resok();
            res.resok4.data = bb;
            if (offset + (long)bytesReaded == fc.size()) {
                res.resok4.eof = true;
            }
            _log.debug("MOVER: {}@{} readed, {} requested.", new Object[]{bytesReaded, offset, this._args.opread.count.value.value});
        }
        catch (ChimeraNFSException he) {
            res.status = he.getStatus();
            _log.debug(he.getMessage());
        }
        catch (IOException ioe) {
            _log.error("DSREAD: ", (Throwable)ioe);
            res.status = 5;
        }
        catch (Exception e) {
            _log.error("DSREAD: ", (Throwable)e);
            res.status = 10006;
        }
    }
}

