/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera.nfsv41.door;

import com.google.common.base.Strings;
import diskCacheV111.util.CacheException;
import java.security.Principal;
import java.util.Set;
import javax.security.auth.Subject;
import org.dcache.auth.GidPrincipal;
import org.dcache.auth.GroupNamePrincipal;
import org.dcache.auth.LoginStrategy;
import org.dcache.auth.Subjects;
import org.dcache.auth.UidPrincipal;
import org.dcache.auth.UserNamePrincipal;
import org.dcache.chimera.nfs.v4.NfsIdMapping;
import org.dcache.xdr.RpcLoginService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StrategyIdMapper
implements NfsIdMapping,
RpcLoginService {
    private final String NOBODY = "nobody";
    private final int NODOBY_ID = -1;
    private final LoginStrategy _remoteLoginStrategy;
    private static final Logger _log = LoggerFactory.getLogger(StrategyIdMapper.class);
    private final String _domain;
    private boolean _fallbackToNumeric = false;

    public StrategyIdMapper(LoginStrategy remoteLoginStrategy, String domain) {
        this._remoteLoginStrategy = remoteLoginStrategy;
        this._domain = Strings.emptyToNull((String)domain);
    }

    public void setFallBackToNumeric(boolean fallBack) {
        this._fallbackToNumeric = fallBack;
    }

    public boolean getFallBackToNumeric() {
        return this._fallbackToNumeric;
    }

    public String gidToPrincipal(int id) {
        if (id < 0) {
            return "nobody";
        }
        try {
            Set<Principal> principals = this._remoteLoginStrategy.reverseMap((Principal)new GidPrincipal((long)id, false));
            for (Principal principal : principals) {
                if (!(principal instanceof GroupNamePrincipal)) continue;
                return this.addDomain(principal.getName());
            }
        }
        catch (CacheException e) {
            _log.debug("Failed to reverseMap for gid {} : {}", (Object)id, (Object)e);
        }
        return this.numericStringIfAllowed(id);
    }

    public int principalToGid(String name) {
        try {
            String principal = this.stripDomain(name);
            Principal gidPrincipal = this._remoteLoginStrategy.map((Principal)new GroupNamePrincipal(principal));
            if (gidPrincipal instanceof GidPrincipal) {
                return (int)((GidPrincipal)gidPrincipal).getGid();
            }
        }
        catch (CacheException e) {
            _log.debug("Failed to map principal {} : {}", (Object)name, (Object)e);
        }
        return this.tryNumericIfAllowed(name);
    }

    public int principalToUid(String name) {
        try {
            String principal = this.stripDomain(name);
            Principal uidPrincipal = this._remoteLoginStrategy.map((Principal)new UserNamePrincipal(principal));
            if (uidPrincipal instanceof UidPrincipal) {
                return (int)((UidPrincipal)uidPrincipal).getUid();
            }
        }
        catch (CacheException e) {
            _log.debug("Failed to map principal {} : {}", (Object)name, (Object)e);
        }
        return this.tryNumericIfAllowed(name);
    }

    public String uidToPrincipal(int id) {
        if (id < 0) {
            return "nobody";
        }
        try {
            Set<Principal> principals = this._remoteLoginStrategy.reverseMap((Principal)new UidPrincipal((long)id));
            for (Principal principal : principals) {
                if (!(principal instanceof UserNamePrincipal)) continue;
                return this.addDomain(principal.getName());
            }
        }
        catch (CacheException e) {
            _log.debug("Failed to reverseMap for uid {} : {}", (Object)id, (Object)e);
        }
        return this.numericStringIfAllowed(id);
    }

    private String stripDomain(String s) {
        int n = s.indexOf(64);
        if (n != -1) {
            return s.substring(0, n);
        }
        return s;
    }

    private String addDomain(String s) {
        return this._domain == null ? s : s + "@" + this._domain;
    }

    private int tryNumericIfAllowed(String id) {
        if (!this._fallbackToNumeric) {
            return -1;
        }
        try {
            return Integer.parseInt(id);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    private String numericStringIfAllowed(int id) {
        return this._fallbackToNumeric ? String.valueOf(id) : "nobody";
    }

    public Subject login(Principal principal) {
        Subject in = new Subject();
        in.getPrincipals().add(principal);
        in.setReadOnly();
        try {
            return this._remoteLoginStrategy.login(in).getSubject();
        }
        catch (CacheException e) {
            _log.debug("Failed to login for : {} : {}", (Object)principal.getName(), (Object)e.toString());
            return Subjects.NOBODY;
        }
    }
}

