/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera.nfsv41.door;

import com.google.common.base.Joiner;
import diskCacheV111.util.CacheException;
import diskCacheV111.util.FileInCacheException;
import diskCacheV111.util.FsPath;
import diskCacheV111.util.PnfsHandler;
import diskCacheV111.util.PnfsId;
import diskCacheV111.vehicles.DoorTransferFinishedMessage;
import diskCacheV111.vehicles.IoDoorEntry;
import diskCacheV111.vehicles.IoDoorInfo;
import diskCacheV111.vehicles.PoolMoverKillMessage;
import diskCacheV111.vehicles.PoolPassiveIoFileMessage;
import dmg.cells.nucleus.CDC;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.CellPath;
import dmg.cells.services.login.LoginManagerChildrenInfo;
import dmg.util.Args;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.security.auth.Subject;
import org.dcache.auth.Subjects;
import org.dcache.cells.AbstractCellComponent;
import org.dcache.cells.CellCommandListener;
import org.dcache.cells.CellInfoProvider;
import org.dcache.cells.CellMessageReceiver;
import org.dcache.cells.CellStub;
import org.dcache.chimera.FsInode;
import org.dcache.chimera.FsInodeType;
import org.dcache.chimera.JdbcFs;
import org.dcache.chimera.nfs.ChimeraNFSException;
import org.dcache.chimera.nfs.ExportFile;
import org.dcache.chimera.nfs.v3.MountServer;
import org.dcache.chimera.nfs.v3.NfsServerV3;
import org.dcache.chimera.nfs.v4.CompoundContext;
import org.dcache.chimera.nfs.v4.Layout;
import org.dcache.chimera.nfs.v4.MDSOperationFactory;
import org.dcache.chimera.nfs.v4.NFS4Client;
import org.dcache.chimera.nfs.v4.NFSServerV41;
import org.dcache.chimera.nfs.v4.NFSv41DeviceManager;
import org.dcache.chimera.nfs.v4.NFSv41Session;
import org.dcache.chimera.nfs.v4.NFSv4OperationFactory;
import org.dcache.chimera.nfs.v4.NfsIdMapping;
import org.dcache.chimera.nfs.v4.RoundRobinStripingPattern;
import org.dcache.chimera.nfs.v4.StripingPattern;
import org.dcache.chimera.nfs.v4.xdr.device_addr4;
import org.dcache.chimera.nfs.v4.xdr.deviceid4;
import org.dcache.chimera.nfs.v4.xdr.layout4;
import org.dcache.chimera.nfs.v4.xdr.multipath_list4;
import org.dcache.chimera.nfs.v4.xdr.netaddr4;
import org.dcache.chimera.nfs.v4.xdr.nfs_fh4;
import org.dcache.chimera.nfs.v4.xdr.nfsv4_1_file_layout_ds_addr4;
import org.dcache.chimera.nfs.v4.xdr.stateid4;
import org.dcache.chimera.nfs.vfs.ChimeraVfs;
import org.dcache.chimera.nfs.vfs.Inode;
import org.dcache.chimera.nfs.vfs.VirtualFileSystem;
import org.dcache.chimera.nfsv41.mover.NFS4ProtocolInfo;
import org.dcache.commons.util.NDC;
import org.dcache.util.RedirectedTransfer;
import org.dcache.util.Transfer;
import org.dcache.util.TransferRetryPolicy;
import org.dcache.utils.Bytes;
import org.dcache.xdr.OncRpcException;
import org.dcache.xdr.OncRpcProgram;
import org.dcache.xdr.OncRpcSvc;
import org.dcache.xdr.RpcDispatchable;
import org.dcache.xdr.XdrBuffer;
import org.dcache.xdr.XdrEncodingStream;
import org.dcache.xdr.gss.GssSessionManager;
import org.glassfish.grizzly.Buffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NFSv41Door
extends AbstractCellComponent
implements NFSv41DeviceManager,
CellCommandListener,
CellMessageReceiver,
CellInfoProvider {
    private static final Logger _log = LoggerFactory.getLogger(NFSv41Door.class);
    private Map<String, PoolDS> _poolNameToIpMap = new HashMap<String, PoolDS>();
    private Map<deviceid4, PoolDS> _deviceMap = new HashMap<deviceid4, PoolDS>();
    private final AtomicInteger _nextDeviceID = new AtomicInteger(1);
    private static final deviceid4 MDS_ID = NFSv41Door.deviceidOf(0);
    private final Map<stateid4, NfsTransfer> _ioMessages = new ConcurrentHashMap<stateid4, NfsTransfer>();
    private static final long NFS_REPLY_TIMEOUT = TimeUnit.SECONDS.toMillis(27L);
    private static final long NFS_RETRY_PERIOD = TimeUnit.SECONDS.toMillis(1L);
    private CellStub _poolManagerStub;
    private CellStub _billingStub;
    private String _cellName;
    private String _domainName;
    private PnfsHandler _pnfsHandler;
    private String _ioQueue;
    private int _port;
    boolean _enableV3;
    private NFSServerV41 _nfs4;
    private OncRpcSvc _rpcService;
    private NfsIdMapping _idMapper;
    private GssSessionManager _gssSessionManager;
    private VirtualFileSystem _vfs;
    private static final TransferRetryPolicy RETRY_POLICY = new TransferRetryPolicy(Integer.MAX_VALUE, NFS_RETRY_PERIOD, NFS_REPLY_TIMEOUT, NFS_REPLY_TIMEOUT);
    private JdbcFs _fileFileSystemProvider;
    private ExportFile _exportFile;
    public static final String hh_kill_mover = " <pool> <moverid> # kill mover on the pool";
    public static final String fh_exports_reload = " # re-scan export file";
    public static final String fh_exports_ls = " [host] # dump nfs exports";
    public static final String hh_get_children = "[-binary]";
    public static final String hh_get_door_info = "[-binary]";
    public static final String fh_get_door_info = "Provides information about the door and current transfers";

    public void setGssSessionManager(GssSessionManager sessionManager) {
        this._gssSessionManager = sessionManager;
    }

    public void setIdMapper(NfsIdMapping idMapper) {
        this._idMapper = idMapper;
    }

    public void setPoolManagerStub(CellStub stub) {
        this._poolManagerStub = stub;
    }

    public void setPnfsHandler(PnfsHandler pnfs) {
        this._pnfsHandler = pnfs;
    }

    public void setFileSystemProvider(JdbcFs fs) {
        this._fileFileSystemProvider = fs;
    }

    public void setExportFile(ExportFile export) {
        this._exportFile = export;
    }

    public void setIoQueue(String ioQueue) {
        this._ioQueue = ioQueue;
    }

    public void setPortNumber(int port) {
        this._port = port;
    }

    public void setEnableV3(boolean enable) {
        this._enableV3 = enable;
    }

    public void init() throws Exception {
        this._cellName = this.getCellName();
        this._domainName = this.getCellDomainName();
        NFSv41Door _dm = this;
        this._rpcService = new OncRpcSvc(this._port, 6, true);
        this._rpcService.setGssSessionManager(this._gssSessionManager);
        this._vfs = new ChimeraVfs(this._fileFileSystemProvider, this._idMapper);
        this._nfs4 = new NFSServerV41((NFSv4OperationFactory)new MDSOperationFactory(), (NFSv41DeviceManager)_dm, this._vfs, this._idMapper, this._exportFile);
        MountServer ms = new MountServer(this._exportFile, this._vfs);
        if (this._enableV3) {
            NfsServerV3 nfs3 = new NfsServerV3(this._exportFile, this._vfs);
            this._rpcService.register(new OncRpcProgram(100003, 3), (RpcDispatchable)nfs3);
        }
        this._rpcService.register(new OncRpcProgram(100003, 4), (RpcDispatchable)this._nfs4);
        this._rpcService.register(new OncRpcProgram(100005, 3), (RpcDispatchable)ms);
        this._rpcService.register(new OncRpcProgram(100005, 3), (RpcDispatchable)ms);
        this._rpcService.start();
    }

    public void destroy() throws IOException {
        this._rpcService.stop();
    }

    public void messageArrived(PoolPassiveIoFileMessage<stateid4> message) {
        String poolName = message.getPoolName();
        _log.debug("NFS mover ready: {}", (Object)poolName);
        Object[] poolAddress = message.socketAddresses();
        PoolDS device = this._poolNameToIpMap.get(poolName);
        if (device == null || !Arrays.equals(device.getInetSocketAddress(), poolAddress)) {
            int id = this.nextDeviceID();
            if (device != null) {
                deviceid4 oldId = device.getDeviceId();
                this._deviceMap.remove(oldId);
            }
            deviceid4 deviceid = NFSv41Door.deviceidOf(id);
            device = new PoolDS(deviceid, (InetSocketAddress[])poolAddress);
            this._poolNameToIpMap.put(poolName, device);
            this._deviceMap.put(deviceid, device);
            _log.debug("new mapping: {}", (Object)device);
        }
        stateid4 stateid = message.challange();
        NfsTransfer transfer = this._ioMessages.get(stateid);
        transfer.redirect(device);
    }

    public void messageArrived(DoorTransferFinishedMessage transferFinishedMessage) {
        NFS4ProtocolInfo protocolInfo = (NFS4ProtocolInfo)transferFinishedMessage.getProtocolInfo();
        _log.debug("Mover {} done.", (Object)protocolInfo.stateId());
        Transfer transfer = this._ioMessages.remove(protocolInfo.stateId());
        if (transfer != null) {
            transfer.finished(transferFinishedMessage);
            transfer.notifyBilling(transferFinishedMessage.getReturnCode(), "");
        }
    }

    private int nextDeviceID() {
        return this._nextDeviceID.incrementAndGet();
    }

    public device_addr4 getDeviceInfo(CompoundContext context, deviceid4 deviceId) {
        if (deviceId.equals((Object)MDS_ID)) {
            return NFSv41Door.deviceAddrOf((StripingPattern<InetSocketAddress[]>)new RoundRobinStripingPattern(), new InetSocketAddress[][]{{context.getRpcCall().getTransport().getLocalSocketAddress()}});
        }
        PoolDS ds = this._deviceMap.get(deviceId);
        if (ds == null) {
            return null;
        }
        return ds.getDeviceAddr();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Layout layoutGet(CompoundContext context, Inode nfsInode, int ioMode, stateid4 stateid) throws IOException {
        FsInode inode = this._fileFileSystemProvider.inodeFromBytes(nfsInode.getFileId());
        try (CDC cdc = CDC.reset((String)this._cellName, (String)this._domainName);){
            deviceid4 deviceid;
            NDC.push((String)("pnfsid=" + inode));
            NDC.push((String)("client=" + context.getRpcCall().getTransport().getRemoteSocketAddress()));
            if (inode.type() != FsInodeType.INODE || inode.getLevel() != 0) {
                deviceid = MDS_ID;
            } else {
                InetSocketAddress remote = context.getRpcCall().getTransport().getRemoteSocketAddress();
                PnfsId pnfsId = new PnfsId(inode.toString());
                Transfer.initSession();
                NfsTransfer transfer = new NfsTransfer(this._pnfsHandler, Subjects.ROOT, new FsPath("/"), remote, stateid);
                NFS4ProtocolInfo protocolInfo = transfer.getProtocolInfoForPool();
                protocolInfo.door(new CellPath(this.getCellAddress()));
                transfer.setCellName(this.getCellName());
                transfer.setDomainName(this.getCellDomainName());
                transfer.setBillingStub(this._billingStub);
                transfer.setPoolStub(this._poolManagerStub);
                transfer.setPoolManagerStub(this._poolManagerStub);
                transfer.setPnfsId(pnfsId);
                transfer.setClientAddress(remote);
                transfer.readNameSpaceEntry();
                this._ioMessages.put(protocolInfo.stateId(), transfer);
                PoolDS ds = this.getPool(transfer, protocolInfo, ioMode);
                deviceid = ds.getDeviceId();
            }
            nfs_fh4 fh = new nfs_fh4(nfsInode.toNfsHandle());
            layout4 layout = Layout.getLayoutSegment((deviceid4)deviceid, (nfs_fh4)fh, (int)ioMode, (long)0L, (long)-1L);
            Layout layout2 = new Layout(true, stateid, new layout4[]{layout});
            return layout2;
        }
        catch (FileInCacheException e) {
            throw new ChimeraNFSException(5, e.getMessage());
        }
        catch (CacheException | InterruptedException e) {
            throw new ChimeraNFSException(10058, e.getMessage());
        }
    }

    private PoolDS getPool(NfsTransfer transfer, NFS4ProtocolInfo protocolInfo, int iomode) throws InterruptedException, CacheException {
        if (iomode == 1 || !transfer.getStorageInfo().isCreatedOnly()) {
            _log.debug("looking for read pool for {}", (Object)transfer.getPnfsId());
            transfer.setWrite(false);
        } else {
            _log.debug("looking for write pool for {}", (Object)transfer.getPnfsId());
            transfer.setWrite(true);
        }
        transfer.selectPoolAndStartMover(this._ioQueue, RETRY_POLICY);
        _log.debug("mover ready: pool={} moverid={}", (Object)transfer.getPool(), (Object)transfer.getMoverId());
        return (PoolDS)transfer.waitForRedirect(NFS_REPLY_TIMEOUT);
    }

    public List<deviceid4> getDeviceList(CompoundContext context) {
        ArrayList<deviceid4> knownDevices = new ArrayList<deviceid4>();
        knownDevices.addAll(this._deviceMap.keySet());
        return knownDevices;
    }

    public void layoutReturn(CompoundContext context, stateid4 stateid) throws IOException {
        _log.debug("Releasing device by stateid: {}", (Object)stateid);
        NfsTransfer transfer = this._ioMessages.get(stateid);
        if (transfer == null) {
            return;
        }
        _log.debug("Sending KILL to {}@{}", (Object)transfer.getMoverId(), (Object)transfer.getPool());
        transfer.killMover(0L);
        try {
            if (!transfer.waitForMover(500L)) {
                throw new ChimeraNFSException(10008, "Mover not stopped");
            }
        }
        catch (CacheException | InterruptedException e) {
            _log.info("Failed to kill mover: {}@{} : {}", new Object[]{transfer.getMoverId(), transfer.getPool(), e.getMessage()});
            throw new ChimeraNFSException(5, e.getMessage());
        }
    }

    public void setBillingStub(CellStub stub) {
        this._billingStub = stub;
    }

    @Override
    public void getInfo(PrintWriter pw) {
        pw.println("NFSv4.1 door (MDS):");
        pw.printf("  IO queue: %s\n", this._ioQueue);
        pw.println("  Known pools (DS):\n");
        for (Map.Entry<String, PoolDS> ioDevice : this._poolNameToIpMap.entrySet()) {
            pw.println(String.format("    %s : [%s]", ioDevice.getKey(), ioDevice.getValue()));
        }
        pw.println();
        pw.println("  Known movers (layouts):");
        for (NfsTransfer io : this._ioMessages.values()) {
            pw.println(String.format(" %s : %s@%s, OS=%s,cl=[%s]", io.getPnfsId(), io.getMoverId(), io.getPool(), io.getProtocolInfoForPool().stateId(), io.getProtocolInfoForPool().getSocketAddress().getAddress().getHostAddress()));
        }
        pw.println();
        pw.println("  Known clients:");
        for (NFS4Client client : this._nfs4.getClients()) {
            pw.println(String.format("    %s", client));
            for (NFSv41Session session : client.sessions()) {
                pw.println(String.format("        %s, max slot: %d/%d", session, session.getHighestSlot(), session.getHighestUsedSlot()));
            }
        }
    }

    public String ac_kill_mover_$_2(Args args) throws Exception {
        int mover = Integer.parseInt(args.argv(1));
        String pool = args.argv(0);
        PoolMoverKillMessage message = new PoolMoverKillMessage(pool, mover);
        message.setReplyRequired(false);
        this.sendMessage(new CellMessage(new CellPath(pool), (Serializable)message));
        return "";
    }

    public String ac_exports_reload(Args args) throws IOException {
        this._exportFile.rescan();
        return "Done";
    }

    public String ac_exports_ls_$_0_1(Args args) throws UnknownHostException {
        InetAddress address = InetAddress.getByName(args.argv(0));
        if (args.argc() > 0) {
            return Joiner.on((char)'\n').join((Iterable)this._exportFile.exportsFor(address));
        }
        return Joiner.on((char)'\n').join((Iterable)this._exportFile.getExports());
    }

    private static deviceid4 deviceidOf(int id) {
        byte[] deviceidBytes = new byte[16];
        Bytes.putInt((byte[])deviceidBytes, (int)0, (int)id);
        return new deviceid4(deviceidBytes);
    }

    public Object ac_get_children(Args args) {
        boolean binary = args.hasOption("binary");
        if (binary) {
            String[] childrens = new String[]{this.getCellName()};
            return new LoginManagerChildrenInfo(this.getCellName(), this.getCellDomainName(), childrens);
        }
        return this.getCellName();
    }

    public Object ac_get_door_info(Args args) {
        ArrayList<IoDoorEntry> entries = new ArrayList<IoDoorEntry>();
        for (Transfer transfer : this._ioMessages.values()) {
            entries.add(transfer.getIoDoorEntry());
        }
        IoDoorInfo doorInfo = new IoDoorInfo(this.getCellName(), this.getCellDomainName());
        doorInfo.setProtocol("NFSV4.1", "0");
        doorInfo.setOwner("");
        doorInfo.setProcess("");
        doorInfo.setIoDoorEntries(entries.toArray(new IoDoorEntry[entries.size()]));
        return args.hasOption("binary") ? doorInfo : doorInfo.toString();
    }

    public static device_addr4 deviceAddrOf(StripingPattern<InetSocketAddress[]> stripingPattern, InetSocketAddress[] ... deviceAddress) {
        nfsv4_1_file_layout_ds_addr4 file_type = new nfsv4_1_file_layout_ds_addr4();
        file_type.nflda_multipath_ds_list = new multipath_list4[deviceAddress.length];
        for (int i = 0; i < deviceAddress.length; ++i) {
            file_type.nflda_multipath_ds_list[i] = NFSv41Door.toMultipath(deviceAddress[i]);
        }
        file_type.nflda_stripe_indices = stripingPattern.getPattern((Object[])deviceAddress);
        XdrBuffer xdr = new XdrBuffer(128);
        try {
            xdr.beginEncoding();
            file_type.xdrEncode((XdrEncodingStream)xdr);
            xdr.endEncoding();
        }
        catch (OncRpcException e) {
            throw new RuntimeException("Unexpected OncRpcException:", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected IOException:", e);
        }
        Buffer body = xdr.asBuffer();
        byte[] retBytes = new byte[body.remaining()];
        body.get(retBytes);
        device_addr4 addr = new device_addr4();
        addr.da_layout_type = 1;
        addr.da_addr_body = retBytes;
        return addr;
    }

    private static multipath_list4 toMultipath(InetSocketAddress[] addresses) {
        multipath_list4 multipath = new multipath_list4();
        multipath.value = new netaddr4[addresses.length];
        for (int i = 0; i < addresses.length; ++i) {
            multipath.value[i] = new netaddr4(addresses[i]);
        }
        return multipath;
    }

    public String ac_stats(Args args) {
        StringBuilder sb = new StringBuilder();
        sb.append("Stats:").append("\n").append(this._nfs4.getStatistics());
        return sb.toString();
    }

    private static class NfsTransfer
    extends RedirectedTransfer<PoolDS> {
        private final stateid4 _stateid;
        private final NFS4ProtocolInfo _protocolInfo;

        NfsTransfer(PnfsHandler pnfs, Subject subject, FsPath path, InetSocketAddress client, stateid4 stateid) {
            super(pnfs, subject, path);
            this._stateid = stateid;
            this._protocolInfo = new NFS4ProtocolInfo(client, this._stateid);
        }

        @Override
        protected NFS4ProtocolInfo getProtocolInfoForPoolManager() {
            return this._protocolInfo;
        }

        @Override
        protected NFS4ProtocolInfo getProtocolInfoForPool() {
            return this._protocolInfo;
        }
    }

    private static class PoolDS {
        private final deviceid4 _deviceId;
        private final InetSocketAddress[] _socketAddress;
        private final device_addr4 _deviceAddr;

        public PoolDS(deviceid4 deviceId, InetSocketAddress[] ip) {
            this._deviceId = deviceId;
            this._socketAddress = ip;
            this._deviceAddr = NFSv41Door.deviceAddrOf((StripingPattern<InetSocketAddress[]>)new RoundRobinStripingPattern(), new InetSocketAddress[][]{ip});
        }

        public deviceid4 getDeviceId() {
            return this._deviceId;
        }

        public InetSocketAddress[] getInetSocketAddress() {
            return this._socketAddress;
        }

        public device_addr4 getDeviceAddr() {
            return this._deviceAddr;
        }

        public String toString() {
            return String.format("DS: %s, InetAddress: %s", this._deviceId, Arrays.toString(this._socketAddress));
        }
    }
}

