/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.cells;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import diskCacheV111.util.CacheException;
import dmg.cells.nucleus.CellEndpoint;
import dmg.cells.nucleus.CellInfo;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.CellPath;
import dmg.cells.nucleus.EnvironmentAware;
import dmg.cells.nucleus.NoRouteToCellException;
import dmg.cells.services.SetupInfoMessage;
import dmg.util.Args;
import dmg.util.CommandException;
import dmg.util.CommandThrowableException;
import java.beans.PropertyDescriptor;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Queue;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import org.dcache.cells.AbstractCell;
import org.dcache.cells.CellCommandListener;
import org.dcache.cells.CellInfoProvider;
import org.dcache.cells.CellLifeCycleAware;
import org.dcache.cells.CellMessageReceiver;
import org.dcache.cells.CellMessageSender;
import org.dcache.cells.CellSetupProvider;
import org.dcache.cells.ThreadFactoryAware;
import org.dcache.util.ClassNameComparator;
import org.dcache.vehicles.BeanQueryAllPropertiesMessage;
import org.dcache.vehicles.BeanQueryMessage;
import org.dcache.vehicles.BeanQuerySinglePropertyMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanInstantiationException;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.BeansException;
import org.springframework.beans.InvalidPropertyException;
import org.springframework.beans.PropertyAccessException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;

public class UniversalSpringCell
extends AbstractCell
implements BeanPostProcessor,
EnvironmentAware {
    private static final long WAIT_FOR_FILE_SLEEP = 30000L;
    private static final Logger _log = LoggerFactory.getLogger(UniversalSpringCell.class);
    private Map<String, Object> _environment = Collections.emptyMap();
    private ConfigurableApplicationContext _context;
    private final Map<CellInfoProvider, String> _infoProviders = new TreeMap<Object, String>(new ClassNameComparator());
    private final Set<CellSetupProvider> _setupProviders = new TreeSet<Object>(new ClassNameComparator());
    private final Set<CellLifeCycleAware> _lifeCycleAware = new TreeSet<Object>(new ClassNameComparator());
    private String _setupController;
    private String _setupClass;
    private File _setupFile;
    public static final String hh_save = "[-sc=<setupController>|none] [-file=<filename>] # saves setup to disk or setup controller";
    public static final String hh_reload = "-yes";
    public static final String fh_reload = "This command destroys the current setup and replaces itby the setup on disk.";
    public static final String hh_infox = "<bean>";
    public static final String hh_bean_ls = "# lists running beans";
    public static final String hh_bean_dep = "# shows bean dependencies";
    public static final String hh_bean_properties = "<bean> # shows properties of a bean";
    public static final String hh_bean_property = "<property-name> # shows property of a bean";
    public static final String hh_bean_messages = "[<bean>] # shows message types handled by beans";
    private static final Set<Class<?>> PRIMITIVES = Sets.newHashSet((Object[])new Class[]{Byte.class, Byte.TYPE, Short.class, Short.TYPE, Integer.class, Integer.TYPE, Long.class, Long.TYPE, Float.class, Float.TYPE, Double.class, Double.TYPE, Character.class, Character.TYPE, Boolean.class, Boolean.TYPE, String.class});
    private static final Set<Class<?>> TERMINALS = Sets.newHashSet((Object[])new Class[]{Class.class});

    public UniversalSpringCell(String cellName, String arguments) {
        super(cellName, arguments);
    }

    public void setEnvironment(Map<String, Object> environment) {
        this._environment = environment;
        try {
            this.doInit();
        }
        catch (InterruptedException e) {
            throw Throwables.propagate((Throwable)e);
        }
        catch (ExecutionException e) {
            throw Throwables.propagate((Throwable)e.getCause());
        }
    }

    @Override
    protected void executeInit() throws Exception {
        Args args = this.getArgs();
        Preconditions.checkArgument((args.argc() > 0 ? 1 : 0) != 0, (Object)"Configuration location missing");
        this._setupController = args.getOpt("setupController");
        this.info("Setup controller set to " + (this._setupController == null ? "none" : this._setupController));
        this._setupFile = !args.hasOption("setupFile") ? null : new File(args.getOpt("setupFile"));
        this._setupClass = args.getOpt("setupClass");
        Preconditions.checkArgument((this._setupController == null || this._setupClass != null ? 1 : 0) != 0, (Object)"Setup class must be specified when a setup controller is used");
        this.waitForFiles();
        try {
            this._context = new UniversalSpringCellApplicationContext(this.getArgs());
        }
        catch (BeanInstantiationException e) {
            Throwable t = e.getMostSpecificCause();
            Throwables.propagateIfPossible((Throwable)t);
            String msg = "Failed to instantiate class " + e.getBeanClass().getName() + ": " + t.getMessage();
            throw new CommandThrowableException(msg, t);
        }
        catch (BeanCreationException e) {
            Throwable t = e.getMostSpecificCause();
            Throwables.propagateIfPossible((Throwable)t);
            String msg = "Failed to create bean '" + e.getBeanName() + "' : " + t.getMessage();
            throw new CommandThrowableException(msg, t);
        }
        this.setupCellExecutors(args.getOpt("callbackExecutor"), args.getOpt("messageExecutor"));
        this.init();
        this.startTimeoutTask();
        this.executeSetup();
        this.start();
        for (CellLifeCycleAware bean : this._lifeCycleAware) {
            bean.afterStart();
        }
    }

    @Override
    public void cleanUp() {
        super.cleanUp();
        for (CellLifeCycleAware bean : this._lifeCycleAware) {
            bean.beforeStop();
        }
        if (this._context != null) {
            this._context.close();
            this._context = null;
        }
        this._infoProviders.clear();
        this._setupProviders.clear();
        this._lifeCycleAware.clear();
    }

    private void setupCellExecutors(String callbackExecutor, String messageExecutor) {
        Object executor;
        if (callbackExecutor != null) {
            executor = this.getBean(callbackExecutor);
            Preconditions.checkState((boolean)(executor instanceof ThreadPoolExecutor), (Object)("No such bean: " + callbackExecutor));
            this.getNucleus().setCallbackExecutor((ThreadPoolExecutor)executor);
        }
        if (messageExecutor != null) {
            executor = this.getBean(messageExecutor);
            Preconditions.checkState((boolean)(executor instanceof ThreadPoolExecutor), (Object)("No such bean: " + messageExecutor));
            this.getNucleus().setMessageExecutor((ThreadPoolExecutor)executor);
        }
    }

    private File firstMissing(File[] files) {
        for (File file : files) {
            if (file.exists()) continue;
            return file;
        }
        return null;
    }

    private void waitForFiles() throws InterruptedException {
        String s = this.getArgs().getOpt("waitForFiles");
        if (s != null && !s.trim().isEmpty()) {
            File missing;
            String[] paths = s.trim().split(":");
            File[] files = new File[paths.length];
            for (int i = 0; i < paths.length; ++i) {
                files[i] = new File(paths[i]);
            }
            while ((missing = this.firstMissing(files)) != null) {
                this.warn(String.format("File missing: %s; sleeping %d seconds", missing, 30L));
                Thread.sleep(30000L);
            }
        }
    }

    private void executeSetup() throws IOException, CommandException {
        this.executeDefinedSetup();
        if (this._setupFile != null && this._setupFile.isFile()) {
            for (CellSetupProvider provider : this._setupProviders) {
                provider.beforeSetup();
            }
            this.execFile(this._setupFile);
            for (CellSetupProvider provider : this._setupProviders) {
                provider.afterSetup();
            }
        }
    }

    private Object getBean(String name) {
        try {
            if (this._context != null && this._context.isSingleton(name)) {
                return this._context.getBean(name);
            }
        }
        catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
            // empty catch block
        }
        return null;
    }

    private List<String> getDependentBeans(String name) {
        if (this._context == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(this._context.getBeanFactory().getDependentBeans(name));
    }

    private List<String> getBeanNames() {
        if (this._context == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(this._context.getBeanFactory().getSingletonNames());
    }

    public void getInfo(PrintWriter pw) {
        ConfigurableListableBeanFactory factory = this._context.getBeanFactory();
        for (Map.Entry<CellInfoProvider, String> entry : this._infoProviders.entrySet()) {
            CellInfoProvider provider = entry.getKey();
            String name = entry.getValue();
            try {
                BeanDefinition definition = factory.getBeanDefinition(name);
                String description = definition.getDescription();
                if (description != null) {
                    pw.println(String.format("--- %s (%s) ---", name, description));
                } else {
                    pw.println(String.format("--- %s ---", name));
                }
                provider.getInfo(pw);
                pw.println();
            }
            catch (NoSuchBeanDefinitionException e) {
                this.error("Failed to query bean definition for " + name);
            }
        }
    }

    public CellInfo getCellInfo() {
        CellInfo info = super.getCellInfo();
        for (CellInfoProvider provider : this._infoProviders.keySet()) {
            info = provider.getCellInfo(info);
        }
        return info;
    }

    protected void printSetup(PrintWriter pw) {
        pw.println("#\n# Created by " + this.getCellName() + "(" + this.getNucleus().getCellClass() + ") at " + new Date().toString() + "\n#");
        for (CellSetupProvider provider : this._setupProviders) {
            provider.printSetup(pw);
        }
    }

    public String ac_save(Args args) throws IOException, IllegalArgumentException, NoRouteToCellException {
        String controller = args.getOpt("sc");
        String file = args.getOpt("file");
        if ("none".equals(controller)) {
            controller = null;
            file = this._setupFile.getPath();
        } else if (file == null && controller == null) {
            controller = this._setupController;
            file = this._setupFile.getPath();
        }
        Preconditions.checkArgument((file != null || controller != null ? 1 : 0) != 0, (Object)"Either a setup controller or setup file must be specified");
        if (controller != null) {
            Preconditions.checkState((!Strings.isNullOrEmpty((String)this._setupClass) ? 1 : 0) != 0, (Object)"Cannot save to a setup controller since the cell has no setup class");
            try {
                StringWriter sw = new StringWriter();
                this.printSetup(new PrintWriter(sw));
                SetupInfoMessage info = new SetupInfoMessage("put", this.getCellName(), this._setupClass, (Serializable)((Object)sw.toString()));
                this.sendMessage(new CellMessage(new CellPath(controller), (Serializable)info));
            }
            catch (NoRouteToCellException e) {
                throw new NoRouteToCellException("Failed to send setup to " + controller + ": " + e.getMessage());
            }
        }
        if (file != null) {
            File path = new File(file).getAbsoluteFile();
            File directory = path.getParentFile();
            File temp = File.createTempFile(path.getName(), null, directory);
            temp.deleteOnExit();
            try (PrintWriter pw = new PrintWriter(new FileWriter(temp));){
                this.printSetup(pw);
            }
            UniversalSpringCell.renameWithBackup(temp, path);
        }
        return "";
    }

    private static void renameWithBackup(File source, File dest) throws IOException {
        File backup = new File(dest.getPath() + ".bak");
        if (dest.exists()) {
            if (!dest.isFile()) {
                throw new IOException("Cannot rename " + dest + ": Not a file");
            }
            if (backup.exists()) {
                if (!backup.isFile()) {
                    throw new IOException("Cannot delete " + backup + ": Not a file");
                }
                if (!backup.delete()) {
                    throw new IOException("Failed to delete " + backup);
                }
            }
            if (!dest.renameTo(backup)) {
                throw new IOException("Failed to rename " + dest);
            }
        }
        if (!source.renameTo(dest)) {
            throw new IOException("Failed to rename" + source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void execFile(File setup) throws IOException, CommandException {
        BufferedReader br = new BufferedReader(new FileReader(setup));
        try {
            String line;
            int lineCount = 0;
            while ((line = br.readLine()) != null) {
                ++lineCount;
                if ((line = line.trim()).length() == 0 || line.charAt(0) == '#') continue;
                try {
                    this.command(new Args((CharSequence)line));
                }
                catch (CommandException e) {
                    throw new CommandException("Error at line " + lineCount + ": " + e.getMessage());
                    return;
                }
            }
        }
        finally {
            try {
                br.close();
            }
            catch (IOException e) {}
        }
    }

    public String ac_reload(Args args) throws IOException, CommandException {
        if (!args.hasOption("yes")) {
            return " This command destroys the current setup\n and replaces it by the setup on disk\n Please use 'reload -yes' if you really want\n to do that.";
        }
        if (this._setupFile != null && !this._setupFile.exists()) {
            return String.format("Setup file [%s] does not exist", this._setupFile);
        }
        this.executeSetup();
        return "";
    }

    public String ac_infox_$_1(Args args) {
        String name = args.argv(0);
        Object bean = this.getBean(name);
        if (CellInfoProvider.class.isInstance(bean)) {
            StringWriter s = new StringWriter();
            PrintWriter pw = new PrintWriter(s);
            ((CellInfoProvider)bean).getInfo(pw);
            return s.toString();
        }
        return "No such bean: " + name;
    }

    public String ac_bean_ls(Args args) {
        String format = "%-30s %s\n";
        Formatter s = new Formatter(new StringBuilder());
        ConfigurableListableBeanFactory factory = this._context.getBeanFactory();
        s.format("%-30s %s\n", "Bean", "Description");
        s.format("%-30s %s\n", "----", "-----------");
        for (String name : this.getBeanNames()) {
            if (name.startsWith("org.springframework.")) continue;
            try {
                BeanDefinition definition = factory.getBeanDefinition(name);
                String description = definition.getDescription();
                s.format("%-30s %s\n", name, description != null ? description : "-");
            }
            catch (NoSuchBeanDefinitionException e) {
                this.debug("Failed to query bean definition for " + name);
            }
        }
        return s.toString();
    }

    public String ac_bean_dep(Args args) {
        String format = "%-30s %s\n";
        Formatter s = new Formatter(new StringBuilder());
        s.format("%-30s %s\n", "Bean", "Used by");
        s.format("%-30s %s\n", "----", "-------");
        for (String name : this.getBeanNames()) {
            s.format("%-30s %s\n", name, Joiner.on((String)",").join(this.getDependentBeans(name)));
        }
        return s.toString();
    }

    private Object getBeanProperty(String s) {
        String[] a = s.split("\\.", 2);
        Object o = this.getBean(a[0]);
        if (o != null && a.length == 2) {
            BeanWrapperImpl bean = new BeanWrapperImpl(o);
            o = bean.isReadableProperty(a[1]) ? bean.getPropertyValue(a[1]) : null;
        }
        return o;
    }

    private CharSequence valueToString(Object value) {
        if (value == null) {
            return "";
        }
        if (value.getClass().isArray()) {
            Class<?> componentType = value.getClass().getComponentType();
            if (componentType == Boolean.TYPE) {
                return Arrays.toString((boolean[])value);
            }
            if (componentType == Byte.TYPE) {
                return Arrays.toString((byte[])value);
            }
            if (componentType == Character.TYPE) {
                return Arrays.toString((char[])value);
            }
            if (componentType == Double.TYPE) {
                return Arrays.toString((double[])value);
            }
            if (componentType == Float.TYPE) {
                return Arrays.toString((float[])value);
            }
            if (componentType == Integer.TYPE) {
                return Arrays.toString((int[])value);
            }
            if (componentType == Long.TYPE) {
                return Arrays.toString((long[])value);
            }
            if (componentType == Short.TYPE) {
                return Arrays.toString((short[])value);
            }
            return Arrays.deepToString((Object[])value);
        }
        return value.toString();
    }

    public String ac_bean_properties_$_1(Args args) {
        String name = args.argv(0);
        Object o = this.getBeanProperty(name);
        if (o != null) {
            StringBuilder s = new StringBuilder();
            BeanWrapperImpl bean = new BeanWrapperImpl(o);
            for (PropertyDescriptor p : bean.getPropertyDescriptors()) {
                String property;
                if (p.isHidden() || !bean.isReadableProperty(property = p.getName())) continue;
                Object value = bean.getPropertyValue(property);
                s.append(property).append('=').append(this.valueToString(value));
                if (!bean.isWritableProperty(property)) {
                    s.append(" [read-only]");
                }
                s.append('\n');
            }
            return s.toString();
        }
        return "No such bean: " + name;
    }

    public String ac_bean_property_$_1(Args args) {
        String name = args.argv(0);
        Object o = this.getBeanProperty(name);
        return o != null ? String.valueOf(this.valueToString(o)) : "No such bean: " + name;
    }

    protected String getMessageName(Class<?> c) {
        String name = c.getSimpleName();
        int length = name.length();
        if (length > 7 && name.endsWith("Message")) {
            name = name.substring(0, name.length() - 7);
        } else if (length > 3 && name.endsWith("Msg")) {
            name = name.substring(0, name.length() - 3);
        }
        return name;
    }

    public String ac_bean_messages_$_0_1(Args args) {
        switch (args.argc()) {
            case 0: {
                ArrayListMultimap nameToClassMap = ArrayListMultimap.create();
                for (String name : this.getBeanNames()) {
                    Object bean = this.getBean(name);
                    if (!CellMessageReceiver.class.isInstance(bean)) continue;
                    Collection<Class<? extends Serializable>> types = this._messageDispatcher.getMessageTypes(bean);
                    nameToClassMap.putAll((Object)name, types);
                }
                Multimap classToNameMap = Multimaps.invertFrom((Multimap)nameToClassMap, (Multimap)ArrayListMultimap.create());
                String format = "%-40s %s\n";
                Formatter f = new Formatter(new StringBuilder());
                f.format("%-40s %s\n", "Message", "Receivers");
                f.format("%-40s %s\n", "-------", "---------");
                for (Map.Entry e : classToNameMap.asMap().entrySet()) {
                    f.format("%-40s %s\n", this.getMessageName((Class)e.getKey()), Joiner.on((String)",").join((Iterable)e.getValue()));
                }
                return f.toString();
            }
            case 1: {
                String name = args.argv(0);
                Object bean = this.getBean(name);
                if (CellMessageReceiver.class.isInstance(bean)) {
                    StringBuilder s = new StringBuilder();
                    Collection<Class<? extends Serializable>> types = this._messageDispatcher.getMessageTypes(bean);
                    for (Class<? extends Serializable> t : types) {
                        s.append(this.getMessageName(t)).append('\n');
                    }
                    return s.toString();
                }
                return "No such bean: " + name;
            }
        }
        return "";
    }

    public BeanQueryMessage messageArrived(BeanQueryAllPropertiesMessage message) throws CacheException {
        HashMap beans = Maps.newHashMap();
        for (String name : this.getBeanNames()) {
            beans.put(name, this.getBean(name));
        }
        message.setResult(this.serialize(beans));
        return message;
    }

    public BeanQueryMessage messageArrived(BeanQuerySinglePropertyMessage message) throws CacheException {
        Object o = this.getBeanProperty(message.getPropertyName());
        if (o == null) {
            throw new CacheException("No such property");
        }
        message.setResult(this.serialize(o));
        return message;
    }

    private Object serialize(Set<Object> prune, Queue<Map.Entry<String, Object>> queue, Object o) {
        if (o == null || PRIMITIVES.contains(o.getClass())) {
            return o;
        }
        if (TERMINALS.contains(o.getClass())) {
            return o.toString();
        }
        if (o.getClass().isEnum()) {
            return o;
        }
        if (o.getClass().isArray()) {
            int len = Array.getLength(o);
            ArrayList values = Lists.newArrayListWithCapacity((int)len);
            for (int i = 0; i < len; ++i) {
                values.add(this.serialize(prune, queue, Array.get(o, i)));
            }
            return values;
        }
        if (o instanceof Map) {
            Map map = (Map)o;
            HashMap values = Maps.newHashMapWithExpectedSize((int)map.size());
            for (Map.Entry e : map.entrySet()) {
                values.put(String.valueOf(e.getKey()), this.serialize(prune, queue, e.getValue()));
            }
            return values;
        }
        if (o instanceof Set) {
            Collection collection = (Collection)o;
            HashSet values = Sets.newHashSetWithExpectedSize((int)collection.size());
            for (Object entry : collection) {
                values.add(this.serialize(prune, queue, entry));
            }
            return values;
        }
        if (o instanceof Collection) {
            Collection collection = (Collection)o;
            ArrayList values = Lists.newArrayListWithCapacity((int)collection.size());
            for (Object entry : collection) {
                values.add(this.serialize(prune, queue, entry));
            }
            return values;
        }
        if (o instanceof Iterable) {
            Iterable collection = (Iterable)o;
            ArrayList values = Lists.newArrayList();
            for (Object entry : collection) {
                values.add(this.serialize(prune, queue, entry));
            }
            return values;
        }
        if (prune.contains(o)) {
            return o.toString();
        }
        prune.add(o);
        HashMap values = Maps.newHashMap();
        BeanWrapperImpl bean = new BeanWrapperImpl(o);
        for (PropertyDescriptor p : bean.getPropertyDescriptors()) {
            String property;
            if (p.isHidden() || !bean.isReadableProperty(property = p.getName())) continue;
            try {
                values.put(property, bean.getPropertyValue(property));
            }
            catch (InvalidPropertyException | PropertyAccessException e) {
                _log.debug("Failed to read {} of object of class {}: {}", new Object[]{property, o.getClass(), e.getMessage()});
            }
        }
        if (values.isEmpty()) {
            return o.toString();
        }
        queue.addAll(values.entrySet());
        return values;
    }

    private Object serialize(Object o) {
        Map.Entry entry;
        HashSet prune = Sets.newHashSet();
        ArrayDeque<Map.Entry<String, Object>> queue = new ArrayDeque<Map.Entry<String, Object>>();
        Object result = this.serialize(prune, queue, o);
        while ((entry = (Map.Entry)queue.poll()) != null) {
            entry.setValue(this.serialize(prune, queue, entry.getValue()));
        }
        return result;
    }

    public void addInfoProviderBean(CellInfoProvider bean, String name) {
        this._infoProviders.put(bean, name);
    }

    public void addMessageReceiver(CellMessageReceiver bean) {
        this.addMessageListener(bean);
    }

    public void addMessageSender(CellMessageSender bean) {
        bean.setCellEndpoint((CellEndpoint)this);
    }

    public void addSetupProviderBean(CellSetupProvider bean) {
        this._setupProviders.add(bean);
    }

    public void addLifeCycleAwareBean(CellLifeCycleAware bean) {
        this._lifeCycleAware.add(bean);
    }

    public void addThreadFactoryAwareBean(ThreadFactoryAware bean) {
        bean.setThreadFactory((ThreadFactory)this.getNucleus());
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof CellCommandListener) {
            this.addCommandListener(bean);
        }
        if (bean instanceof CellInfoProvider) {
            this.addInfoProviderBean((CellInfoProvider)bean, beanName);
        }
        if (bean instanceof CellMessageReceiver) {
            this.addMessageReceiver((CellMessageReceiver)bean);
        }
        if (bean instanceof CellMessageSender) {
            this.addMessageSender((CellMessageSender)bean);
        }
        if (bean instanceof CellSetupProvider) {
            this.addSetupProviderBean((CellSetupProvider)bean);
        }
        if (bean instanceof CellLifeCycleAware) {
            this.addLifeCycleAwareBean((CellLifeCycleAware)bean);
        }
        if (bean instanceof ThreadFactoryAware) {
            this.addThreadFactoryAwareBean((ThreadFactoryAware)bean);
        }
        if (bean instanceof EnvironmentAware) {
            ((EnvironmentAware)bean).setEnvironment(this._environment);
        }
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    private void mergeProperties(Properties properties, Map<String, ?> entries) {
        for (Map.Entry<String, ?> e : entries.entrySet()) {
            String key = e.getKey();
            Object value = e.getValue();
            properties.setProperty(key, value.toString());
        }
    }

    class UniversalSpringCellApplicationContext
    extends ClassPathXmlApplicationContext {
        UniversalSpringCellApplicationContext(Args args) {
            super(args.argv(0));
        }

        private ByteArrayResource getArgumentsResource() {
            Args args = new Args(UniversalSpringCell.this.getArgs());
            args.shift();
            Properties properties = new Properties();
            String arguments = args.toString().replaceAll("-\\$\\{[0-9]+\\}", "");
            properties.setProperty("arguments", arguments);
            UniversalSpringCell.this.mergeProperties(properties, (Map)args.optionsAsMap());
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                properties.store(out, "");
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
            byte[] _domainContext = out.toByteArray();
            return new ByteArrayResource(_domainContext){

                public String getFilename() {
                    return "arguments.properties";
                }
            };
        }

        public Resource getResource(String location) {
            if (location.startsWith("arguments:")) {
                return this.getArgumentsResource();
            }
            return super.getResource(location);
        }

        protected void customizeBeanFactory(DefaultListableBeanFactory beanFactory) {
            super.customizeBeanFactory(beanFactory);
            beanFactory.addBeanPostProcessor((BeanPostProcessor)UniversalSpringCell.this);
        }

        public synchronized ConfigurableEnvironment getEnvironment() {
            Object[] profiles;
            ConfigurableEnvironment environment = super.getEnvironment();
            Args args = UniversalSpringCell.this.getArgs();
            if (args.hasOption("profiles") && !Arrays.equals(profiles = args.getOption("profiles").split(","), environment.getActiveProfiles())) {
                environment.setActiveProfiles((String[])profiles);
            }
            return environment;
        }
    }
}

