/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.cells;

import diskCacheV111.util.CacheException;
import diskCacheV111.util.TimeoutCacheException;
import diskCacheV111.vehicles.Message;
import dmg.cells.nucleus.CellEndpoint;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.CellMessageAnswerable;
import dmg.cells.nucleus.CellPath;
import dmg.cells.nucleus.NoRouteToCellException;
import java.io.Serializable;
import org.dcache.cells.CellMessageSender;
import org.dcache.cells.MessageCallback;
import org.dcache.util.CacheExceptionFactory;

public class CellStub
implements CellMessageSender {
    private CellEndpoint _endpoint;
    private CellPath _destination;
    private long _timeout = 30000L;
    private boolean _retryOnNoRouteToCell;

    public CellStub() {
    }

    public CellStub(CellEndpoint endpoint) {
        this.setCellEndpoint(endpoint);
    }

    public CellStub(CellEndpoint endpoint, CellPath destination) {
        this(endpoint);
        this.setDestinationPath(destination);
    }

    public CellStub(CellEndpoint endpoint, CellPath destination, long timeout) {
        this(endpoint, destination);
        this.setTimeout(timeout);
    }

    @Override
    public void setCellEndpoint(CellEndpoint endpoint) {
        this._endpoint = endpoint;
    }

    public void setDestination(String destination) {
        this.setDestinationPath(new CellPath(destination));
    }

    public void setDestinationPath(CellPath destination) {
        this._destination = destination;
    }

    public CellPath getDestinationPath() {
        return this._destination;
    }

    public void setTimeout(long timeout) {
        this._timeout = timeout;
    }

    public long getTimeout() {
        return this._timeout;
    }

    public void setRetryOnNoRouteToCell(boolean retry) {
        this._retryOnNoRouteToCell = retry;
    }

    public boolean getRetryOnNoRouteToCell() {
        return this._retryOnNoRouteToCell;
    }

    public <T extends Message> T sendAndWait(T msg) throws CacheException, InterruptedException {
        return this.sendAndWait(msg, this._timeout);
    }

    public <T extends Message> T sendAndWait(T msg, long timeout) throws CacheException, InterruptedException {
        return this.sendAndWait(this._destination, msg, timeout);
    }

    public <T extends Message> T sendAndWait(CellPath path, T msg) throws CacheException, InterruptedException {
        msg.setReplyRequired(true);
        Message reply = (Message)this.sendAndWait(path, msg, msg.getClass());
        if (reply.getReturnCode() != 0) {
            throw CacheExceptionFactory.exceptionOf(reply);
        }
        return (T)reply;
    }

    public <T extends Serializable> T sendAndWait(Serializable msg, Class<T> type) throws CacheException, InterruptedException {
        return this.sendAndWait(this._destination, msg, type);
    }

    public <T extends Serializable> T sendAndWait(CellPath path, Serializable msg, Class<T> type) throws CacheException, InterruptedException {
        return this.sendAndWait(path, msg, type, this._timeout);
    }

    public <T extends Serializable> T sendAndWait(Serializable msg, Class<T> type, long timeout) throws CacheException, InterruptedException {
        return this.sendAndWait(this._destination, msg, type, timeout);
    }

    public <T extends Message> T sendAndWait(CellPath path, T msg, long timeout) throws CacheException, InterruptedException {
        msg.setReplyRequired(true);
        Message reply = (Message)this.sendAndWait(path, msg, msg.getClass(), timeout);
        if (reply.getReturnCode() != 0) {
            throw CacheExceptionFactory.exceptionOf(reply);
        }
        return (T)reply;
    }

    public <T extends Serializable> T sendAndWait(CellPath path, Serializable msg, Class<T> type, long timeout) throws CacheException, InterruptedException {
        CellMessage replyMessage;
        try {
            CellMessage envelope = new CellMessage(path, msg);
            replyMessage = this._retryOnNoRouteToCell ? this._endpoint.sendAndWaitToPermanent(envelope, timeout) : this._endpoint.sendAndWait(envelope, timeout);
        }
        catch (NoRouteToCellException e) {
            throw new TimeoutCacheException(e.getMessage());
        }
        if (replyMessage == null) {
            String errmsg = String.format("Request to %s timed out.", path);
            throw new TimeoutCacheException(errmsg);
        }
        Serializable replyObject = replyMessage.getMessageObject();
        if (!type.isInstance(replyObject)) {
            String errmsg = "Got unexpected message of class " + replyObject.getClass() + " from " + replyMessage.getSourcePath();
            throw new CacheException(10011, errmsg);
        }
        return (T)replyObject;
    }

    public <T extends Serializable> void send(Serializable message, Class<T> type, MessageCallback<T> callback) {
        if (this._destination == null) {
            throw new IllegalStateException("Destination must be specified");
        }
        this.send(this._destination, message, type, callback);
    }

    public <T extends Serializable> void send(CellPath destination, Serializable message, Class<T> type, MessageCallback<T> callback) {
        if (message instanceof Message) {
            ((Message)message).setReplyRequired(true);
        }
        this._endpoint.sendMessage(new CellMessage(destination, message), new CellCallback<T>(type, callback), this._timeout);
    }

    public void send(Serializable message) throws NoRouteToCellException {
        if (this._destination == null) {
            throw new IllegalStateException("Destination must be specified");
        }
        this.send(this._destination, message);
    }

    public void send(CellPath destination, Serializable message) throws NoRouteToCellException {
        this._endpoint.sendMessage(new CellMessage(destination, message));
    }

    static class CellCallback<T>
    implements CellMessageAnswerable {
        private final MessageCallback<T> _callback;
        private final Class<T> _type;

        CellCallback(Class<T> type, MessageCallback<T> callback) {
            this._callback = callback;
            this._type = type;
        }

        public void answerArrived(CellMessage request, CellMessage answer) {
            Serializable o = answer.getMessageObject();
            if (this._type.isInstance(o)) {
                this._callback.setReply(this._type.cast(o));
                if (o instanceof Message) {
                    Message msg = (Message)o;
                    int rc = msg.getReturnCode();
                    if (rc == 0) {
                        this._callback.success();
                    } else {
                        this._callback.failure(rc, msg.getErrorObject());
                    }
                } else {
                    this._callback.success();
                }
            } else if (o instanceof Exception) {
                this.exceptionArrived(request, (Exception)o);
            } else {
                this._callback.failure(10011, "Unexpected reply: " + o);
            }
        }

        public void answerTimedOut(CellMessage request) {
            this._callback.timeout(request.getDestinationPath());
        }

        public void exceptionArrived(CellMessage request, Exception exception) {
            if (exception instanceof NoRouteToCellException) {
                this._callback.noroute(request.getDestinationPath());
            } else if (exception instanceof CacheException) {
                CacheException e = (CacheException)exception;
                this._callback.failure(e.getRc(), CacheExceptionFactory.exceptionOf(e.getRc(), e.getMessage()));
            } else {
                this._callback.failure(10011, exception.toString());
            }
        }
    }
}

