/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.cells;

import diskCacheV111.util.CacheException;
import diskCacheV111.vehicles.Message;
import dmg.cells.nucleus.CDC;
import dmg.cells.nucleus.CellAdapter;
import dmg.cells.nucleus.CellEndpoint;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.NoRouteToCellException;
import dmg.cells.nucleus.Reply;
import dmg.cells.nucleus.UOID;
import dmg.util.Args;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import org.dcache.cells.CellMessageDispatcher;
import org.dcache.cells.CellMessageReceiver;
import org.dcache.cells.MessageProcessingMonitor;
import org.dcache.cells.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractCell
extends CellAdapter
implements CellMessageReceiver {
    private static final String MSG_UOID_MISMATCH = "A reply [%s] was generated by a message listener, but the message UOID indicates that another message listener has already replied to the message.";
    @Option(name="monitor", description="Cell message monitoring", defaultValue="false")
    protected boolean _isMonitoringEnabled;
    @Option(name="cellClass", description="Cell classification")
    protected String _cellClass;
    protected static final Timer _timer = new Timer("Cell timer", true);
    private TimerTask _timeoutTask;
    protected Logger _logger;
    protected final CellMessageDispatcher _messageDispatcher = new CellMessageDispatcher("messageArrived");
    protected final CellMessageDispatcher _forwardDispatcher = new CellMessageDispatcher("messageToForward");
    protected String _definedSetup;
    protected MessageProcessingMonitor _monitor;

    private static Args stripDefinedSetup(Args args) {
        if ((args = new Args(args)).argc() > 0 && args.argv(0).startsWith("!")) {
            args.shift();
        }
        return args;
    }

    private static String getDefinedSetup(Args args) {
        if (args.argc() > 0 && args.argv(0).startsWith("!")) {
            return args.argv(0).substring(1);
        }
        return null;
    }

    private static String getCellType(Args args) {
        String type = args.getOpt("cellType");
        return type == null ? "Generic" : type;
    }

    public AbstractCell(String cellName, String arguments) {
        this(cellName, new Args((CharSequence)arguments));
    }

    public AbstractCell(String cellName, Args arguments) {
        this(cellName, AbstractCell.getCellType(arguments), arguments);
    }

    public AbstractCell(String cellName, String cellType, Args arguments) {
        super(cellName, cellType, AbstractCell.stripDefinedSetup(arguments), false);
        this._logger = LoggerFactory.getLogger(this.getClass());
        this._definedSetup = AbstractCell.getDefinedSetup(arguments);
    }

    public void cleanUp() {
        super.cleanUp();
        if (this._timeoutTask != null) {
            this._timeoutTask.cancel();
        }
    }

    protected final void doInit() throws InterruptedException, ExecutionException {
        try {
            this.parseOptions();
            this._monitor = new MessageProcessingMonitor();
            this._monitor.setCellEndpoint((CellEndpoint)this);
            this._monitor.setEnabled(this._isMonitoringEnabled);
            if (this._cellClass != null) {
                this.getNucleus().setCellClass(this._cellClass);
            }
            this.addMessageListener(this);
            this.addCommandListener(this._monitor);
            FutureTask<Object> task = new FutureTask<Object>(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    AbstractCell.this.executeInit();
                    return null;
                }
            });
            this.getNucleus().newThread(task, "init").start();
            task.get();
            this.start();
        }
        catch (InterruptedException e) {
            this._logger.info("Cell initialisation was interrupted.");
            this.start();
            this.kill();
            throw e;
        }
        catch (ExecutionException e) {
            Throwable t = e.getCause();
            if (t instanceof RuntimeException) {
                this._logger.error("Failed to initialise cell: " + t.getMessage(), t);
            }
            this.start();
            this.kill();
            throw e;
        }
        catch (RuntimeException e) {
            this._logger.error("Failed to initialise cell: " + e.getMessage(), (Throwable)e);
            this.start();
            this.kill();
            throw e;
        }
    }

    protected void executeInit() throws Exception {
        this.executeDefinedSetup();
        this.init();
        this.startTimeoutTask();
    }

    protected void startTimeoutTask() {
        if (this._timeoutTask != null) {
            throw new IllegalStateException("Timeout task is already running");
        }
        final CDC cdc = new CDC();
        this._timeoutTask = new TimerTask(){

            @Override
            public void run() {
                try (CDC ignored = cdc.restore();){
                    AbstractCell.this.getNucleus().updateWaitQueue();
                }
                catch (Throwable e) {
                    Thread t = Thread.currentThread();
                    t.getUncaughtExceptionHandler().uncaughtException(t, e);
                }
            }
        };
        _timer.schedule(this._timeoutTask, 30000L, 30000L);
    }

    protected void executeDefinedSetup() {
        if (this._definedSetup != null) {
            this.executeDomainContext(this._definedSetup);
        }
    }

    protected void init() throws Exception {
    }

    protected String getFriendlyName() {
        return this.getCellName();
    }

    public void debug(String str) {
        this._logger.debug(str);
    }

    public void debug(Throwable t) {
        this._logger.debug(t.getMessage());
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        for (String s : sw.toString().split("\n")) {
            this._logger.debug(s);
        }
    }

    public void info(String str) {
        this._logger.info(str);
    }

    public void warn(String str) {
        this._logger.warn(str);
    }

    public void error(String str) {
        this._logger.error(str);
    }

    public void error(Throwable t) {
        this._logger.error(t.getMessage());
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        for (String s : sw.toString().split("\n")) {
            this._logger.error(s);
        }
    }

    public void fatal(String str) {
        this._logger.error(str);
    }

    public void fatal(Throwable t) {
        this._logger.error(t.getMessage());
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        for (String s : sw.toString().split("\n")) {
            this._logger.error(s);
        }
    }

    @Deprecated
    public void say(String s) {
        this.info(s);
    }

    @Deprecated
    public void esay(String s) {
        this.error(s);
    }

    @Deprecated
    public void esay(Throwable t) {
        this.error(t);
    }

    public static <T> T toType(Object object, Class<T> type) {
        T result = null;
        if (object == null) {
            if (type == Boolean.TYPE) {
                result = Boolean.class.cast(false);
            } else if (type == Byte.TYPE) {
                result = Byte.class.cast(0);
            } else if (type == Character.TYPE) {
                result = Character.class.cast(0);
            } else if (type == Double.TYPE) {
                result = Double.class.cast(0.0);
            } else if (type == Float.TYPE) {
                result = Float.class.cast(0.0);
            } else if (type == Integer.TYPE) {
                result = Integer.class.cast(0);
            } else if (type == Long.TYPE) {
                result = Long.class.cast(0);
            } else if (type == Short.TYPE) {
                result = Short.class.cast(0);
            }
        } else {
            String so = object.toString();
            if (type == BigInteger.class) {
                result = type.cast(new BigInteger(so));
            } else if (type == Boolean.class || type == Boolean.TYPE) {
                Boolean r = "1".equals(so) || "true".equalsIgnoreCase(so) || "yes".equalsIgnoreCase(so) || "on".equalsIgnoreCase(so) || "enabled".equalsIgnoreCase(so) ? Boolean.TRUE : ("0".equals(object) || "false".equalsIgnoreCase(so) || "no".equalsIgnoreCase(so) || "off".equalsIgnoreCase(so) || "disabled".equalsIgnoreCase(so) ? Boolean.FALSE : Boolean.valueOf(so));
                result = type == Boolean.TYPE ? (T)Boolean.class.cast(r) : (T)type.cast(r);
            } else if (type == Byte.class || type == Byte.TYPE) {
                Byte i = Byte.valueOf(so);
                result = type == Byte.TYPE ? (T)Byte.class.cast(i) : (T)type.cast(i);
            } else if (type == Character.class || type == Character.TYPE) {
                Character i = Character.valueOf(so.charAt(0));
                result = type == Character.TYPE ? (T)Character.class.cast(i) : (T)type.cast(i);
            } else if (type == Double.class || type == Double.TYPE) {
                Double i = Double.valueOf(so);
                result = type == Double.TYPE ? (T)Double.class.cast(i) : (T)type.cast(i);
            } else if (type == Float.class || type == Float.TYPE) {
                Float i = Float.valueOf(so);
                result = type == Float.TYPE ? (T)Float.class.cast(i) : (T)type.cast(i);
            } else if (type == Integer.class || type == Integer.TYPE) {
                Integer i = Integer.valueOf(so);
                result = type == Integer.TYPE ? (T)Integer.class.cast(i) : (T)type.cast(i);
            } else if (type == Long.class || type == Long.TYPE) {
                Long i = Long.valueOf(so);
                result = type == Long.TYPE ? (T)Long.class.cast(i) : (T)type.cast(i);
            } else if (type == Short.class || type == Short.TYPE) {
                Short i = Short.valueOf(so);
                result = type == Short.TYPE ? (T)Short.class.cast(i) : (T)type.cast(i);
            } else {
                try {
                    Constructor<T> constructor = type.getConstructor(String.class);
                    result = constructor.newInstance(object);
                }
                catch (NoSuchMethodException e) {
                    result = type.cast(object);
                }
                catch (SecurityException e) {
                    result = type.cast(object);
                }
                catch (InstantiationException e) {
                    result = type.cast(object);
                }
                catch (IllegalAccessException e) {
                    result = type.cast(object);
                }
                catch (InvocationTargetException e) {
                    result = type.cast(object);
                }
            }
        }
        return result;
    }

    protected String getOption(Option option) {
        String s = this.getArgs().getOpt(option.name());
        if (!(s == null || s.length() <= 0 && option.required())) {
            return s;
        }
        s = (String)this.getDomainContext().get(option.name());
        if (!(s == null || s.length() <= 0 && option.required())) {
            return s;
        }
        if (option.required()) {
            throw new IllegalArgumentException(option.name() + " is a required argument");
        }
        return option.defaultValue();
    }

    protected void parseOptions() {
        for (Class<?> c = this.getClass(); c != null; c = c.getSuperclass()) {
            for (Field field : c.getDeclaredFields()) {
                Option option = field.getAnnotation(Option.class);
                try {
                    Object value;
                    if (option == null) continue;
                    field.setAccessible(true);
                    String s = this.getOption(option);
                    if (s != null && s.length() > 0) {
                        try {
                            value = AbstractCell.toType(s, field.getType());
                            field.set(this, value);
                        }
                        catch (ClassCastException e) {
                            throw new IllegalArgumentException("Cannot convert '" + s + "' to " + field.getType(), e);
                        }
                    } else {
                        value = field.get(this);
                    }
                    if (!option.log()) continue;
                    String description = option.description();
                    String unit = option.unit();
                    if (description.length() == 0) {
                        description = option.name();
                    }
                    if (unit.length() > 0) {
                        this.info(description + " set to " + value + " " + unit);
                        continue;
                    }
                    this.info(description + " set to " + value);
                }
                catch (IllegalAccessException | SecurityException e) {
                    throw new RuntimeException("Bug detected while processing option " + option.name(), e);
                }
            }
        }
    }

    protected void writeOptions(PrintWriter out) {
        for (Class<?> c = this.getClass(); c != null; c = c.getSuperclass()) {
            for (Field field : c.getDeclaredFields()) {
                Option option = field.getAnnotation(Option.class);
                try {
                    if (option == null || !option.log()) continue;
                    field.setAccessible(true);
                    Object value = field.get(this);
                    String description = option.description();
                    String unit = option.unit();
                    if (description.length() == 0) {
                        description = option.name();
                    }
                    out.println(description + " is " + value + " " + unit);
                }
                catch (IllegalAccessException | SecurityException e) {
                    throw new RuntimeException("Bug detected while processing option " + option.name(), e);
                }
            }
        }
    }

    public void addMessageListener(CellMessageReceiver o) {
        this._messageDispatcher.addMessageListener(o);
        this._forwardDispatcher.addMessageListener(o);
    }

    public void removeMessageListener(CellMessageReceiver o) {
        this._messageDispatcher.removeMessageListener(o);
        this._forwardDispatcher.removeMessageListener(o);
    }

    private void sendReply(CellEndpoint endpoint, CellMessage envelope, Object result) {
        Serializable o = envelope.getMessageObject();
        if (o instanceof Message) {
            Message msg = (Message)o;
            if (!msg.getReplyRequired() && !(result instanceof Reply)) {
                return;
            }
            if (result instanceof CacheException) {
                CacheException e = (CacheException)result;
                msg.setFailed(e.getRc(), (Serializable)((Object)e.getMessage()));
                result = msg;
            } else if (result instanceof IllegalArgumentException) {
                msg.setFailed(10015, (Serializable)((Object)result.toString()));
                result = msg;
            } else if (result instanceof Exception) {
                msg.setFailed(10011, (Exception)result);
                result = msg;
            }
        }
        try {
            envelope.revertDirection();
            if (result instanceof Reply) {
                Reply reply = (Reply)result;
                reply.deliver(endpoint, envelope);
            } else {
                envelope.setMessageObject((Serializable)result);
                endpoint.sendMessage(envelope);
            }
        }
        catch (NoRouteToCellException e) {
            this._logger.error("Cannot deliver reply: No route to " + envelope.getDestinationPath());
        }
    }

    public void messageToForward(CellMessage envelope) {
        CellEndpoint endpoint = this._monitor.getReplyCellEndpoint(envelope);
        UOID uoid = envelope.getUOID();
        boolean isReply = this.isReply(envelope);
        Object result = this._forwardDispatcher.call(envelope);
        if (result != null && !isReply) {
            if (!uoid.equals((Object)envelope.getUOID())) {
                throw new RuntimeException(String.format(MSG_UOID_MISMATCH, result));
            }
            this.sendReply(endpoint, envelope, result);
        } else if (uoid.equals((Object)envelope.getUOID())) {
            envelope.nextDestination();
            try {
                endpoint.sendMessage(envelope);
            }
            catch (NoRouteToCellException e) {
                if (!isReply) {
                    this.sendReply((CellEndpoint)this, envelope, (Object)e);
                }
                this._logger.warn("Dropping message: No route to {}", (Object)envelope.getDestinationPath());
            }
        }
    }

    private boolean isReply(CellMessage envelope) {
        Serializable message = envelope.getMessageObject();
        return message instanceof Message && ((Message)message).isReply();
    }

    public void messageArrived(CellMessage envelope) {
        CellEndpoint endpoint = this._monitor.getReplyCellEndpoint(envelope);
        UOID uoid = envelope.getUOID();
        boolean isReply = this.isReply(envelope);
        Object result = this._messageDispatcher.call(envelope);
        if (result != null && !isReply) {
            if (!uoid.equals((Object)envelope.getUOID())) {
                throw new RuntimeException(String.format(MSG_UOID_MISMATCH, result));
            }
            this.sendReply(endpoint, envelope, result);
        }
    }
}

