/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.boot;

import java.io.PrintStream;
import org.dcache.boot.Domain;
import org.dcache.boot.Layout;
import org.dcache.boot.LayoutPrinter;
import org.dcache.util.ConfigurationProperties;
import org.dcache.util.ScopedConfigurationProperties;

public class PythonOracleLayoutPrinter
implements LayoutPrinter {
    private final Layout _layout;

    public PythonOracleLayoutPrinter(Layout layout) {
        this._layout = layout;
    }

    @Override
    public void print(PrintStream out) {
        new Request(out).print();
    }

    private static String markup(String in) {
        StringBuilder sb = new StringBuilder(in.length());
        for (int n : in.toCharArray()) {
            switch (n) {
                case 10: {
                    sb.append('\\');
                    n = 110;
                    break;
                }
                case 9: {
                    sb.append('\\');
                    n = 116;
                    break;
                }
                case 39: 
                case 92: {
                    sb.append('\\');
                }
            }
            sb.append((char)n);
        }
        return sb.toString();
    }

    private class IndentPrinter {
        private final PrintStream _inner;
        private final String _indent;

        public IndentPrinter(PrintStream inner) {
            this(inner, "");
        }

        private IndentPrinter(PrintStream inner, String indent) {
            this._inner = inner;
            this._indent = indent;
        }

        public void println() {
            this._inner.println();
        }

        public void println(String line) {
            if (line.length() == 0) {
                this._inner.println();
            } else {
                this._inner.println(this._indent + line);
            }
        }

        public IndentPrinter indent() {
            return new IndentPrinter(this._inner, this._indent + "   ");
        }
    }

    private class Request {
        private final PrintStream _out;

        public Request(PrintStream out) {
            this._out = out;
        }

        public void print() {
            IndentPrinter base = new IndentPrinter(this._out);
            base.println("class Properties:");
            this.printClass(base.indent());
            base.println("properties = Properties()");
        }

        public void printClass(IndentPrinter out) {
            out.println("\"\"\"Allows queries against dCache configuration\"\"\"");
            out.println("def __init__(self):");
            this.printInit(out.indent());
            out.println("def get(self, key, domain=None, service=None):");
            this.printGetDomainService(out.indent());
        }

        private void printGetDomainService(IndentPrinter out) {
            IndentPrinter indent = out.indent();
            out.println("if domain in self.service_scope and \\");
            out.println("      service in self.service_scope [domain] and \\");
            out.println("      key in self.service_scope [domain] [service]:");
            indent.println("return self.service_scope [domain] [service] [key]");
            out.println();
            out.println("if domain in self.domain_scope and \\");
            out.println("      key in self.domain_scope[domain]:");
            indent.println("return self.domain_scope [domain] [key]");
            out.println();
            out.println("if key in self.global_scope:");
            indent.println("return self.global_scope[key]");
            out.println();
            out.println("return None");
            out.println();
        }

        private void printInit(IndentPrinter out) {
            IndentPrinter indent = out.indent();
            out.println("self.global_scope = {");
            this.printGlobalScope(indent);
            indent.println("}");
            out.println();
            out.println("self.domain_scope = {");
            this.printDomainScope(indent);
            indent.println("}");
            out.println();
            out.println("self.service_scope = {");
            this.printServiceScope(indent);
            indent.println("}");
            out.println();
        }

        private void printGlobalScope(IndentPrinter out) {
            ConfigurationProperties properties = PythonOracleLayoutPrinter.this._layout.properties();
            for (String key : properties.stringPropertyNames()) {
                this.printEntry(out, key, properties.getValue(key));
            }
        }

        private void printDomainScope(IndentPrinter out) {
            IndentPrinter indent = out.indent();
            for (Domain domain : PythonOracleLayoutPrinter.this._layout.getDomains()) {
                String name = PythonOracleLayoutPrinter.markup(domain.getName());
                out.println("'" + name + "' : {");
                this.printProperties(indent, domain.properties(), PythonOracleLayoutPrinter.this._layout.properties());
                indent.println("},");
            }
        }

        private void printServiceScope(IndentPrinter out) {
            IndentPrinter indent = out.indent();
            for (Domain domain : PythonOracleLayoutPrinter.this._layout.getDomains()) {
                String name = PythonOracleLayoutPrinter.markup(domain.getName());
                out.println("'" + name + "' : {");
                this.printDomainServices(indent, domain);
                indent.println("},");
            }
        }

        private void printDomainServices(IndentPrinter out, Domain domain) {
            IndentPrinter indent = out.indent();
            for (ScopedConfigurationProperties service : domain.getServices()) {
                String name = service.getValue("cell.name");
                if (name == null) continue;
                out.println("'" + PythonOracleLayoutPrinter.markup(name) + "' : {");
                this.printProperties(indent, service, domain.properties());
                indent.println("},");
            }
        }

        private void printProperties(IndentPrinter out, ConfigurationProperties properties, ConfigurationProperties parentProperties) {
            for (String key : properties.stringPropertyNames()) {
                String value = properties.getValue(key);
                if (value.equals(parentProperties.getValue(key))) continue;
                this.printEntry(out, key, value);
            }
        }

        private void printEntry(IndentPrinter out, String key, String value) {
            String safeKey = PythonOracleLayoutPrinter.markup(key);
            String safeValue = PythonOracleLayoutPrinter.markup(value);
            out.println("'" + safeKey + "' : '" + safeValue + "',");
        }
    }
}

