/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.boot;

import com.google.common.base.Joiner;
import diskCacheV111.util.FsPath;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dcache.boot.Domain;
import org.dcache.util.ConfigurationProperties;
import org.dcache.util.NetworkUtils;

public class Layout {
    private static final int READ_AHEAD_LIMIT = 256;
    private static final Pattern SECTION_HEADER = Pattern.compile("^\\s*\\[([^\\]/]+)(/([^\\]/]+))?\\]\\s*$");
    private final ConfigurationProperties _properties;
    private final Map<String, Domain> _domains = new LinkedHashMap<String, Domain>();
    private String _source = "<unknown>";

    public Layout(ConfigurationProperties config) {
        this._properties = new ConfigurationProperties(config);
    }

    public ConfigurationProperties properties() {
        return this._properties;
    }

    public Collection<Domain> getDomains() {
        return Collections.unmodifiableCollection(this._domains.values());
    }

    public Domain getDomain(String name) {
        return this._domains.get(name);
    }

    public Domain createDomain(String name) {
        Domain domain = this._domains.get(name);
        if (domain == null) {
            domain = new Domain(name, this._properties);
            this._domains.put(name, domain);
            this._properties.put("dcache.domains", Joiner.on((String)" ").join(this._domains.keySet()));
        }
        return domain;
    }

    public void load(URI uri) throws URISyntaxException, IOException {
        URL url = NetworkUtils.toURL((URI)uri);
        this._source = new FsPath(url.getPath()).getName();
        try (InputStreamReader reader = new InputStreamReader(url.openStream());){
            this.load(reader);
        }
    }

    public void load(Reader in) throws IOException {
        String s;
        LineNumberReader reader = new LineNumberReader(in);
        this.loadSection(reader, this._properties);
        while ((s = reader.readLine()) != null) {
            Domain domain;
            Matcher matcher = SECTION_HEADER.matcher(s);
            if (!matcher.matches()) {
                throw new RuntimeException("Bug detected: Section header expected: " + s);
            }
            String domainName = this._properties.replaceKeywords(matcher.group(1));
            String serviceType = matcher.group(3);
            if (serviceType == null) {
                domain = this.createDomain(domainName);
                this.loadSection(reader, domain.properties());
                continue;
            }
            domain = this.getDomain(domainName);
            if (domain == null) {
                String message = String.format("Service declaration %s/%s lacks definition of domain %s", domainName, serviceType, domainName);
                this.discardSection(reader, message);
                continue;
            }
            this.loadSection(reader, domain.createService(serviceType));
        }
        for (Domain domain : this._domains.values()) {
            domain.properties().put("domain.cells", Joiner.on((String)" ").join(domain.getCellNames()));
        }
    }

    private void discardSection(LineNumberReader reader, String message) throws IOException {
        ConfigurationProperties.ProblemConsumer consumer = this._properties.getProblemConsumer();
        consumer.setFilename(this._source);
        consumer.setLineNumberReader(reader);
        consumer.error(message);
        this.loadSection(reader);
    }

    private void loadSection(LineNumberReader reader, ConfigurationProperties config) throws IOException {
        int linesRead = reader.getLineNumber();
        String section = this.loadSection(reader);
        config.load(this._source, linesRead, new StringReader(section));
    }

    private String loadSection(BufferedReader reader) throws IOException {
        String line;
        StringBuilder section = new StringBuilder();
        reader.mark(256);
        while ((line = reader.readLine()) != null && !SECTION_HEADER.matcher(line).matches()) {
            section.append(line).append('\n');
            reader.mark(256);
        }
        reader.reset();
        return section.toString();
    }

    public void printDomainNames(PrintStream out) {
        for (Domain domain : this._domains.values()) {
            out.println(domain.getName());
        }
    }

    public void printMatchingDomainNames(PrintStream out, Collection<Pattern> patterns) {
        block0: for (Domain domain : this._domains.values()) {
            for (Pattern pattern : patterns) {
                String name;
                if (!pattern.matcher(name = domain.getName()).matches()) continue;
                out.println(name);
                continue block0;
            }
        }
    }
}

