/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.auth.persistence;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.Persistence;
import org.dcache.auth.AuthorizationRecord;
import org.dcache.auth.Group;
import org.dcache.auth.GroupList;
import org.dcache.srm.SRMUser;
import org.dcache.srm.SRMUserPersistenceManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthRecordPersistenceManager
implements SRMUserPersistenceManager {
    private Map<Long, AuthorizationRecord> authRecCache = new HashMap<Long, AuthorizationRecord>();
    private static final Logger _logJpa = LoggerFactory.getLogger(AuthRecordPersistenceManager.class);
    EntityManager em;

    public AuthRecordPersistenceManager(String propertiesFile) throws IOException {
        Properties p = new Properties();
        p.load(new FileInputStream(propertiesFile));
        EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)"AuthRecordPersistenceUnit", (Map)p);
        this.em = emf.createEntityManager();
    }

    public AuthRecordPersistenceManager(String jdbcUrl, String jdbcDriver, String user, String pass) {
        _logJpa.debug("<init>(" + jdbcUrl + "," + jdbcDriver + "," + user + "," + pass + ")");
        Properties p = new Properties();
        p.setProperty("javax.persistence.jdbc.driver", jdbcDriver);
        p.setProperty("javax.persistence.jdbc.url", jdbcUrl);
        p.setProperty("javax.persistence.jdbc.user", user);
        p.setProperty("javax.persistence.jdbc.password", pass);
        EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)"AuthRecordPersistenceUnit", (Map)p);
        this.em = emf.createEntityManager();
    }

    public SRMUser persist(SRMUser user) {
        if (user instanceof AuthorizationRecord) {
            return this.persist((AuthorizationRecord)user);
        }
        throw new IllegalArgumentException("illegal user type: " + user.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized AuthorizationRecord persist(AuthorizationRecord rec) {
        if (this.authRecCache.containsKey(rec.getId())) {
            return this.authRecCache.get(rec.getId());
        }
        EntityTransaction t = this.em.getTransaction();
        try {
            t.begin();
            if (!this.em.contains((Object)rec)) {
                _logJpa.debug("em.contains() returned false");
                AuthorizationRecord rec1 = (AuthorizationRecord)this.em.find(AuthorizationRecord.class, (Object)rec.getId());
                if (rec1 == null) {
                    _logJpa.debug("em.find() returned null, persisting");
                    this.em.persist((Object)rec);
                } else {
                    rec = rec1;
                }
            }
            t.commit();
        }
        finally {
            if (t.isActive()) {
                t.rollback();
            }
        }
        if (this.authRecCache.containsKey(rec.getId())) {
            return this.authRecCache.get(rec.getId());
        }
        this.authRecCache.put(rec.getId(), rec);
        return rec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized AuthorizationRecord find(long id) {
        if (this.authRecCache.containsKey(id)) {
            return this.authRecCache.get(id);
        }
        AuthorizationRecord ar = null;
        EntityTransaction t = this.em.getTransaction();
        try {
            t.begin();
            _logJpa.debug(" searching for AuthorizationRecord with id=" + id);
            ar = (AuthorizationRecord)this.em.find(AuthorizationRecord.class, (Object)id);
            _logJpa.debug("found AuthorizationRecord=" + ar);
            t.commit();
        }
        finally {
            if (t.isActive()) {
                t.rollback();
            }
        }
        if (ar == null) {
            return null;
        }
        if (this.authRecCache.containsKey(id)) {
            return this.authRecCache.get(id);
        }
        this.authRecCache.put(id, ar);
        return ar;
    }

    public static void main(String[] args) {
        if (args == null || args.length == 0) {
            AuthRecordPersistenceManager.persistTest();
        } else {
            AuthRecordPersistenceManager.findTest(Long.parseLong(args[0]));
        }
    }

    public static void persistTest() {
        AuthRecordPersistenceManager pm = new AuthRecordPersistenceManager("jdbc:postgresql://localhost/testjpa", "org.postgresql.Driver", "srmdcache", "");
        HashSet<String> principals = new HashSet<String>();
        principals.add("timur@FNAL.GOV");
        AuthorizationRecord ar = new AuthorizationRecord();
        ar.setId(System.currentTimeMillis());
        ar.setHome("/");
        ar.setUid(10401);
        ar.setName("timur");
        ar.setIdentity("timur@FNAL.GOV");
        ar.setReadOnly(false);
        ar.setPriority(10);
        ar.setRoot("/pnfs/fnal.gov/usr");
        GroupList gl1 = new GroupList();
        gl1.setAuthRecord(ar);
        Group group11 = new Group();
        Group group12 = new Group();
        Group group13 = new Group();
        group11.setGroupList(gl1);
        group12.setGroupList(gl1);
        group13.setGroupList(gl1);
        group11.setName("Group1");
        group11.setGid(1530);
        group12.setName("Group2");
        group12.setGid(1531);
        group13.setName("Group3");
        group13.setGid(1533);
        LinkedList<Group> l1 = new LinkedList<Group>();
        l1.add(group11);
        l1.add(group12);
        l1.add(group13);
        gl1.setAttribute(null);
        gl1.setGroups(l1);
        GroupList gl2 = new GroupList();
        gl2.setAuthRecord(ar);
        Group group21 = new Group();
        Group group22 = new Group();
        group21.setGroupList(gl2);
        group22.setGroupList(gl2);
        group21.setName("Group4");
        group21.setGid(2530);
        group22.setName("Group5");
        group22.setGid(2530);
        LinkedList<Group> l2 = new LinkedList<Group>();
        l2.add(group21);
        l2.add(group22);
        gl2.setAttribute(null);
        gl2.setGroups(l2);
        LinkedList<GroupList> gll = new LinkedList<GroupList>();
        gll.add(gl1);
        gll.add(gl2);
        ar.setGroupLists(gll);
        System.out.println("persisting " + ar);
        pm.persist(ar);
        System.out.println("persisted successfully ");
        System.out.println("id=" + ar.getId());
    }

    public static void findTest(long id) {
        AuthRecordPersistenceManager pm = new AuthRecordPersistenceManager("jdbc:postgresql://localhost/testjpa", "org.postgresql.Driver", "srmdcache", "");
        AuthorizationRecord ar = pm.find(id);
        if (ar == null) {
            System.out.println("AuthorizationRecord with id=" + id + " not found ");
        }
        System.out.println(" found " + ar);
    }
}

