/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.auth;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.Subject;
import org.dcache.auth.Subjects;
import org.dcache.auth.attributes.LoginAttribute;

public class LoginReply {
    private Subject _subject;
    private Set<LoginAttribute> _attributes;

    public LoginReply() {
        this._subject = new Subject();
        this._attributes = new HashSet<LoginAttribute>();
    }

    public LoginReply(Subject subject, Set<LoginAttribute> attributes) {
        this._subject = subject;
        this._attributes = attributes;
    }

    public Subject getSubject() {
        return this._subject;
    }

    public Set<LoginAttribute> getLoginAttributes() {
        return this._attributes;
    }

    public <T extends LoginAttribute> Set<T> getLoginAttributes(Class<T> type) {
        HashSet<LoginAttribute> result = new HashSet<LoginAttribute>();
        for (LoginAttribute element : this._attributes) {
            if (!type.isInstance(element)) continue;
            result.add(element);
        }
        return result;
    }

    public String toString() {
        String name = Subjects.getDisplayName((Subject)this._subject);
        if (Subjects.isNobody((Subject)this._subject)) {
            return "Login[" + name + "," + this._attributes + "]";
        }
        return "Login[" + name + "," + Subjects.getUid((Subject)this._subject) + ":" + Arrays.toString(Subjects.getGids((Subject)this._subject)) + "," + this._attributes + "]";
    }
}

